/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.classes;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.List;
import org.androidtransfuse.adapter.ASTAccessModifier;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTConstructor;
import org.androidtransfuse.adapter.ASTParameter;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.ASTUtils;

public class ASTClassConstructor
implements ASTConstructor {
    private final Constructor constructor;
    private final ImmutableList<ASTParameter> parameters;
    private final ASTAccessModifier modifier;
    private final ImmutableSet<ASTAnnotation> annotations;
    private final ImmutableSet<ASTType> throwsTypes;

    public ASTClassConstructor(ImmutableSet<ASTAnnotation> annotations, Constructor<?> constructor, ImmutableList<ASTParameter> parameters, ASTAccessModifier modifier, ImmutableSet<ASTType> throwsTypes) {
        this.annotations = annotations;
        this.constructor = constructor;
        this.parameters = parameters;
        this.modifier = modifier;
        this.throwsTypes = throwsTypes;
    }

    @Override
    public boolean isAnnotated(Class<? extends Annotation> annotation) {
        return this.constructor.isAnnotationPresent(annotation);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotation) {
        return this.constructor.getAnnotation(annotation);
    }

    @Override
    public List<ASTParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public String getName() {
        return this.constructor.getName();
    }

    @Override
    public ImmutableSet<ASTAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public ASTAccessModifier getAccessModifier() {
        return this.modifier;
    }

    @Override
    public ImmutableSet<ASTType> getThrowsTypes() {
        return this.throwsTypes;
    }

    @Override
    public ASTAnnotation getASTAnnotation(Class<? extends Annotation> annotation) {
        return ASTUtils.getInstance().getAnnotation(annotation, this.getAnnotations());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.constructor.getModifiers());
    }

    public String toString() {
        return this.constructor.getName() + "(" + Joiner.on((String)", ").join(this.parameters) + ")";
    }
}

