/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.classes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.androidtransfuse.adapter.ASTAccessModifier;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTArrayType;
import org.androidtransfuse.adapter.ASTConstructor;
import org.androidtransfuse.adapter.ASTFactory;
import org.androidtransfuse.adapter.ASTField;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTParameter;
import org.androidtransfuse.adapter.ASTPrimitiveType;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.ASTTypeVirtualProxy;
import org.androidtransfuse.adapter.ASTVoidType;
import org.androidtransfuse.adapter.PackageClass;
import org.androidtransfuse.adapter.classes.ASTClassAnnotation;
import org.androidtransfuse.adapter.classes.ASTClassConstructor;
import org.androidtransfuse.adapter.classes.ASTClassField;
import org.androidtransfuse.adapter.classes.ASTClassMethod;
import org.androidtransfuse.adapter.classes.ASTClassParameter;
import org.androidtransfuse.adapter.classes.ASTClassType;

@Singleton
public class ASTClassFactory {
    private final Map<String, ASTType> typeCache = new HashMap<String, ASTType>();
    private final ASTFactory astFactory;

    @Inject
    public ASTClassFactory(ASTFactory astFactory) {
        this.astFactory = astFactory;
        this.typeCache.put(ASTVoidType.VOID.getName(), ASTVoidType.VOID);
        for (ASTPrimitiveType primitive : ASTPrimitiveType.values()) {
            this.typeCache.put(primitive.getName(), primitive);
        }
    }

    public ASTType getType(Class<?> clazz) {
        return this.getType(clazz, null);
    }

    private synchronized ASTType getType(Class<?> clazz, Type genericType) {
        if (clazz.isArray()) {
            return new ASTArrayType(this.getType(clazz.getComponentType(), genericType));
        }
        if (!this.typeCache.containsKey(clazz.getName())) {
            this.typeCache.put(clazz.getName(), this.buildType(clazz));
        }
        ASTType astType = this.typeCache.get(clazz.getName());
        if (genericType instanceof ParameterizedType) {
            astType = this.astFactory.buildGenericTypeWrapper(astType, this.astFactory.buildParameterBuilder((ParameterizedType)genericType));
        }
        return astType;
    }

    private ASTType buildType(Class<?> clazz) {
        ImmutableSet.Builder constructorBuilder = ImmutableSet.builder();
        ImmutableSet.Builder methodBuilder = ImmutableSet.builder();
        ImmutableSet.Builder fieldBuilder = ImmutableSet.builder();
        ASTType superClass = null;
        if (clazz.getSuperclass() != null) {
            superClass = this.getType(clazz.getSuperclass(), clazz.getGenericSuperclass());
        }
        ImmutableSet.Builder interfaceBuilder = ImmutableSet.builder();
        ImmutableSet.Builder annotationBuilder = ImmutableSet.builder();
        PackageClass packageClass = new PackageClass(clazz);
        ASTTypeVirtualProxy astClassTypeProxy = new ASTTypeVirtualProxy(packageClass);
        this.typeCache.put(clazz.getName(), astClassTypeProxy);
        Class<?>[] classInterfaces = clazz.getInterfaces();
        Type[] classGenericInterfaces = clazz.getGenericInterfaces();
        for (int i = 0; i < classInterfaces.length; ++i) {
            interfaceBuilder.add((Object)this.getType(classInterfaces[i], classGenericInterfaces[i]));
        }
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            constructorBuilder.add((Object)this.getConstructor(constructor));
        }
        for (Executable executable : clazz.getDeclaredMethods()) {
            methodBuilder.add((Object)this.getMethod((Method)executable));
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            fieldBuilder.add((Object)this.getField((Field)accessibleObject));
        }
        annotationBuilder.addAll(this.getAnnotations(clazz));
        ASTClassType astType = new ASTClassType(clazz, packageClass, (ImmutableSet<ASTAnnotation>)annotationBuilder.build(), (ImmutableSet<ASTConstructor>)constructorBuilder.build(), (ImmutableSet<ASTMethod>)methodBuilder.build(), (ImmutableSet<ASTField>)fieldBuilder.build(), superClass, (ImmutableSet<ASTType>)interfaceBuilder.build());
        astClassTypeProxy.load(astType);
        return astType;
    }

    public ImmutableList<ASTParameter> getParameters(Method method) {
        return this.getParameters(method.getParameterTypes(), method.getGenericParameterTypes(), method.getParameterAnnotations());
    }

    public ImmutableList<ASTParameter> getParameters(Class<?>[] parameterTypes, Type[] genericParameterTypes, Annotation[][] parameterAnnotations) {
        ImmutableList.Builder astParameterBuilder = ImmutableList.builder();
        for (int i = 0; i < parameterTypes.length; ++i) {
            ASTType parameterType = this.getType(parameterTypes[i], this.nullSafeAccess(genericParameterTypes, i));
            String name = null;
            for (Annotation parameterAnnotation : parameterAnnotations[i]) {
                if (!parameterAnnotation.annotationType().equals(ASTParameterName.class)) continue;
                name = ((ASTParameterName)parameterAnnotation).value();
            }
            astParameterBuilder.add((Object)new ASTClassParameter(name, parameterAnnotations[i], parameterType, this.getAnnotations(parameterAnnotations[i])));
        }
        return astParameterBuilder.build();
    }

    private Type nullSafeAccess(Type[] typeArray, int i) {
        if (typeArray.length > i) {
            return typeArray[i];
        }
        return null;
    }

    public ASTMethod getMethod(Method method) {
        ImmutableList<ASTParameter> astParameters = this.getParameters(method);
        ASTAccessModifier modifier = ASTAccessModifier.getModifier(method.getModifiers());
        ImmutableSet<ASTType> throwsTypes = this.getTypes(method.getExceptionTypes());
        return new ASTClassMethod(method, this.getType(method.getReturnType(), method.getGenericReturnType()), astParameters, modifier, this.getAnnotations(method), throwsTypes);
    }

    private ImmutableSet<ASTType> getTypes(Class<?>[] inputClasses) {
        ImmutableSet.Builder typesBuilder = ImmutableSet.builder();
        for (Class<?> inputClass : inputClasses) {
            typesBuilder.add((Object)this.getType(inputClass));
        }
        return typesBuilder.build();
    }

    public ASTField getField(Field field) {
        ASTAccessModifier modifier = ASTAccessModifier.getModifier(field.getModifiers());
        return new ASTClassField(field, this.getType(field.getType(), field.getGenericType()), modifier, this.getAnnotations(field));
    }

    public ASTConstructor getConstructor(Constructor constructor) {
        ASTAccessModifier modifier = ASTAccessModifier.getModifier(constructor.getModifiers());
        ImmutableList<ASTParameter> constructorParameters = this.getParameters(constructor.getParameterTypes(), constructor.getGenericParameterTypes(), constructor.getParameterAnnotations());
        ImmutableSet<ASTType> throwsTypes = this.getTypes(constructor.getExceptionTypes());
        return new ASTClassConstructor(this.getAnnotations(constructor), constructor, constructorParameters, modifier, throwsTypes);
    }

    private ImmutableSet<ASTAnnotation> getAnnotations(AnnotatedElement element) {
        return this.getAnnotations(element.getAnnotations());
    }

    private ImmutableSet<ASTAnnotation> getAnnotations(Annotation[] annotations) {
        ImmutableSet.Builder astAnnotationBuilder = ImmutableSet.builder();
        for (Annotation annotation : annotations) {
            astAnnotationBuilder.add((Object)this.getAnnotation(annotation));
        }
        return astAnnotationBuilder.build();
    }

    public ASTAnnotation getAnnotation(Annotation annotation) {
        ASTType type = this.getType(annotation.annotationType());
        return new ASTClassAnnotation(annotation, type, this);
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ASTParameterName {
        public String value();
    }
}

