/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.classes;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.androidtransfuse.adapter.ASTAccessModifier;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTParameter;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.ASTUtils;

public class ASTClassMethod
implements ASTMethod {
    private final Method method;
    private final ImmutableList<ASTParameter> parameters;
    private final ASTType returnType;
    private final ASTAccessModifier modifier;
    private final ImmutableSet<ASTAnnotation> annotations;
    private final ImmutableSet<ASTType> throwTypes;

    public ASTClassMethod(Method method, ASTType returnType, ImmutableList<ASTParameter> parameters, ASTAccessModifier modifier, ImmutableSet<ASTAnnotation> annotations, ImmutableSet<ASTType> throwTypes) {
        this.method = method;
        this.parameters = parameters;
        this.returnType = returnType;
        this.modifier = modifier;
        this.annotations = annotations;
        this.throwTypes = throwTypes;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotation) {
        return this.method.getAnnotation(annotation);
    }

    @Override
    public boolean isAnnotated(Class<? extends Annotation> annotation) {
        return this.method.isAnnotationPresent(annotation);
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.method.getModifiers());
    }

    @Override
    public ImmutableList<ASTParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public ASTType getReturnType() {
        return this.returnType;
    }

    @Override
    public ImmutableSet<ASTAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public ASTAccessModifier getAccessModifier() {
        return this.modifier;
    }

    @Override
    public ImmutableSet<ASTType> getThrowsTypes() {
        return this.throwTypes;
    }

    @Override
    public ASTAnnotation getASTAnnotation(Class<? extends Annotation> annotation) {
        return ASTUtils.getInstance().getAnnotation(annotation, this.getAnnotations());
    }

    public String toString() {
        return this.method.getName() + "(" + Joiner.on((String)", ").join(this.parameters) + ")";
    }
}

