/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.classes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTParameter;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.ASTUtils;

public class ASTClassParameter
implements ASTParameter {
    private final String name;
    private final ASTType astType;
    private final ImmutableMap<Class<? extends Annotation>, Annotation> annotationMap;
    private final ImmutableSet<ASTAnnotation> annotations;

    public ASTClassParameter(String name, Annotation[] annotations, ASTType astType, ImmutableSet<ASTAnnotation> astAnnotations) {
        this.name = name;
        this.annotations = astAnnotations;
        this.astType = astType;
        ImmutableMap.Builder classAnnotationBuilder = ImmutableMap.builder();
        for (Annotation annotation : annotations) {
            classAnnotationBuilder.put(annotation.annotationType(), (Object)annotation);
        }
        this.annotationMap = classAnnotationBuilder.build();
    }

    @Override
    public boolean isAnnotated(Class<? extends Annotation> annotation) {
        return this.annotationMap.containsKey(annotation);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotation) {
        return (A)((Annotation)this.annotationMap.get(annotation));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ASTType getASTType() {
        return this.astType;
    }

    @Override
    public ImmutableSet<ASTAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public ASTAnnotation getASTAnnotation(Class<? extends Annotation> annotation) {
        return ASTUtils.getInstance().getAnnotation(annotation, this.getAnnotations());
    }

    public String toString() {
        if (this.name != null) {
            return this.astType.getPackageClass().getClassName() + " " + this.name;
        }
        return this.astType.getPackageClass().getClassName();
    }
}

