/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.classes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTConstructor;
import org.androidtransfuse.adapter.ASTField;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.ASTUtils;
import org.androidtransfuse.adapter.PackageClass;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ASTClassType
implements ASTType {
    private final Class<?> clazz;
    private final PackageClass packageClass;
    private final ImmutableSet<ASTAnnotation> annotationList;
    private final ImmutableSet<ASTMethod> methods;
    private final ImmutableSet<ASTConstructor> constructors;
    private final ImmutableSet<ASTField> fields;
    private final ASTType superClass;
    private final ImmutableSet<ASTType> interfaces;

    public ASTClassType(Class<?> clazz, PackageClass packageClass, ImmutableSet<ASTAnnotation> annotationList, ImmutableSet<ASTConstructor> constructors, ImmutableSet<ASTMethod> methods, ImmutableSet<ASTField> fields, ASTType superClass, ImmutableSet<ASTType> interfaces) {
        this.clazz = clazz;
        this.packageClass = packageClass;
        this.annotationList = annotationList;
        this.constructors = constructors;
        this.methods = methods;
        this.fields = fields;
        this.superClass = superClass;
        this.interfaces = interfaces;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotation) {
        return this.clazz.getAnnotation(annotation);
    }

    @Override
    public boolean isAnnotated(Class<? extends Annotation> annotation) {
        return this.clazz.isAnnotationPresent(annotation);
    }

    @Override
    public ImmutableSet<ASTMethod> getMethods() {
        return this.methods;
    }

    @Override
    public ImmutableSet<ASTField> getFields() {
        return this.fields;
    }

    @Override
    public ImmutableSet<ASTConstructor> getConstructors() {
        return this.constructors;
    }

    @Override
    public String getName() {
        return this.packageClass.getCanonicalName();
    }

    @Override
    public boolean isConcreteClass() {
        return !this.clazz.isInterface() && !this.clazz.isSynthetic();
    }

    @Override
    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.clazz.getModifiers());
    }

    @Override
    public boolean isEnum() {
        return this.clazz.isEnum();
    }

    @Override
    public ImmutableSet<ASTAnnotation> getAnnotations() {
        return this.annotationList;
    }

    @Override
    public ASTType getSuperClass() {
        return this.superClass;
    }

    @Override
    public ImmutableSet<ASTType> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public PackageClass getPackageClass() {
        return this.packageClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ASTType)) {
            return false;
        }
        ASTType that = (ASTType)o;
        return new EqualsBuilder().append((Object)this.getName(), (Object)that.getName()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).hashCode();
    }

    @Override
    public ImmutableList<ASTType> getGenericParameters() {
        return ImmutableList.of();
    }

    @Override
    public boolean inheritsFrom(ASTType type) {
        return ASTUtils.getInstance().inherits(this, type, true, true);
    }

    @Override
    public boolean extendsFrom(ASTType type) {
        return ASTUtils.getInstance().inherits(this, type, false, true);
    }

    @Override
    public boolean implementsFrom(ASTType type) {
        return ASTUtils.getInstance().inherits(this, type, true, false);
    }

    @Override
    public ASTAnnotation getASTAnnotation(Class<? extends Annotation> annotation) {
        return ASTUtils.getInstance().getAnnotation(annotation, this.getAnnotations());
    }

    public String toString() {
        return this.getName();
    }
}

