/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.classes;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Provider;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.classes.ASTClassFactory;

public class ReloadableASTClassFactory
implements Function<Class, Provider<ASTType>> {
    private final ASTClassFactory astClassFactory;

    @Inject
    public ReloadableASTClassFactory(ASTClassFactory astClassFactory) {
        this.astClassFactory = astClassFactory;
    }

    public Collection<Provider<ASTType>> buildProviders(Collection<? extends Class> classes) {
        return Collections2.transform(classes, (Function)this);
    }

    public Provider<ASTType> apply(Class clazz) {
        return new ASTClassProvider(this.astClassFactory.getType(clazz));
    }

    public class ASTClassProvider
    implements Provider<ASTType> {
        ASTType type;

        public ASTClassProvider(ASTType type) {
            this.type = type;
        }

        public ASTType get() {
            return this.type;
        }
    }
}

