/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.element;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTBase;
import org.androidtransfuse.adapter.ASTUtils;

public class ASTElementBase
implements ASTBase {
    private final Element element;
    private final ImmutableSet<ASTAnnotation> annotations;

    public ASTElementBase(Element element, ImmutableSet<ASTAnnotation> annotations) {
        this.element = element;
        this.annotations = annotations;
    }

    @Override
    public boolean isAnnotated(Class<? extends Annotation> annotation) {
        return this.getASTAnnotation(annotation) != null;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotation) {
        return this.element.getAnnotation(annotation);
    }

    @Override
    public String getName() {
        return this.element.getSimpleName().toString();
    }

    public boolean isStatic() {
        return this.element.getModifiers().contains((Object)Modifier.STATIC);
    }

    public boolean isFinal() {
        return this.element.getModifiers().contains((Object)Modifier.FINAL);
    }

    @Override
    public ImmutableSet<ASTAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public ASTAnnotation getASTAnnotation(Class<? extends Annotation> annotation) {
        return ASTUtils.getInstance().getAnnotation(annotation, this.getAnnotations());
    }

    public Element getElement() {
        return this.element;
    }
}

