/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.element;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.androidtransfuse.adapter.ASTAccessModifier;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTBase;
import org.androidtransfuse.adapter.ASTConstructor;
import org.androidtransfuse.adapter.ASTFactory;
import org.androidtransfuse.adapter.ASTField;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTParameter;
import org.androidtransfuse.adapter.ASTStringType;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.ASTTypeVirtualProxy;
import org.androidtransfuse.adapter.PackageClass;
import org.androidtransfuse.adapter.element.ASTElementConstructor;
import org.androidtransfuse.adapter.element.ASTElementConverterFactory;
import org.androidtransfuse.adapter.element.ASTElementField;
import org.androidtransfuse.adapter.element.ASTElementMethod;
import org.androidtransfuse.adapter.element.ASTElementParameter;
import org.androidtransfuse.adapter.element.ASTElementType;
import org.androidtransfuse.adapter.element.ASTTypeBuilderVisitor;
import org.androidtransfuse.adapter.element.LazyASTType;
import org.androidtransfuse.util.Logger;

@Singleton
public class ASTElementFactory {
    private final Map<TypeElement, ASTType> typeCache = new HashMap<TypeElement, ASTType>();
    private final Map<PackageClass, ASTType> blacklist = new HashMap<PackageClass, ASTType>();
    private final ASTElementConverterFactory astElementConverterFactory;
    private final ASTTypeBuilderVisitor astTypeBuilderVisitor;
    private final ASTFactory astFactory;
    private final Elements elements;
    private final Logger log;

    @Inject
    public ASTElementFactory(Elements elements, ASTFactory astFactory, ASTTypeBuilderVisitor astTypeBuilderVisitor, ASTElementConverterFactory astElementConverterFactory, Logger log) {
        this.elements = elements;
        this.astFactory = astFactory;
        this.astTypeBuilderVisitor = astTypeBuilderVisitor;
        this.astElementConverterFactory = astElementConverterFactory;
        this.log = log;
        this.blacklist.put(new PackageClass("android.support.v4.app", "DialogFragment"), new ASTStubType("android.support.v4.app.DialogFragment", "android.support.v4.app.Fragment"));
        this.blacklist.put(new PackageClass("android.support.v4.widget", "DrawerLayout"), new ASTStubType("android.support.v4.widget.DrawerLayout", "android.view.ViewGroup"));
    }

    public ASTType buildASTElementType(DeclaredType declaredType) {
        ASTType astType = this.getType((TypeElement)declaredType.asElement());
        if (!declaredType.getTypeArguments().isEmpty()) {
            return this.astFactory.buildGenericTypeWrapper(astType, this.astFactory.buildParameterBuilder(declaredType));
        }
        return astType;
    }

    public synchronized ASTType getType(final TypeElement typeElement) {
        return new LazyASTType(this.buildPackageClass(typeElement)){

            @Override
            public ASTType lazyLoad() {
                if (!ASTElementFactory.this.typeCache.containsKey(typeElement)) {
                    ASTElementFactory.this.typeCache.put(typeElement, ASTElementFactory.this.buildType(typeElement));
                }
                return (ASTType)ASTElementFactory.this.typeCache.get(typeElement);
            }
        };
    }

    public ASTType getType(Class clazz) {
        return this.getType(this.elements.getTypeElement(clazz.getCanonicalName()));
    }

    private ASTType buildType(TypeElement typeElement) {
        this.log.debug("ASTElementType building: " + typeElement.getQualifiedName());
        PackageClass packageClass = this.buildPackageClass(typeElement);
        if (this.blacklist.containsKey(packageClass)) {
            return this.blacklist.get(packageClass);
        }
        ASTTypeVirtualProxy astTypeProxy = new ASTTypeVirtualProxy(packageClass);
        this.typeCache.put(typeElement, astTypeProxy);
        ASTType superClass = null;
        if (typeElement.getSuperclass() != null) {
            superClass = typeElement.getSuperclass().accept(this.astTypeBuilderVisitor, null);
        }
        ImmutableSet interfaces = FluentIterable.from(typeElement.getInterfaces()).transform((Function)this.astTypeBuilderVisitor).toSet();
        ImmutableSet.Builder annotations = ImmutableSet.builder();
        ImmutableSet.Builder constructors = ImmutableSet.builder();
        ImmutableSet.Builder fields = ImmutableSet.builder();
        ImmutableSet.Builder methods = ImmutableSet.builder();
        annotations.addAll(this.getAnnotations(typeElement));
        constructors.addAll(this.transformAST(typeElement.getEnclosedElements(), ASTConstructor.class));
        fields.addAll(this.transformAST(typeElement.getEnclosedElements(), ASTField.class));
        methods.addAll(this.transformAST(typeElement.getEnclosedElements(), ASTMethod.class));
        ASTElementType astType = new ASTElementType(packageClass, typeElement, (ImmutableSet<ASTConstructor>)constructors.build(), (ImmutableSet<ASTMethod>)methods.build(), (ImmutableSet<ASTField>)fields.build(), superClass, (ImmutableSet<ASTType>)interfaces, (ImmutableSet<ASTAnnotation>)annotations.build());
        astTypeProxy.load(astType);
        return astType;
    }

    private PackageClass buildPackageClass(TypeElement typeElement) {
        PackageElement packageElement = this.elements.getPackageOf(typeElement);
        String pkg = packageElement.getQualifiedName().toString();
        String qualifiedName = typeElement.getQualifiedName().toString();
        String name = !pkg.isEmpty() && pkg.length() < qualifiedName.length() ? qualifiedName.substring(pkg.length() + 1) : qualifiedName;
        return new PackageClass(pkg, name);
    }

    private <T extends ASTBase> List<T> transformAST(List<? extends Element> enclosedElements, Class<T> astType) {
        return FluentIterable.from(enclosedElements).transform(this.astElementConverterFactory.buildASTElementConverter(astType)).filter(Predicates.notNull()).toList();
    }

    public ASTField getField(VariableElement variableElement) {
        ASTAccessModifier modifier = this.buildAccessModifier(variableElement);
        return new ASTElementField(variableElement, this.astTypeBuilderVisitor, modifier, this.getAnnotations(variableElement));
    }

    private ASTAccessModifier buildAccessModifier(Element element) {
        for (Modifier elementModifier : element.getModifiers()) {
            switch (elementModifier) {
                case PUBLIC: {
                    return ASTAccessModifier.PUBLIC;
                }
                case PROTECTED: {
                    return ASTAccessModifier.PROTECTED;
                }
                case PRIVATE: {
                    return ASTAccessModifier.PRIVATE;
                }
            }
        }
        return ASTAccessModifier.PACKAGE_PRIVATE;
    }

    public ASTMethod getMethod(ExecutableElement executableElement) {
        ImmutableList<ASTParameter> parameters = this.getParameters(executableElement.getParameters());
        ASTAccessModifier modifier = this.buildAccessModifier(executableElement);
        ImmutableSet<ASTType> throwsTypes = this.buildASTElementTypes(executableElement.getThrownTypes());
        return new ASTElementMethod(executableElement, this.astTypeBuilderVisitor, parameters, modifier, this.getAnnotations(executableElement), throwsTypes);
    }

    private ImmutableSet<ASTType> buildASTElementTypes(List<? extends TypeMirror> mirrorTypes) {
        return FluentIterable.from(mirrorTypes).transform((Function)this.astTypeBuilderVisitor).toSet();
    }

    private ImmutableList<ASTParameter> getParameters(List<? extends VariableElement> variableElements) {
        ImmutableList.Builder astParameterBuilder = ImmutableList.builder();
        for (VariableElement variableElement : variableElements) {
            astParameterBuilder.add((Object)this.getParameter(variableElement));
        }
        return astParameterBuilder.build();
    }

    public ASTParameter getParameter(Element variableElement) {
        return new ASTElementParameter(variableElement, this.astTypeBuilderVisitor, this.getAnnotations(variableElement));
    }

    public ASTConstructor getConstructor(ExecutableElement executableElement) {
        ImmutableList<ASTParameter> parameters = this.getParameters(executableElement.getParameters());
        ASTAccessModifier modifier = this.buildAccessModifier(executableElement);
        ImmutableSet<ASTType> throwsTypes = this.buildASTElementTypes(executableElement.getThrownTypes());
        return new ASTElementConstructor(executableElement, parameters, modifier, this.getAnnotations(executableElement), throwsTypes);
    }

    private ImmutableSet<ASTAnnotation> getAnnotations(Element element) {
        ImmutableSet.Builder annotationBuilder = ImmutableSet.builder();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            ASTType type = this.getType((TypeElement)annotationMirror.getAnnotationType().asElement());
            annotationBuilder.add((Object)this.astFactory.buildASTElementAnnotation(annotationMirror, type));
        }
        return annotationBuilder.build();
    }

    public ASTMethod findMethod(ASTType type, String methodName, ASTType ... args) {
        ASTType updatedType;
        TypeElement typeElement = this.elements.getTypeElement(type.getName());
        for (ASTType typeLoop = updatedType = this.getType(typeElement); typeLoop != null; typeLoop = typeLoop.getSuperClass()) {
            for (ASTMethod astMethod : typeLoop.getMethods()) {
                if (!astMethod.getName().equals(methodName) || !this.parametersMatch((List<ASTParameter>)astMethod.getParameters(), args)) continue;
                return astMethod;
            }
        }
        return null;
    }

    private boolean parametersMatch(List<ASTParameter> parameters, ASTType[] args) {
        if (args == null) {
            return parameters.isEmpty();
        }
        if (parameters.size() != args.length) {
            return false;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            if (parameters.get(i).getASTType().getName().equals(args[i].getName())) continue;
            return false;
        }
        return true;
    }

    public class ASTStubType
    extends ASTStringType {
        private final Set<String> implementing;
        private final String extending;

        public ASTStubType(String name, String extending) {
            super(name);
            this.implementing = new HashSet<String>();
            this.extending = extending;
        }

        @Override
        public ASTType getSuperClass() {
            return ASTElementFactory.this.getType(ASTElementFactory.this.elements.getTypeElement(this.extending));
        }

        @Override
        public ImmutableSet<ASTType> getInterfaces() {
            return FluentIterable.from(this.implementing).transform((Function)new Function<String, ASTType>(){

                @Nullable
                public ASTType apply(String input) {
                    return ASTElementFactory.this.getType(ASTElementFactory.this.elements.getTypeElement(input));
                }
            }).toSet();
        }

        public ASTStubType addImplements(String extension) {
            this.implementing.add(extension);
            return this;
        }
    }
}

