/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.element;

import com.google.common.collect.ImmutableSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import org.androidtransfuse.adapter.ASTAccessModifier;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTField;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.element.ASTElementBase;
import org.androidtransfuse.adapter.element.ASTTypeBuilderVisitor;
import org.androidtransfuse.adapter.element.ASTTypeLazyLoader;
import org.androidtransfuse.adapter.element.ElementASTTypeLazyLoader;

public class ASTElementField
extends ASTElementBase
implements ASTField {
    private final ASTTypeLazyLoader<Element> astTypeLoader;
    private final ASTAccessModifier modifier;
    private final VariableElement variableElement;

    public ASTElementField(VariableElement variableElement, ASTTypeBuilderVisitor astTypeBuilderVisitor, ASTAccessModifier modifier, ImmutableSet<ASTAnnotation> annotations) {
        super(variableElement, annotations);
        this.variableElement = variableElement;
        this.modifier = modifier;
        this.astTypeLoader = new ElementASTTypeLazyLoader(variableElement, astTypeBuilderVisitor);
    }

    @Override
    public synchronized ASTType getASTType() {
        return this.astTypeLoader.getASTType();
    }

    @Override
    public ASTAccessModifier getAccessModifier() {
        return this.modifier;
    }

    @Override
    public Object getConstantValue() {
        return this.variableElement.getConstantValue();
    }

    @Override
    public boolean isTransient() {
        return this.variableElement.getModifiers().contains((Object)Modifier.TRANSIENT);
    }

    public String toString() {
        return this.astTypeLoader.getASTType().getPackageClass().getClassName() + " " + this.variableElement.getSimpleName();
    }
}

