/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.element;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.androidtransfuse.TransfuseAdapterException;
import org.androidtransfuse.adapter.ASTArrayType;
import org.androidtransfuse.adapter.ASTEmptyType;
import org.androidtransfuse.adapter.ASTIntersectionType;
import org.androidtransfuse.adapter.ASTPrimitiveType;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.ASTVoidType;
import org.androidtransfuse.adapter.ASTWildcardType;
import org.androidtransfuse.adapter.element.ASTElementFactory;
import org.androidtransfuse.transaction.TransactionRuntimeException;

public class ASTTypeBuilderVisitor
extends SimpleTypeVisitor6<ASTType, Void>
implements Function<TypeMirror, ASTType> {
    private final Provider<ASTElementFactory> astElementFactoryProvider;

    @Inject
    public ASTTypeBuilderVisitor(Provider<ASTElementFactory> astElementFactoryProvider) {
        this.astElementFactoryProvider = astElementFactoryProvider;
    }

    @Override
    public ASTType visitPrimitive(PrimitiveType primitiveType, Void v) {
        return ASTPrimitiveType.valueOf(primitiveType.getKind().name());
    }

    @Override
    public ASTType visitNull(NullType nullType, Void v) {
        throw new TransfuseAdapterException("Encountered NullType, unable to recover");
    }

    @Override
    public ASTType visitArray(ArrayType arrayType, Void v) {
        return new ASTArrayType(arrayType.getComponentType().accept(this, null));
    }

    @Override
    public ASTType visitDeclared(DeclaredType declaredType, Void v) {
        return ((ASTElementFactory)this.astElementFactoryProvider.get()).buildASTElementType(declaredType);
    }

    @Override
    public ASTType visitError(ErrorType errorType, Void v) {
        throw new TransactionRuntimeException("Encountered ErrorType " + errorType.asElement().getSimpleName() + ", unable to recover");
    }

    @Override
    public ASTType visitTypeVariable(TypeVariable typeVariable, Void v) {
        return typeVariable.getUpperBound().accept(this, null);
    }

    @Override
    public ASTType visitWildcard(WildcardType wildcardType, Void v) {
        ASTType extendsBound = null;
        ASTType superBound = null;
        if (wildcardType.getSuperBound() != null) {
            superBound = wildcardType.getSuperBound().accept(this, null);
        }
        if (wildcardType.getExtendsBound() != null) {
            extendsBound = wildcardType.getExtendsBound().accept(this, null);
        }
        return new ASTWildcardType(superBound, extendsBound);
    }

    @Override
    public ASTType visitExecutable(ExecutableType executableType, Void v) {
        if (executableType instanceof TypeElement) {
            return ((ASTElementFactory)this.astElementFactoryProvider.get()).getType((TypeElement)((Object)executableType));
        }
        throw new TransfuseAdapterException("Encountered non-TypeElement");
    }

    @Override
    public ASTType visitNoType(NoType noType, Void v) {
        if (noType.getKind().equals((Object)TypeKind.VOID)) {
            return ASTVoidType.VOID;
        }
        return new ASTEmptyType("<NOTYPE>");
    }

    @Override
    public ASTType visitUnknown(TypeMirror typeMirror, Void v) {
        try {
            Class<?> intersectionTypeClass = Class.forName("javax.lang.model.type.IntersectionType");
            Method getBoundsMethod = intersectionTypeClass.getMethod("getBounds", new Class[0]);
            if (intersectionTypeClass.isInstance(typeMirror)) {
                return new ASTIntersectionType((List<ASTType>)FluentIterable.from((Iterable)((List)getBoundsMethod.invoke((Object)typeMirror, new Object[0]))).transform((Function)this).toList());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        throw new TransfuseAdapterException("Encountered unknown TypeMirror (" + typeMirror + ") kind: " + (Object)((Object)typeMirror.getKind()) + ", unable to recover");
    }

    public ASTType apply(TypeMirror input) {
        return input.accept(this, null);
    }
}

