/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.element;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import org.androidtransfuse.adapter.ASTConstructor;
import org.androidtransfuse.adapter.ASTField;
import org.androidtransfuse.adapter.ASTMethod;
import org.androidtransfuse.adapter.ASTParameter;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.element.ASTElementFactory;
import org.androidtransfuse.adapter.element.ElementVisitorAdaptor;

public class ASTTypeElementConverter<T>
extends ElementVisitorAdaptor<T, Void> {
    private static final String CONSTRUCTOR_IDENTIFIER = "<init>";
    private static final String STATIC_INITIALIZER_IDENTIFIER = "<clinit>";
    private final Class<T> astTypeClass;
    private final ASTElementFactory astElementFactory;

    public ASTTypeElementConverter(Class<T> astTypeClass, ASTElementFactory astElementFactory) {
        this.astTypeClass = astTypeClass;
        this.astElementFactory = astElementFactory;
    }

    @Override
    public T visitType(TypeElement typeElement, Void aVoid) {
        if (this.astTypeClass.isAssignableFrom(ASTType.class)) {
            return (T)this.astElementFactory.getType(typeElement);
        }
        return null;
    }

    @Override
    public T visitVariable(VariableElement variableElement, Void aVoid) {
        if (this.astTypeClass.isAssignableFrom(ASTField.class)) {
            return (T)this.astElementFactory.getField(variableElement);
        }
        return null;
    }

    @Override
    public T visitExecutable(ExecutableElement executableElement, Void aVoid) {
        if (executableElement.getSimpleName().contentEquals(STATIC_INITIALIZER_IDENTIFIER)) {
            return null;
        }
        if (executableElement.getSimpleName().contentEquals(CONSTRUCTOR_IDENTIFIER)) {
            if (this.astTypeClass.isAssignableFrom(ASTConstructor.class)) {
                return (T)this.astElementFactory.getConstructor(executableElement);
            }
        } else if (this.astTypeClass.isAssignableFrom(ASTMethod.class)) {
            return (T)this.astElementFactory.getMethod(executableElement);
        }
        return null;
    }

    @Override
    public T visitTypeParameter(TypeParameterElement typeParameterElement, Void aVoid) {
        if (this.astTypeClass.isAssignableFrom(ASTParameter.class)) {
            return (T)this.astElementFactory.getParameter(typeParameterElement);
        }
        return null;
    }
}

