/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.element;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTFactory;
import org.androidtransfuse.adapter.ASTType;
import org.androidtransfuse.adapter.element.ASTTypeBuilderVisitor;
import org.androidtransfuse.adapter.element.ElementConverterFactory;
import org.androidtransfuse.transaction.TransactionRuntimeException;

public class AnnotationValueConverterVisitor<T>
extends SimpleAnnotationValueVisitor6<T, Void> {
    private static final String ERROR_TYPE = "<error>";
    private final Class<T> type;
    private final ASTTypeBuilderVisitor astTypeBuilderVisitor;
    private final ElementConverterFactory astTypeElementConverterFactory;
    private final ASTFactory astFactory;

    public AnnotationValueConverterVisitor(Class<T> type, ASTTypeBuilderVisitor astTypeBuilderVisitor, ElementConverterFactory astTypeElementConverterFactory, ASTFactory astFactory) {
        this.type = type;
        this.astTypeBuilderVisitor = astTypeBuilderVisitor;
        this.astTypeElementConverterFactory = astTypeElementConverterFactory;
        this.astFactory = astFactory;
    }

    @Override
    public T visitBoolean(boolean b, Void aVoid) {
        return this.visitPrimitive(Boolean.TYPE, Boolean.class, b);
    }

    @Override
    public T visitByte(byte b, Void aVoid) {
        return this.visitPrimitive(Byte.TYPE, Byte.class, b);
    }

    @Override
    public T visitChar(char c, Void aVoid) {
        return this.visitPrimitive(Character.TYPE, Character.class, Character.valueOf(c));
    }

    @Override
    public T visitDouble(double d, Void aVoid) {
        return this.visitPrimitive(Double.TYPE, Double.class, d);
    }

    @Override
    public T visitFloat(float f, Void aVoid) {
        return this.visitPrimitive(Float.TYPE, Float.class, Float.valueOf(f));
    }

    @Override
    public T visitInt(int i, Void aVoid) {
        return this.visitPrimitive(Integer.TYPE, Integer.class, i);
    }

    @Override
    public T visitLong(long l, Void aVoid) {
        return this.visitPrimitive(Long.TYPE, Long.class, l);
    }

    @Override
    public T visitShort(short s, Void aVoid) {
        return this.visitPrimitive(Short.TYPE, Short.class, s);
    }

    @Override
    public T visitString(String s, Void aVoid) {
        return this.visitSimple(String.class, s);
    }

    @Override
    public T visitType(TypeMirror typeMirror, Void aVoid) {
        if (this.type.isAssignableFrom(ASTType.class)) {
            return (T)typeMirror.accept(this.astTypeBuilderVisitor, null);
        }
        return null;
    }

    @Override
    public T visitEnumConstant(VariableElement variableElement, Void aVoid) {
        if (variableElement.getKind() == ElementKind.ENUM_CONSTANT) {
            return Enum.valueOf(this.type, variableElement.getSimpleName().toString());
        }
        return null;
    }

    @Override
    public T visitArray(List<? extends AnnotationValue> annotationValues, Void aVoid) {
        ArrayList annotationASTTypes = new ArrayList();
        for (AnnotationValue annotationValue : annotationValues) {
            annotationASTTypes.add(annotationValue.accept(new AnnotationValueConverterVisitor(this.type.getComponentType(), this.astTypeBuilderVisitor, this.astTypeElementConverterFactory, this.astFactory), null));
        }
        return (T)annotationASTTypes.toArray((Object[])Array.newInstance(this.type.getComponentType(), 0));
    }

    private <P> T visitPrimitive(Class<P> primitiveClazz, Class<P> boxedClass, P value) {
        if (this.type.isAssignableFrom(primitiveClazz)) {
            return (T)value;
        }
        return this.visitSimple(boxedClass, value);
    }

    private <P> T visitSimple(Class<P> clazz, P value) {
        if (this.type.isAssignableFrom(clazz)) {
            return (T)value;
        }
        if (this.type.equals(ASTType.class) && value.equals(ERROR_TYPE)) {
            throw new TransactionRuntimeException("Encountered ErrorType " + value.toString() + ", unable to recover");
        }
        return null;
    }

    @Override
    public T visitAnnotation(AnnotationMirror annotationMirror, Void aVoid) {
        if (this.type.isAssignableFrom(ASTAnnotation.class)) {
            ASTType annotationType = annotationMirror.getAnnotationType().accept(this.astTypeBuilderVisitor, null);
            return (T)this.astFactory.buildASTElementAnnotation(annotationMirror, annotationType);
        }
        return null;
    }
}

