/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.adapter.element;

import javax.inject.Inject;
import javax.inject.Provider;
import org.androidtransfuse.adapter.ASTFactory;
import org.androidtransfuse.adapter.element.ASTElementFactory;
import org.androidtransfuse.adapter.element.ASTTypeBuilderVisitor;
import org.androidtransfuse.adapter.element.ASTTypeElementConverter;
import org.androidtransfuse.adapter.element.AnnotationValueConverterVisitor;

public class ElementConverterFactory {
    private final ASTTypeBuilderVisitor astTypeBuilderVisitor;
    private final Provider<ASTElementFactory> astElementFactoryProvider;
    private final ASTFactory astFactory;

    @Inject
    public ElementConverterFactory(ASTTypeBuilderVisitor astTypeBuilderVisitor, Provider<ASTElementFactory> astElementFactoryProvider, ASTFactory astFactory) {
        this.astTypeBuilderVisitor = astTypeBuilderVisitor;
        this.astElementFactoryProvider = astElementFactoryProvider;
        this.astFactory = astFactory;
    }

    public <T> ASTTypeElementConverter<T> buildTypeConverter(Class<T> clazz) {
        return new ASTTypeElementConverter<T>(clazz, (ASTElementFactory)this.astElementFactoryProvider.get());
    }

    public <T> AnnotationValueConverterVisitor<T> buildAnnotationValueConverter(Class<T> clazz) {
        return new AnnotationValueConverterVisitor<T>(clazz, this.astTypeBuilderVisitor, this, this.astFactory);
    }
}

