/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.transaction;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.androidtransfuse.transaction.Transaction;
import org.androidtransfuse.transaction.TransactionProcessor;
import org.androidtransfuse.transaction.TransfuseTransactionException;

public class TransactionProcessorPool<V, R>
implements TransactionProcessor<V, R> {
    private final List<Transaction<V, R>> transactions = new ArrayList<Transaction<V, R>>();

    public void submit(Transaction<V, R> transaction) {
        this.transactions.add(transaction);
    }

    @Override
    public void execute() {
        ListeningExecutorService executorService = MoreExecutors.sameThreadExecutor();
        for (Transaction<V, R> transaction : this.transactions) {
            if (transaction.isComplete()) continue;
            executorService.execute(transaction);
        }
        try {
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new TransfuseTransactionException("Pool executor interrupted", e);
        }
    }

    @Override
    public Map<V, R> getResults() {
        HashMap<V, R> aggregate = new HashMap<V, R>();
        for (Transaction<V, R> transaction : this.transactions) {
            if (!transaction.isComplete() || transaction.getResult() == null) continue;
            aggregate.put(transaction.getValue(), transaction.getResult());
        }
        return aggregate;
    }

    @Override
    public boolean isComplete() {
        for (Transaction<V, R> transaction : this.transactions) {
            if (transaction.isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ImmutableSet<Exception> getErrors() {
        ImmutableSet.Builder exceptions = ImmutableSet.builder();
        for (Transaction<V, R> transaction : this.transactions) {
            if (transaction.isComplete() || transaction.getError() == null) continue;
            exceptions.add((Object)transaction.getError());
        }
        return exceptions.build();
    }
}

