/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.util;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public final class Contract {
    private Contract() {
    }

    public static void notNull(Object object, String objectName) {
        if (object == null) {
            throw new IllegalArgumentException("expecting non-null value for " + Contract.maskNullArgument(objectName));
        }
    }

    public static void sameSize(Collection<?> collection1, Collection<?> collection2, String collection1Name, String collection2Name) {
        Contract.notNull(collection1, collection1Name);
        Contract.notNull(collection2, collection2Name);
        if (collection1.size() != collection2.size()) {
            throw new IllegalArgumentException("expecting " + Contract.maskNullArgument(collection1Name) + " to have the same size as " + Contract.maskNullArgument(collection2Name));
        }
    }

    public static void atSize(Collection<?> collection, int size, String collectionName) {
        Contract.notNull(collection, collectionName);
        Contract.notNegative(size, "size");
        if (collection.size() != size) {
            throw new IllegalArgumentException("expecting " + Contract.maskNullArgument(collectionName) + " to be of size " + size + ".");
        }
    }

    public static void notEmpty(Collection<?> collection, String collectionName) {
        Contract.notNull(collection, collectionName);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("expecting " + Contract.maskNullArgument(collectionName) + " to contain 1 or more elements");
        }
    }

    public static void notEmpty(Object[] array, String arrayName) {
        Contract.notNull(array, arrayName);
        if (array.length == 0) {
            throw new IllegalArgumentException("expecting " + Contract.maskNullArgument(arrayName) + " to contain 1 or more elements");
        }
    }

    public static void sameLength(Object[] array1, Object[] array2, String array1Name, String array2Name) {
        Contract.notNull(array1, array1Name);
        Contract.notNull(array2, array2Name);
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("expecting " + Contract.maskNullArgument(array1Name) + " to have the same length as " + Contract.maskNullArgument(array2Name));
        }
    }

    public static void atLength(Object[] array, int length, String arrayName) {
        Contract.notNull(array, arrayName);
        Contract.notNegative(length, "length");
        if (array.length != length) {
            throw new IllegalArgumentException("expecting " + Contract.maskNullArgument(arrayName) + " to be of length " + length + ".");
        }
    }

    public static void inBounds(Integer input, Integer min, Integer max, String inputName) {
        Contract.notNull(input, inputName);
        if (min != null && input < min) {
            throw new IndexOutOfBoundsException("a value of " + input.toString() + " was unexpected for " + Contract.maskNullArgument(inputName) + ", it is expected to be less than " + min.toString());
        }
        if (max != null && input > max) {
            throw new IndexOutOfBoundsException("a value of " + input.toString() + " was unexpected for " + Contract.maskNullArgument(inputName) + ", it is expected to be greater than " + max.toString());
        }
    }

    public static void notNegative(Integer input, String inputName) {
        Contract.notNull(input, inputName);
        if (input < 0) {
            throw new IllegalArgumentException("a value of " + input.toString() + " was unexpected for " + Contract.maskNullArgument(inputName) + ", it is expected to be positive");
        }
    }

    public static void notZero(Integer input, String inputName) {
        Contract.notNull(input, inputName);
        if (input == 0) {
            throw new IllegalArgumentException("a zero value for was unexpected for " + Contract.maskNullArgument(inputName) + ", it is expected to be non zero");
        }
    }

    public static void notBlank(String input, String inputName) {
        Contract.notNull(input, inputName);
        if (StringUtils.isBlank((String)input)) {
            throw new IllegalArgumentException("Expecting " + Contract.maskNullArgument(inputName) + " to be a non blank value.");
        }
    }

    public static void instanceOf(Object input, Class<?> classType, String inputName) {
        Contract.notNull(input, "input");
        Contract.notNull(classType, "classType");
        if (!classType.isInstance(input)) {
            throw new IllegalArgumentException("Expecting " + Contract.maskNullArgument(inputName) + " to an instance of " + classType.getName() + ".");
        }
    }

    private static String maskNullArgument(String input) {
        return input == null ? "-unknown argument-" : input;
    }
}

