/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.validation;

import java.util.Map;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.tools.Diagnostic;
import org.androidtransfuse.adapter.ASTAnnotation;
import org.androidtransfuse.adapter.ASTBase;
import org.androidtransfuse.adapter.element.ASTElementAnnotation;
import org.androidtransfuse.adapter.element.ASTElementBase;

public class Validator {
    public static final String LOG_PREPEND = "logPrepend";
    private final String prepend;
    private final Messager messager;
    private boolean inError = false;

    @Inject
    public Validator(@Named(value="logPrepend") String prepend, Messager messager) {
        this.prepend = prepend;
        this.messager = messager;
    }

    public ValidationBuilder error(String message) {
        this.inError = true;
        return new ValidationBuilder(Diagnostic.Kind.ERROR, this.prepend + message);
    }

    public ValidationBuilder warn(String message) {
        return new ValidationBuilder(Diagnostic.Kind.WARNING, this.prepend + message);
    }

    public boolean isInError() {
        return this.inError;
    }

    public final class ValidationBuilder {
        private Diagnostic.Kind kind;
        private String message;
        private Element element;
        private AnnotationMirror annotation;
        private AnnotationValue value;

        private ValidationBuilder(Diagnostic.Kind kind, String message) {
            this.kind = kind;
            this.message = message;
        }

        public ValidationBuilder element(ASTBase astBase) {
            if (astBase instanceof ASTElementBase) {
                this.element = ((ASTElementBase)astBase).getElement();
            }
            return this;
        }

        public ValidationBuilder annotation(ASTAnnotation annotation) {
            if (annotation instanceof ASTElementAnnotation) {
                this.annotation = ((ASTElementAnnotation)annotation).getAnnotationMirror();
            }
            return this;
        }

        public ValidationBuilder parameter(String propertyName) {
            if (this.annotation != null) {
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : this.annotation.getElementValues().entrySet()) {
                    if (!propertyName.equals(entry.getKey().getSimpleName().toString())) continue;
                    this.value = entry.getValue();
                    break;
                }
            }
            return this;
        }

        public void build() {
            Validator.this.inError = this.kind == Diagnostic.Kind.ERROR;
            if (this.element != null) {
                if (this.annotation != null) {
                    if (this.value != null) {
                        Validator.this.messager.printMessage(this.kind, this.message, this.element, this.annotation, this.value);
                    } else {
                        Validator.this.messager.printMessage(this.kind, this.message, this.element, this.annotation);
                    }
                } else {
                    Validator.this.messager.printMessage(this.kind, this.message, this.element);
                }
            } else {
                Validator.this.messager.printMessage(this.kind, this.message);
            }
        }
    }
}

