/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin.andromdapp;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.andromda.maven.plugin.andromdapp.utils.ProjectUtils;
import org.andromda.maven.plugin.andromdapp.utils.Projects;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;

public class BuildMojo
extends AbstractMojo {
    private LifecycleExecutor lifecycleExecutor;
    private MavenSession session;
    private File baseDirectory;
    private String modules;
    private MavenProject project;
    private String startConsole;
    private List goals = new ArrayList<String>(Arrays.asList("install"));
    private static final String EXIT = "exit";
    private MavenProjectBuilder projectBuilder;
    private Properties executionProperties = new Properties();
    private static final String EXECUTION_PROPERTY_TOKEN = "-D";
    private static final String LIST_PROPERTIES = "-list";
    private static final String CLEAR_PROPERTIES = "-clear";
    private static final String GARBAGE_COLLECT = "-gc";
    private String environmentVariablePrefix;
    private static final String GET_ENVIRONMENT_METHOD = "getenv";

    public void execute() throws MojoExecutionException {
        block15: {
            try {
                Map environment = this.getEnvironment();
                if (this.startConsole != null && !this.startConsole.equals(Boolean.FALSE.toString())) {
                    boolean executed = false;
                    this.printLine();
                    while (true) {
                        this.printConsolePrompt();
                        String input = StringUtils.trimToEmpty((String)this.readLine());
                        if (EXIT.equals(input)) break block15;
                        if (input.startsWith(EXECUTION_PROPERTY_TOKEN)) {
                            String value;
                            String name;
                            int index = (input = input.replaceFirst(EXECUTION_PROPERTY_TOKEN, "")).indexOf("=");
                            if (index <= 0) {
                                name = input.trim();
                                value = "true";
                            } else {
                                name = input.substring(0, index).trim();
                                value = input.substring(index + 1).trim();
                            }
                            if (value.startsWith(this.environmentVariablePrefix) && environment.containsKey(value = StringUtils.replace((String)value, (String)this.environmentVariablePrefix, (String)""))) {
                                value = ObjectUtils.toString(environment.get(value)).trim();
                            }
                            this.executionProperties.put(name, value);
                            System.setProperty(name, value);
                            this.printExecutionProperties();
                            continue;
                        }
                        if (LIST_PROPERTIES.equals(input)) {
                            this.printExecutionProperties();
                            continue;
                        }
                        if (CLEAR_PROPERTIES.equals(input)) {
                            this.executionProperties.clear();
                            this.printExecutionProperties();
                            continue;
                        }
                        if (GARBAGE_COLLECT.equals(input)) {
                            System.gc();
                            continue;
                        }
                        try {
                            executed = this.executeModules(input);
                            if (this.project != null && !executed && input != null && input.trim().length() > 0) {
                                executed = true;
                                List<String> goals = Arrays.asList(input.split("\\s+"));
                                this.executeModules(StringUtils.join(this.project.getModules().iterator(), (String)","), goals, true);
                            }
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        if (executed) {
                            this.printLine();
                        }
                        Projects.instance().clear();
                    }
                }
                this.executionProperties.putAll((Map<?, ?>)this.session.getExecutionProperties());
                this.executeModules(this.modules);
            }
            catch (Throwable throwable) {
                throw new MojoExecutionException("Error executing modules", throwable);
            }
        }
    }

    private Map getEnvironment() {
        HashMap variables = new HashMap();
        try {
            Method method = System.class.getMethod(GET_ENVIRONMENT_METHOD, null);
            Object result = method.invoke(System.class, null);
            if (result instanceof Map) {
                variables.putAll((Map)result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return variables;
    }

    private void printExecutionProperties() {
        this.printLine();
        this.printTextWithLine("| ------------- execution properties ------------- |");
        for (String string : this.executionProperties.keySet()) {
            System.out.println("    " + string + " = " + this.executionProperties.getProperty(string));
        }
        this.printTextWithLine("| ------------------------------------------------ |");
        this.printLine();
    }

    private void printConsolePrompt() {
        if (this.project != null) {
            this.printText("");
            this.printText(this.project.getArtifactId() + " " + this.project.getVersion() + ">");
        }
    }

    private void printText(String text) {
        System.out.print(text);
        System.out.flush();
    }

    private void printTextWithLine(String text) {
        System.out.println(text);
        System.out.flush();
    }

    private void printLine() {
        System.out.println();
        System.out.flush();
    }

    private String readLine() {
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        String inputString = null;
        try {
            inputString = input.readLine();
        }
        catch (IOException exception) {
            inputString = null;
        }
        return inputString == null || inputString.trim().length() == 0 ? null : inputString;
    }

    private boolean executeModules(String modules) throws MojoExecutionException {
        return this.executeModules(modules, null, false);
    }

    private boolean executeModules(String modules, List goals, boolean sortProjects) throws MojoExecutionException {
        boolean executed;
        Map projects = this.collectProjects(modules);
        boolean bl = executed = !projects.isEmpty();
        if (executed) {
            if (!sortProjects) {
                for (MavenProject project : projects.keySet()) {
                    List projectGoals;
                    if (goals == null) {
                        projectGoals = (List)projects.get(project);
                        if (projectGoals.isEmpty()) {
                            projectGoals.addAll(this.goals);
                        }
                    } else {
                        projectGoals = goals;
                    }
                    this.executeProjects(Collections.singletonList(project), projectGoals);
                }
            } else {
                this.executeProjects(projects.keySet(), goals);
            }
        }
        return executed;
    }

    private void executeProjects(Collection projects, List goals) throws MojoExecutionException {
        try {
            if (goals.isEmpty()) {
                goals.addAll(this.goals);
            }
            if (projects.size() > 1) {
                this.getLog().info((CharSequence)"Reactor build order:");
            }
            ReactorManager reactorManager = new ReactorManager(new ArrayList(projects));
            for (MavenProject project : reactorManager.getSortedProjects()) {
                this.getLog().info((CharSequence)("  " + project.getName()));
            }
            MavenSession projectSession = new MavenSession(this.session.getContainer(), this.session.getSettings(), this.session.getLocalRepository(), this.session.getEventDispatcher(), reactorManager, goals, this.baseDirectory.toString(), this.executionProperties, this.session.getStartTime());
            projectSession.setUsingPOMsFromFilesystem(true);
            this.lifecycleExecutor.execute(projectSession, reactorManager, projectSession.getEventDispatcher());
        }
        catch (Throwable throwable) {
            throw new MojoExecutionException("An error occured while attempting to execute projects", throwable);
        }
    }

    private Map collectProjects(String modules) throws MojoExecutionException {
        LinkedHashMap projects = new LinkedHashMap();
        Map poms = this.getModulePoms(modules);
        if (!poms.isEmpty()) {
            for (File pom : poms.keySet()) {
                try {
                    MavenProject project = ProjectUtils.getProject(this.projectBuilder, this.session, pom, this.getLog());
                    if (project != null) {
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((CharSequence)("Adding project " + project.getId()));
                        }
                        projects.put(project, poms.get(pom));
                        continue;
                    }
                    if (!this.getLog().isWarnEnabled()) continue;
                    this.getLog().warn((CharSequence)("Could not load project from pom: " + pom + " - ignoring"));
                }
                catch (ProjectBuildingException exception) {
                    throw new MojoExecutionException("Error loading POM --> '" + pom + "'", (Exception)((Object)exception));
                }
            }
        }
        return projects;
    }

    private Map getModulePoms(String moduleList) {
        LinkedHashMap poms = new LinkedHashMap();
        String[] modules = moduleList != null ? moduleList.split(",") : null;
        String goalPrefix = ":";
        if (modules != null) {
            int numberOfModules = modules.length;
            for (int ctr = 0; ctr < numberOfModules; ++ctr) {
                File pom;
                String[] goals;
                String module = modules[ctr].trim();
                ArrayList<String> goalsList = new ArrayList<String>();
                if (module.indexOf(":") != -1 && (goals = module.replaceAll(".*(:\\[)|(\\])", "").split("\\+")) != null) {
                    int numberOfGoals = goals.length;
                    for (int ctr2 = 0; ctr2 < numberOfGoals; ++ctr2) {
                        String goal = goals[ctr2].trim();
                        goalsList.add(goal);
                    }
                }
                if (!(pom = new File(this.baseDirectory, (module = module.replaceAll(":\\[.*\\]", "")) + "/pom.xml")).isFile()) continue;
                poms.put(pom, goalsList);
            }
        }
        return poms;
    }
}

