/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin.andromdapp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.andromda.maven.plugin.andromdapp.AppManagementMojo;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.DirectoryScanner;

public class DeployMojo
extends AppManagementMojo {
    private String deploy;
    private static final String EXPLODED = "exploded";
    private String[] includes = new String[0];
    private String[] excludes = new String[0];

    public void execute() throws MojoExecutionException, MojoFailureException {
        File artifactFile = this.project.getArtifact().getFile();
        if (this.deploy != null && this.deploy.equals(Boolean.TRUE.toString()) || artifactFile == null) {
            Build build = this.project.getBuild();
            if (EXPLODED.equalsIgnoreCase(this.deploy)) {
                artifactFile = new File(build.getDirectory(), build.getFinalName());
            } else if (artifactFile == null) {
                artifactFile = new File(build.getDirectory(), build.getFinalName() + '.' + this.getPackaging());
            }
            if (artifactFile.exists()) {
                File deployFile = this.getDeployFile();
                File deployDirectory = new File(this.deployLocation);
                if (deployDirectory.exists() && deployDirectory.isDirectory()) {
                    try {
                        if (EXPLODED.equalsIgnoreCase(this.deploy)) {
                            this.getLog().info((CharSequence)("Deploying exploded " + artifactFile + " to " + deployFile));
                            FileUtils.copyDirectory((File)artifactFile, (File)deployFile);
                        }
                        if (deployFile.exists() && deployFile.isDirectory()) {
                            this.getLog().info((CharSequence)("Removing exploded artifact: " + deployFile));
                            FileUtils.deleteDirectory((File)deployFile);
                        }
                        List deployFiles = this.getAdditionalFiles();
                        deployFiles.add(0, artifactFile);
                        for (File file : deployFiles) {
                            this.getLog().info((CharSequence)("Deploying file " + file + " to " + deployDirectory));
                            FileUtils.copyFileToDirectory((File)file, (File)deployDirectory);
                        }
                    }
                    catch (Throwable throwable) {
                        throw new MojoExecutionException("An error occurred while attempting to deploy artifact", throwable);
                    }
                } else {
                    this.getLog().error((CharSequence)("Deploy did not occur because the specified deployLocation '" + this.deployLocation + "' does not exist, or is not a directory"));
                }
            } else {
                this.getLog().warn((CharSequence)("Deploy did not occur because file '" + artifactFile + "' does not exist"));
            }
        }
    }

    private List getAdditionalFiles() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.project.getBuild().getDirectory());
        scanner.setIncludes(this.includes);
        scanner.setExcludes(this.excludes);
        scanner.scan();
        ArrayList<File> files = new ArrayList<File>();
        for (int ctr = 0; ctr < scanner.getIncludedFiles().length; ++ctr) {
            File file = new File(this.project.getBuild().getDirectory(), scanner.getIncludedFiles()[ctr]);
            if (!file.exists()) continue;
            files.add(file);
        }
        return files;
    }
}

