/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin.andromdapp;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.andromda.maven.plugin.andromdapp.utils.ProjectUtils;
import org.andromda.maven.plugin.andromdapp.utils.Projects;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.util.DirectoryScanner;

public class MavenExecuteMojo
extends AbstractMojo {
    private MavenSession session;
    private File baseDirectory;
    private LifecycleExecutor lifecycleExecutor;
    private MavenProject project;
    private MavenProjectBuilder projectBuilder;
    private String[] includes = new String[]{"*/**/pom.xml"};
    private boolean aggregateGoals = false;
    private String[] excludes = new String[]{"pom.xml"};
    private static final String VERSION_PROPERTY = "version";

    public void execute() throws MojoExecutionException, MojoFailureException {
        System.getProperties().remove(VERSION_PROPERTY);
        if (!Projects.instance().isPresent(this.project.getId())) {
            try {
                List projects = this.collectProjects();
                if (!projects.isEmpty()) {
                    String defaultGoal;
                    List goals = this.session.getGoals();
                    if (goals.isEmpty() && this.project != null && (defaultGoal = this.project.getDefaultGoal()) != null && defaultGoal.trim().length() > 0) {
                        goals.add(defaultGoal);
                    }
                    if (this.aggregateGoals) {
                        ReactorManager reactorManager = new ReactorManager(projects);
                        if (projects.size() > 1) {
                            this.getLog().info((CharSequence)"Reactor build order:");
                        }
                        for (MavenProject project : reactorManager.getSortedProjects()) {
                            this.getLog().info((CharSequence)("  " + project.getName()));
                        }
                        MavenSession projectSession = new MavenSession(this.session.getContainer(), this.session.getSettings(), this.session.getLocalRepository(), this.session.getEventDispatcher(), reactorManager, goals, this.baseDirectory.toString(), this.session.getExecutionProperties(), this.session.getStartTime());
                        projectSession.setUsingPOMsFromFilesystem(true);
                        this.lifecycleExecutor.execute(projectSession, reactorManager, projectSession.getEventDispatcher());
                    } else {
                        for (String goal : this.session.getGoals()) {
                            ReactorManager reactorManager = new ReactorManager(projects);
                            if (projects.size() > 1) {
                                this.getLog().info((CharSequence)"Reactor build order:");
                            }
                            for (MavenProject project : reactorManager.getSortedProjects()) {
                                this.getLog().info((CharSequence)("  " + project.getName()));
                            }
                            MavenSession projectSession = new MavenSession(this.session.getContainer(), this.session.getSettings(), this.session.getLocalRepository(), this.session.getEventDispatcher(), reactorManager, Collections.singletonList(goal), this.baseDirectory.toString(), this.session.getExecutionProperties(), this.session.getStartTime());
                            projectSession.setUsingPOMsFromFilesystem(true);
                            this.lifecycleExecutor.execute(projectSession, reactorManager, projectSession.getEventDispatcher());
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throw new MojoExecutionException("Execution failed", throwable);
            }
            Projects.instance().add(this.project.getId());
        }
    }

    private List collectProjects() throws MojoExecutionException {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        List poms = this.getPoms();
        if (!poms.isEmpty()) {
            for (File pom : poms) {
                try {
                    MavenProject project = ProjectUtils.getProject(this.projectBuilder, this.session, pom, this.getLog());
                    if (project != null) {
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((CharSequence)("Adding project " + project.getId()));
                        }
                        projects.add(project);
                        continue;
                    }
                    if (!this.getLog().isWarnEnabled()) continue;
                    this.getLog().warn((CharSequence)("Could not load project from pom: " + pom + " - ignoring"));
                }
                catch (ProjectBuildingException exception) {
                    throw new MojoExecutionException("Error loading POM --> '" + pom + "'", (Exception)((Object)exception));
                }
            }
        }
        return projects;
    }

    private List getPoms() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.baseDirectory);
        scanner.setIncludes(this.includes);
        scanner.setExcludes(this.excludes);
        scanner.scan();
        ArrayList<File> poms = new ArrayList<File>();
        for (int ctr = 0; ctr < scanner.getIncludedFiles().length; ++ctr) {
            poms.add(new File(this.baseDirectory, scanner.getIncludedFiles()[ctr]));
        }
        return poms;
    }
}

