/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin.andromdapp;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.andromda.core.common.ClassUtils;
import org.andromda.maven.plugin.andromdapp.Location;
import org.andromda.maven.plugin.andromdapp.script.ScriptClassGenerator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class ScriptClassGeneratorMojo
extends AbstractMojo {
    private Location[] locations;
    private String scriptWrapper;
    private MavenProject project;
    protected ArtifactFactory factory;
    protected ArtifactRepository localRepository;
    private static final String JAVA_EXTENSION = ".java";

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            ScriptClassGenerator generator = ScriptClassGenerator.getInstance(this.scriptWrapper);
            if (this.locations != null) {
                ArrayList classpathElements = new ArrayList(this.getProvidedClasspathElements());
                classpathElements.addAll(this.project.getRuntimeClasspathElements());
                this.initializeClassLoader(classpathElements);
                for (int ctr = 0; ctr < this.locations.length; ++ctr) {
                    Location location = this.locations[ctr];
                    String rootPath = location.getRootPath();
                    for (String path : location.getPaths()) {
                        int extensionIndex = path.lastIndexOf(JAVA_EXTENSION);
                        if (extensionIndex == -1) continue;
                        String className = path.substring(0, extensionIndex).replaceAll("\\\\|/", "\\.");
                        this.getLog().info((CharSequence)("injecting script wrapper: " + className));
                        generator.modifyClass(rootPath, ClassUtils.loadClass((String)className));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throw new MojoExecutionException("Failed to inject script wrappers", throwable);
        }
    }

    protected List getProvidedClasspathElements() {
        ArrayList<String> classpathElements = new ArrayList<String>();
        Iterator iterator = this.project.getDependencies().iterator();
        while (iterator.hasNext()) {
            Artifact artifact = this.getArtifact((Dependency)iterator.next(), "provided");
            if (artifact == null) continue;
            classpathElements.add(artifact.getFile().getAbsolutePath());
        }
        return classpathElements;
    }

    private Artifact getArtifact(Dependency dependency, String scope) {
        Artifact artifact = null;
        ArtifactRepository localRepository = this.localRepository;
        MavenProject project = this.project;
        if (project != null && localRepository != null && dependency != null) {
            artifact = this.factory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), scope, dependency.getType());
            File file = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
            artifact.setFile(file);
        }
        return artifact;
    }

    protected void initializeClassLoader(List classpathFiles) throws MalformedURLException {
        LinkedHashSet<URL> classpathUrls = new LinkedHashSet<URL>();
        classpathUrls.add(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
        if (classpathFiles != null && classpathFiles.size() > 0) {
            for (int ctr = 0; ctr < classpathFiles.size(); ++ctr) {
                File file = new File((String)classpathFiles.get(ctr));
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("adding to classpath '" + file + "'"));
                }
                classpathUrls.add(file.toURI().toURL());
            }
        }
        URLClassLoader loader = new URLClassLoader(classpathUrls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(loader);
    }
}

