/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin.andromdapp;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;

public class SymbolicLinkExplodedEarMojo
extends AbstractMojo {
    protected MavenProject project;
    private String deployLocation;
    private ArtifactFactory artifactFactory;
    private static final String LN_WINDOWS = "junction.exe";
    private static final String LN_UNIX = "ln -s";
    private static boolean isWindows = false;
    private static final String WINDOWS = "Windows";
    private MavenProject rootProject;
    private static final String[] INCLUDE_ALL_POMS;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File earDirectory = new File(this.project.getBuild().getDirectory() + '/' + this.project.getBuild().getFinalName());
            LinkedHashMap<String, Artifact> artifacts = new LinkedHashMap<String, Artifact>();
            for (Artifact artifact : this.getExplodedModuleArtifacts()) {
                artifacts.put(artifact.getFile().toString().replaceAll(".*(\\\\|//)", ""), artifact);
            }
            if (earDirectory.exists() && earDirectory.isDirectory()) {
                String linkCommand;
                if (isWindows) {
                    linkCommand = LN_WINDOWS;
                    File executableFile = new File(System.getProperty("java.io.tmpdir") + '/' + System.getProperty("user.name"), LN_WINDOWS);
                    if (!executableFile.exists()) {
                        URL resource = Thread.currentThread().getContextClassLoader().getResource(LN_WINDOWS);
                        FileUtils.copyURLToFile((URL)resource, (File)executableFile);
                    }
                    linkCommand = executableFile.toString();
                } else {
                    linkCommand = LN_UNIX;
                }
                File[] files = earDirectory.listFiles();
                File explodedEarDirectory = new File(earDirectory + "-exploded");
                explodedEarDirectory.mkdirs();
                for (int ctr = 0; ctr < files.length; ++ctr) {
                    File file = files[ctr];
                    String fileName = file.toString().replaceAll(".*(\\\\|//)", "");
                    Artifact artifact = (Artifact)artifacts.get(fileName);
                    if (artifact == null) {
                        if (file.isFile()) {
                            FileUtils.copyFileToDirectory((File)file, (File)explodedEarDirectory);
                            continue;
                        }
                        File targetDirectory = new File(explodedEarDirectory, file.getName());
                        targetDirectory.mkdir();
                        FileUtils.copyDirectory((File)file, (File)targetDirectory);
                        continue;
                    }
                    File targetFile = new File(explodedEarDirectory, fileName);
                    File explodedArtifactDirectory = new File(artifact.getFile().toString().replaceAll("\\." + artifact.getType(), ""));
                    String command = !isWindows ? linkCommand + " " + explodedArtifactDirectory + " " + targetFile.getAbsolutePath() : linkCommand + " " + targetFile.getAbsolutePath() + " " + explodedArtifactDirectory;
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("executing command: " + command));
                    }
                    if (targetFile.exists() && targetFile.isFile()) {
                        targetFile.delete();
                    }
                    this.getLog().info((CharSequence)("linking " + explodedArtifactDirectory + " to " + targetFile));
                    Runtime.getRuntime().exec(command);
                }
                File targetFile = new File(this.deployLocation, this.project.getBuild().getFinalName() + "." + this.project.getPackaging());
                String command = !isWindows ? linkCommand + " " + explodedEarDirectory + " " + targetFile.getAbsolutePath() : linkCommand + " " + targetFile.getAbsolutePath() + " " + explodedEarDirectory;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("executing command: " + command));
                }
                File applicationContextXml = new File(explodedEarDirectory, "META-INF/application.xml");
                FileUtils.touch((File)applicationContextXml);
                this.getLog().info((CharSequence)("linking " + explodedEarDirectory + " to " + targetFile));
                if (targetFile.isFile()) {
                    targetFile.delete();
                }
                Runtime.getRuntime().exec(command);
            }
        }
        catch (Exception exception) {
            throw new MojoExecutionException("A failure occured while trying to link the ear", exception);
        }
    }

    private MavenProject getRootProject() throws MojoExecutionException {
        if (this.rootProject == null) {
            MavenProject root = null;
            root = this.project.getParent();
            while (root.getParent() != null) {
                root = root.getParent();
            }
            if (root == null) {
                throw new MojoExecutionException("No parent could be retrieved for project --> " + this.project.getId() + "', you must specify a parent project");
            }
            this.rootProject = root;
        }
        return this.rootProject;
    }

    private List getPoms() throws MojoExecutionException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.getRootProject().getBasedir());
        scanner.setIncludes(INCLUDE_ALL_POMS);
        scanner.scan();
        ArrayList<File> poms = new ArrayList<File>();
        for (int ctr = 0; ctr < scanner.getIncludedFiles().length; ++ctr) {
            File file = new File(this.getRootProject().getBasedir(), scanner.getIncludedFiles()[ctr]);
            if (!file.exists()) continue;
            poms.add(file);
        }
        return poms;
    }

    private List getExplodedModuleArtifacts() throws Exception {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        MavenXpp3Reader reader = new MavenXpp3Reader();
        for (File pom : this.getPoms()) {
            Model model = reader.read((Reader)new FileReader(pom));
            String groupId = model.getGroupId();
            Parent parent = model.getParent();
            while (groupId == null && model.getParent() != null) {
                groupId = parent.getGroupId();
                parent = model.getParent();
            }
            String version = model.getVersion();
            Parent parent2 = model.getParent();
            while (version == null && model.getParent() != null) {
                version = parent2.getVersion();
                parent2 = model.getParent();
            }
            Artifact artifact = this.artifactFactory.createArtifact(groupId, model.getArtifactId(), version, null, model.getPackaging());
            File pomParent = pom.getParentFile();
            String finalName = model.getArtifactId() + "-" + version;
            File explodedDirectory = new File(pomParent, "target/" + finalName);
            File artifactFile = new File(explodedDirectory + "." + model.getPackaging());
            if (!explodedDirectory.isDirectory() || !artifactFile.exists() || finalName.equals(this.project.getBuild().getFinalName())) continue;
            artifacts.add(artifact);
            artifact.setFile(artifactFile);
        }
        return artifacts;
    }

    static {
        String osName = System.getProperty("os.name");
        if (osName.indexOf(WINDOWS) != -1) {
            isWindows = true;
        }
        INCLUDE_ALL_POMS = new String[]{"*/**/pom.xml"};
    }
}

