/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin.andromdapp.hibernate;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.andromda.core.common.Constants;
import org.andromda.core.common.ResourceWriter;
import org.andromda.maven.plugin.andromdapp.hibernate.HibernateSchemaManagement;

public class HibernateUpdateSchema
extends HibernateSchemaManagement {
    private static final String HIBERNATE_PROPERTIES_TEMP_DIRECTORY = Constants.TEMPORARY_DIRECTORY + "andromdapp/hibernate-schema-update";
    private ClassLoader jdbcDriverJarLoader = null;

    protected void addArguments(Map options, List arguments) throws Exception {
        String driverClass = this.getRequiredProperty(options, "jdbcDriver");
        String connectionUrl = this.getRequiredProperty(options, "jdbcConnectionUrl");
        String username = this.getRequiredProperty(options, "jdbcUsername");
        String password = this.getRequiredProperty(options, "jdbcPassword");
        StringBuffer contents = new StringBuffer();
        contents.append("hibernate.connection.driver_class=" + driverClass + "\n");
        contents.append("hibernate.connection.url=" + connectionUrl + "\n");
        contents.append("hibernate.connection.username=" + username + "\n");
        contents.append("hibernate.connection.password=" + password + "\n");
        File temporaryProperitesFile = new File(HIBERNATE_PROPERTIES_TEMP_DIRECTORY, new Random().nextDouble() + "");
        temporaryProperitesFile.deleteOnExit();
        ResourceWriter.instance().writeStringToFile(contents.toString(), temporaryProperitesFile.toString());
        arguments.add("--properties=" + temporaryProperitesFile);
    }

    protected ClassLoader getJdbcDriverJarLoader(Map options) throws MalformedURLException {
        String jdbcDriverJar = this.getRequiredProperty(options, "jdbcDriverJar");
        if (this.jdbcDriverJarLoader == null) {
            this.jdbcDriverJarLoader = new URLClassLoader(new URL[]{new File(jdbcDriverJar).toURI().toURL()});
        }
        return this.jdbcDriverJarLoader;
    }

    protected String getExecutionOuputPath(Map options) {
        return null;
    }

    protected String getExecutionClassName() {
        return "SchemaUpdate";
    }
}

