/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin.andromdapp.script;

import java.io.File;
import java.net.URL;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.Modifier;
import javassist.NotFoundException;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.maven.plugin.andromdapp.script.ScriptClassGeneratorException;
import org.apache.commons.lang.StringUtils;

public class ScriptClassGenerator {
    private static ScriptClassGenerator instance;
    private String scriptWrapperName;

    public static final ScriptClassGenerator getInstance(String scriptWrapperName) {
        ExceptionUtils.checkEmpty((String)"scriptWrapperName", (String)scriptWrapperName);
        instance = new ScriptClassGenerator();
        ScriptClassGenerator.instance.scriptWrapperName = scriptWrapperName;
        return instance;
    }

    private ScriptClassGenerator() {
    }

    public void modifyClass(String scriptDirectory, Class existingClass) {
        try {
            String className = existingClass.getName();
            ClassPool pool = ClassPool.getDefault();
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                pool.insertClassPath((ClassPath)new LoaderClassPath(contextClassLoader));
            }
            CtClass ctClass = pool.get(className);
            ctClass.defrost();
            String scriptWrapperFieldName = "scriptWrapper";
            try {
                ctClass.getField("scriptWrapper");
            }
            catch (Exception exception) {
                CtField scriptWrapper = new CtField(this.convert(pool, this.scriptWrapperName), "scriptWrapper", ctClass);
                scriptWrapper.setModifiers(18);
                ctClass.addField(scriptWrapper, this.getScriptWrapperInitialization(scriptDirectory, className));
            }
            CtMethod[] existingMethods = ctClass.getDeclaredMethods();
            for (int ctr = 0; ctr < existingMethods.length; ++ctr) {
                CtMethod method = existingMethods[ctr];
                if (Modifier.isStatic((int)method.getModifiers())) continue;
                CtClass returnType = method.getReturnType();
                String methodBody = returnType.equals(CtClass.voidType) ? "{" + this.contructArgumentString(method) + "scriptWrapper.invoke(\"" + method.getName() + "\", arguments);}" : (returnType.isPrimitive() ? "{" + this.contructArgumentString(method) + " return ((" + this.getWrapperTypeName(returnType) + ")scriptWrapper.invoke(\"" + method.getName() + "\", arguments))." + returnType.getName() + "Value();}" : "{" + this.contructArgumentString(method) + " return (" + method.getReturnType().getName() + ")scriptWrapper.invoke(\"" + method.getName() + "\", arguments);}");
                method.setBody(methodBody);
            }
            File directory = this.getClassOutputDirectory(existingClass);
            pool.writeFile(className, directory != null ? directory.getAbsolutePath() : "");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new ScriptClassGeneratorException(throwable);
        }
    }

    private File getClassOutputDirectory(Class existingClass) {
        String className = existingClass.getName();
        String classResourcePath = '/' + className.replace('.', '/') + ".class";
        URL classResource = existingClass.getResource(classResourcePath);
        if (classResource == null) {
            throw new ScriptClassGeneratorException("Could not find the class resource '" + classResourcePath + "'");
        }
        String file = classResource.getFile().replaceAll(".*(\\\\|//)", "/");
        return new File(StringUtils.replace((String)file, (String)classResourcePath, (String)""));
    }

    private String contructArgumentString(CtMethod method) throws NotFoundException {
        CtClass[] argumentTypes = method.getParameterTypes();
        int argumentNumber = argumentTypes.length;
        StringBuffer arguments = new StringBuffer("final Object[] arguments = new Object[" + argumentNumber + "];");
        for (int ctr = 1; ctr <= argumentNumber; ++ctr) {
            CtClass argumentType = argumentTypes[ctr - 1];
            arguments.append("arguments[" + (ctr - 1) + "] = ");
            if (argumentType.isPrimitive()) {
                arguments.append("new java.lang." + this.getWrapperTypeName(argumentType) + "($" + ctr + ");");
                continue;
            }
            arguments.append("$" + ctr + ";");
        }
        return arguments.toString();
    }

    private String getWrapperTypeName(CtClass ctClass) {
        String typeName = ctClass.getName();
        StringBuffer name = new StringBuffer(typeName);
        if (typeName.equalsIgnoreCase("int")) {
            name.append("eger");
        }
        return StringUtils.capitalize((String)name.toString());
    }

    private String getScriptWrapperInitialization(String directory, String className) {
        return "new " + this.scriptWrapperName + "(this, \"" + new File(directory, className.replace('.', '/')).getAbsolutePath().replace('\\', '/') + ".java" + "\");";
    }

    private CtClass convert(ClassPool pool, String className) throws NotFoundException {
        CtClass ctClass = null;
        if (className != null) {
            ctClass = pool.get(className);
        }
        return ctClass;
    }
}

