/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin.andromdapp.utils;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;

public class ProjectUtils {
    private static final Map projectCache = new HashMap();
    private static final String POM_FILE = "pom.xml";

    public static synchronized MavenProject getProject(MavenProjectBuilder projectBuilder, MavenSession session, File pom, Log logger) throws ProjectBuildingException {
        MavenProject project;
        block3: {
            project = (MavenProject)projectCache.get(pom);
            if (project == null && (project = ProjectUtils.getProjectFromSession(session, pom)) == null) {
                try {
                    project = projectBuilder.build(pom, session.getLocalRepository(), (ProfileManager)new DefaultProfileManager(session.getContainer()));
                    projectCache.put(pom, project);
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((CharSequence)("Failed to build project from pom: " + pom), (Throwable)ex);
                }
            }
        }
        return project;
    }

    private static MavenProject getProjectFromSession(MavenSession session, File pom) {
        MavenProject foundProject = null;
        for (MavenProject project : session.getSortedProjects()) {
            File projectPom = new File(project.getBasedir(), POM_FILE);
            if (!projectPom.equals(pom)) continue;
            foundProject = project;
        }
        return foundProject;
    }
}

