/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.templateengines.velocity;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.Constants;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.Merger;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.common.ResourceWriter;
import org.andromda.core.templateengine.TemplateEngine;
import org.andromda.core.templateengine.TemplateEngineException;
import org.andromda.templateengines.velocity.ClasspathResourceLoader;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogSystem;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;

public class VelocityTemplateEngine
implements TemplateEngine {
    protected static Logger logger = null;
    private static final String PROPERTIES_DIR = "META-INF/";
    private static final String PROPERTIES_SUFFIX = "-velocity.properties";
    private static final String TEMPORARY_TEMPLATE_LOCATION = Constants.TEMPORARY_DIRECTORY + "velocity/merged";
    private String mergeLocation;
    private Properties properties = null;
    private String namespace;
    private VelocityEngine velocityEngine;
    private VelocityContext velocityContext;
    private final List macroLibraries = new ArrayList();
    private final Map discoveredTemplates = new HashMap();
    private final Collection mergedTemplateFiles = new ArrayList();
    private static final String LOG_TAG = "logtag";

    public void initialize(String namespace) throws Exception {
        this.namespace = namespace;
        this.initLogger(namespace);
        ExtendedProperties engineProperties = new ExtendedProperties();
        engineProperties.setProperty("resource.loader", (Object)"file,classpath");
        engineProperties.setProperty("file.resource.loader.class", (Object)FileResourceLoader.class.getName());
        engineProperties.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        engineProperties.setProperty("runtime.log.logsystem", (Object)new VelocityLoggingReceiver());
        Iterator iterator = this.getMacroLibraries().iterator();
        while (iterator.hasNext()) {
            engineProperties.addProperty("velocimacro.library", iterator.next());
        }
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.setExtendedProperties(engineProperties);
        if (this.mergeLocation != null) {
            this.velocityEngine.addProperty("file.resource.loader.path", (Object)this.mergeLocation);
        }
        if (Merger.instance().requiresMerge(this.namespace)) {
            this.velocityEngine.addProperty("file.resource.loader.path", (Object)this.getMergedTemplatesLocation());
        }
        this.addProperties(namespace);
        this.velocityEngine.init();
    }

    private void addProperties(String pluginName) throws IOException {
        this.properties = null;
        URL propertiesUri = ResourceUtils.getResource((String)(PROPERTIES_DIR + StringUtils.trimToEmpty((String)pluginName) + PROPERTIES_SUFFIX));
        if (propertiesUri != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("loading properties from --> '" + propertiesUri + "'"));
            }
            this.properties = new Properties();
            this.properties.load(propertiesUri.openStream());
            for (String string : this.properties.keySet()) {
                String value = this.properties.getProperty(string);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("setting property '" + string + "' with --> '" + value + "'"));
                }
                this.velocityEngine.setProperty(string, (Object)value);
            }
        }
    }

    public void processTemplate(String templateFile, Map templateObjects, Writer output) throws Exception {
        String methodName = "VelocityTemplateEngine.processTemplate";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("performing VelocityTemplateEngine.processTemplate with templateFile '" + templateFile + "' and templateObjects '" + templateObjects + "'"));
        }
        ExceptionUtils.checkEmpty((String)"templateFile", (String)templateFile);
        ExceptionUtils.checkNull((String)"output", (Object)output);
        this.velocityContext = new VelocityContext();
        this.loadVelocityContext(templateObjects);
        Template template = (Template)this.discoveredTemplates.get(templateFile);
        if (template == null) {
            template = this.velocityEngine.getTemplate(templateFile);
            Merger merger = Merger.instance();
            if (merger.requiresMerge(this.namespace)) {
                String mergedTemplateLocation = this.getMergedTemplateLocation(templateFile);
                InputStream resource = template.getResourceLoader().getResourceStream(templateFile);
                ResourceWriter.instance().writeStringToFile(merger.getMergedString(resource, this.namespace), mergedTemplateLocation);
                template = this.velocityEngine.getTemplate(templateFile);
                this.mergedTemplateFiles.add(new File(mergedTemplateLocation));
            }
            this.discoveredTemplates.put(templateFile, template);
        }
        template.merge((Context)this.velocityContext, output);
    }

    private final void loadVelocityContext(Map templateObjects) {
        if (templateObjects != null && !templateObjects.isEmpty() && templateObjects != null) {
            for (String name : templateObjects.keySet()) {
                Object value = templateObjects.get(name);
                this.velocityContext.put(name, value);
            }
        }
    }

    private String getMergedTemplateLocation(String templatePath) {
        return this.getMergedTemplatesLocation() + "/" + templatePath;
    }

    private String getMergedTemplatesLocation() {
        return TEMPORARY_TEMPLATE_LOCATION + "/" + this.namespace;
    }

    public String getEvaluatedExpression(String expression, Map templateObjects) {
        String evaluatedExpression = null;
        if (StringUtils.isNotEmpty((String)expression) && templateObjects != null && !templateObjects.isEmpty()) {
            if (this.velocityContext == null) {
                this.velocityContext = new VelocityContext();
                this.loadVelocityContext(templateObjects);
            }
            try {
                StringWriter writer = new StringWriter();
                this.velocityEngine.evaluate((Context)this.velocityContext, (Writer)writer, LOG_TAG, expression);
                evaluatedExpression = writer.toString();
            }
            catch (Throwable throwable) {
                throw new TemplateEngineException(throwable);
            }
        }
        return evaluatedExpression;
    }

    public List getMacroLibraries() {
        return this.macroLibraries;
    }

    public void addMacroLibrary(String libraryName) {
        this.macroLibraries.add(libraryName);
    }

    public void setMergeLocation(String mergeLocation) {
        this.mergeLocation = mergeLocation;
    }

    public void shutdown() {
        this.deleteMergedTemplatesLocation();
        this.discoveredTemplates.clear();
        this.velocityEngine = null;
    }

    private final void deleteMergedTemplatesLocation() {
        File directory = new File(TEMPORARY_TEMPLATE_LOCATION);
        if (directory.getParentFile().isDirectory()) {
            directory = directory.getParentFile();
            ResourceUtils.deleteDirectory((File)directory);
            directory.delete();
        }
    }

    private final void initLogger(String pluginName) throws IOException {
        logger = AndroMDALogger.getNamespaceLogger((String)pluginName);
        logger.setAdditivity(false);
        FileAppender appender = new FileAppender((Layout)new PatternLayout("%-5p %d - %m%n"), AndroMDALogger.getNamespaceLogFileName((String)pluginName), true);
        logger.addAppender((Appender)appender);
    }

    static class VelocityLoggingReceiver
    implements LogSystem {
        VelocityLoggingReceiver() {
        }

        public void init(RuntimeServices services) throws Exception {
        }

        public void logVelocityMessage(int level, String message) {
            switch (level) {
                case 2: {
                    logger.info((Object)message);
                    break;
                }
                case 1: {
                    logger.info((Object)message);
                    break;
                }
                case 0: {
                    logger.debug((Object)message);
                    break;
                }
                case 3: {
                    logger.info((Object)message);
                    break;
                }
                default: {
                    logger.debug((Object)message);
                }
            }
        }
    }
}

