/*
 *    Copyright 2016 Jonathan Beaudoin <https://github.com/Jonatino>
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package org.anglur.joglext.newt.opengl

import com.jogamp.newt.event.WindowAdapter
import com.jogamp.newt.event.WindowEvent
import com.jogamp.newt.opengl.GLWindow
import com.jogamp.opengl.*
import com.jogamp.opengl.util.FPSAnimator
import com.jogamp.opengl.util.gl2.GLUT
import org.anglur.joglext.jogl2d.GLGraphics2D
import java.awt.Color
import java.util.*
import kotlin.concurrent.thread

fun main(args: Array<String>) {
	CharlatanoOverlay.open()
	
	CharlatanoOverlay {
		it.color = Color.WHITE
		it.drawRect(0,0,100,100)
		for (i in 0..10)
			it.drawRect(rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500))
		it.color = Color.ORANGE
		for (i in 0..100)
			it.drawLine(rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500))
		/*for (i in 0..1000)
			it.drawRoundRect(rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500))
		it.color = Color.RED
		for (i in 0..1000)
			it.drawString("dsajfhksadhfksldjfhklsdafhkjldsfhkljdsahfksda", rand(0, 500), rand(0, 500))*/
	}
	CharlatanoOverlay {
		it.color = Color.WHITE
		it.drawRect(0,0,100,100)
		for (i in 0..10)
			it.drawRect(rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500))
		it.color = Color.ORANGE
		for (i in 0..100)
			it.drawLine(rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500))
		/*for (i in 0..1000)
			it.drawRoundRect(rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500))
		it.color = Color.RED
		for (i in 0..1000)
			it.drawString("dsajfhksadhfksldjfhklsdafhkjldsfhkljdsahfksda", rand(0, 500), rand(0, 500))*/
	}
	CharlatanoOverlay {
		it.color = Color.WHITE
		it.drawRect(0,0,100,100)
		for (i in 0..10)
			it.drawRect(rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500))
		it.color = Color.ORANGE
		for (i in 0..100)
			it.drawLine(rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500))
		/*for (i in 0..1000)
			it.drawRoundRect(rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500))
		it.color = Color.RED
		for (i in 0..1000)
			it.drawString("dsajfhksadhfksldjfhklsdafhkjldsfhkljdsahfksda", rand(0, 500), rand(0, 500))*/
	}
	CharlatanoOverlay {
		it.color = Color.WHITE
		it.drawRect(0,0,100,100)
		for (i in 0..10)
			it.drawRect(rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500))
		it.color = Color.ORANGE
		for (i in 0..100)
			it.drawLine(rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500))
		/*for (i in 0..1000)
			it.drawRoundRect(rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500), rand(0, 500))
		it.color = Color.RED
		for (i in 0..1000)
			it.drawString("dsajfhksadhfksldjfhklsdafhkjldsfhkljdsahfksda", rand(0, 500), rand(0, 500))*/
	}
}

fun rand(min: Int, max: Int) = (min + (Math.random() * max)).toInt()

object CharlatanoOverlay : GLEventListener {
	
	private val TITLE = "Hello world"
	private val WINDOW_WIDTH = 500
	private val WINDOW_HEIGHT = 500
	private val FPS = 60
	
	val glut = GLUT()
	
	val window by lazy {
		val glp = GLProfile.getDefault()
		val caps = GLCapabilities(glp)
		caps.alphaBits = 8
		caps.isBackgroundOpaque = false
		
		GLWindow.create(caps)
	}
	
	init {
		GLProfile.initSingleton()
	}
	
	fun open(width: Int = WINDOW_WIDTH, height: Int = WINDOW_HEIGHT, x: Int = 0, y: Int = 0) {
		window.isUndecorated = true
		window.isAlwaysOnTop = true
		val animator = FPSAnimator(window, FPS, true)
		
		window.addWindowListener(object : WindowAdapter() {
			override fun windowDestroyNotify(e: WindowEvent) {
				thread {
					if (animator.isStarted)
						animator.stop()
					System.exit(0)
				}.start()
			}
		})
		
		window.addGLEventListener(this)
		window.setSize(width, height)
		window.setPosition(x, y)
		window.title = TITLE
		window.isVisible = true
		animator.start()
	}
	
	val g = GLGraphics2D()
	
	override fun display(gLDrawable: GLAutoDrawable) {
		val gl2 = gLDrawable.gl.gL2
		
		gl2.glEnable(GL.GL_BLEND)
		gl2.glBlendFunc(GL.GL_SRC_ALPHA, GL.GL_ONE_MINUS_SRC_ALPHA)
		
		gl2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f)
		gl2.glClear(GL.GL_COLOR_BUFFER_BIT)
		
		g.prePaint(gLDrawable.context)
		for (x in 0..bodies.size - 1) {
			bodies[x](g)
		}
		
		gl2.glEnd()
		gl2.glFlush()
		
		gl2.glDisable(GL.GL_BLEND)
	}
	
	override fun init(glDrawable: GLAutoDrawable) {
		val gl = glDrawable.gl.gL2
		gl.glEnable(GL.GL_BLEND)
		gl.glBlendFunc(GL.GL_SRC_ALPHA, GL.GL_ONE_MINUS_SRC_ALPHA)
	}
	
	override fun reshape(gLDrawable: GLAutoDrawable, x: Int, y: Int, width: Int, height: Int) {
		val gl = gLDrawable.gl.gL2
		gl.glViewport(0, 0, width, height)
	}
	
	override fun dispose(gLDrawable: GLAutoDrawable) {
		g.glDispose()
	}
	
	private val bodies = ArrayList<CharlatanoOverlay.(GLGraphics2D) -> Unit>()
	
	operator fun invoke(body: CharlatanoOverlay.(GLGraphics2D) -> Unit) {
		bodies.add(body)
	}
	
}