/*
 * Decompiled with CFR 0.152.
 */
package org.anglur.joglext.jogl2d;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES1;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.anglur.joglext.cacheable.CachedIntArray;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/anglur/joglext/jogl2d/GLG2DUtils;", "", "()V", "ids", "", "viewportDimensions", "ensureIsGLBuffer", "", "gl", "Lcom/jogamp/opengl/GL;", "bufferId", "genBufferId", "getGLColor", "", "kotlin.jvm.PlatformType", "c", "Ljava/awt/Color;", "getViewportHeight", "setColor", "", "Lcom/jogamp/opengl/GL2ES1;", "preMultiplyAlpha", "", "JOGLExt"})
public final class GLG2DUtils {
    private static final int[] viewportDimensions;
    private static final int[] ids;
    public static final GLG2DUtils INSTANCE;

    public final void setColor(@NotNull GL2ES1 gl, @NotNull Color c, float preMultiplyAlpha) {
        Intrinsics.checkParameterIsNotNull((Object)gl, (String)"gl");
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        int rgb = c.getRGB();
        gl.glColor4ub((byte)(rgb >> 16 & 0xFF), (byte)(rgb >> 8 & 0xFF), (byte)(rgb & 0xFF), (byte)((float)(rgb >> 24 & 0xFF) * preMultiplyAlpha));
    }

    public final float[] getGLColor(@NotNull Color c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        return c.getComponents(null);
    }

    public final int getViewportHeight(@NotNull GL gl) {
        Intrinsics.checkParameterIsNotNull((Object)gl, (String)"gl");
        gl.glGetIntegerv(2978, viewportDimensions, 0);
        int canvasHeight = viewportDimensions[3];
        return canvasHeight;
    }

    public final int ensureIsGLBuffer(@NotNull GL gl, int bufferId) {
        Intrinsics.checkParameterIsNotNull((Object)gl, (String)"gl");
        return gl.glIsBuffer(bufferId) ? bufferId : this.genBufferId(gl);
    }

    public final int genBufferId(@NotNull GL gl) {
        Intrinsics.checkParameterIsNotNull((Object)gl, (String)"gl");
        gl.glGenBuffers(1, ids, 0);
        return ids[0];
    }

    private GLG2DUtils() {
    }

    static {
        GLG2DUtils gLG2DUtils;
        INSTANCE = gLG2DUtils = new GLG2DUtils();
        viewportDimensions = CachedIntArray.INSTANCE.invoke(4);
        ids = CachedIntArray.INSTANCE.invoke(1);
    }
}

