/*
 * Decompiled with CFR 0.152.
 */
package org.anglur.joglext.jogl2d;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.anglur.joglext.cacheable.CachedList;
import org.anglur.joglext.jogl2d.G2DDrawingHelper;
import org.anglur.joglext.jogl2d.GLG2DImageHelper;
import org.anglur.joglext.jogl2d.GLG2DShapeHelper;
import org.anglur.joglext.jogl2d.GLG2DTextHelper;
import org.anglur.joglext.jogl2d.GLG2DTransformHelper;
import org.anglur.joglext.jogl2d.GLG2DUtils;
import org.anglur.joglext.jogl2d.impl.GLGraphicsConfiguration;
import org.anglur.joglext.jogl2d.impl.gl2.GL2ColorHelper;
import org.anglur.joglext.jogl2d.impl.gl2.GL2ImageDrawer;
import org.anglur.joglext.jogl2d.impl.gl2.GL2ShapeDrawer;
import org.anglur.joglext.jogl2d.impl.gl2.GL2StringDrawer;
import org.anglur.joglext.jogl2d.impl.gl2.GL2Transformhelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0001\n\u0002\b\u000e\u0018\u0000 \u00c8\u00012\u00020\u00012\u00020\u0002:\u0002\u00c8\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001bJ\u0018\u00103\u001a\u0002042\u000e\u0010\u001c\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u000305H\u0016J(\u00106\u001a\u0002042\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u0002042\u0006\u0010;\u001a\u00020<H\u0016J(\u0010=\u001a\u0002042\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0005H\u0016J\b\u0010>\u001a\u00020\u0000H\u0014J8\u0010?\u001a\u0002042\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u00052\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0005H\u0016J\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u000204H\u0016J\u0010\u0010E\u001a\u0002042\u0006\u0010;\u001a\u00020<H\u0016J8\u0010F\u001a\u0002042\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u0005H\u0016J \u0010I\u001a\u0002042\u0006\u0010J\u001a\u00020K2\u0006\u00107\u001a\u00020L2\u0006\u00108\u001a\u00020LH\u0016J \u0010M\u001a\u00020#2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020SH\u0016J0\u0010M\u001a\u00020#2\u0006\u0010N\u001a\u00020O2\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020SH\u0016J(\u0010M\u001a\u00020#2\u0006\u0010N\u001a\u00020O2\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u0010V\u001a\u00020SH\u0016J@\u0010M\u001a\u00020#2\u0006\u0010N\u001a\u00020O2\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u00052\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020SH\u0016J8\u0010M\u001a\u00020#2\u0006\u0010N\u001a\u00020O2\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u00052\u0006\u0010V\u001a\u00020SH\u0016J`\u0010M\u001a\u00020#2\u0006\u0010N\u001a\u00020O2\u0006\u0010W\u001a\u00020\u00052\u0006\u0010X\u001a\u00020\u00052\u0006\u0010Y\u001a\u00020\u00052\u0006\u0010Z\u001a\u00020\u00052\u0006\u0010[\u001a\u00020\u00052\u0006\u0010\\\u001a\u00020\u00052\u0006\u0010]\u001a\u00020\u00052\u0006\u0010^\u001a\u00020\u00052\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020SH\u0016JX\u0010M\u001a\u00020#2\u0006\u0010N\u001a\u00020O2\u0006\u0010W\u001a\u00020\u00052\u0006\u0010X\u001a\u00020\u00052\u0006\u0010Y\u001a\u00020\u00052\u0006\u0010Z\u001a\u00020\u00052\u0006\u0010[\u001a\u00020\u00052\u0006\u0010\\\u001a\u00020\u00052\u0006\u0010]\u001a\u00020\u00052\u0006\u0010^\u001a\u00020\u00052\u0006\u0010V\u001a\u00020SH\u0016J(\u0010M\u001a\u0002042\u0006\u0010N\u001a\u00020_2\u0006\u0010`\u001a\u00020a2\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u0005H\u0016J(\u0010b\u001a\u0002042\u0006\u0010c\u001a\u00020\u00052\u0006\u0010d\u001a\u00020\u00052\u0006\u0010e\u001a\u00020\u00052\u0006\u0010f\u001a\u00020\u0005H\u0016J(\u0010g\u001a\u0002042\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0005H\u0016J \u0010h\u001a\u0002042\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020j2\u0006\u0010l\u001a\u00020\u0005H\u0016J \u0010m\u001a\u0002042\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020j2\u0006\u0010l\u001a\u00020\u0005H\u0016J(\u0010n\u001a\u0002042\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0005H\u0016J\u0018\u0010o\u001a\u0002042\u0006\u0010N\u001a\u00020p2\u0006\u0010P\u001a\u00020QH\u0016J\u0018\u0010q\u001a\u0002042\u0006\u0010N\u001a\u00020r2\u0006\u0010P\u001a\u00020QH\u0016J8\u0010s\u001a\u0002042\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u00052\u0006\u0010t\u001a\u00020\u00052\u0006\u0010u\u001a\u00020\u0005H\u0016J \u0010v\u001a\u0002042\u0006\u0010w\u001a\u00020x2\u0006\u00107\u001a\u00020L2\u0006\u00108\u001a\u00020LH\u0016J \u0010v\u001a\u0002042\u0006\u0010w\u001a\u00020x2\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u0005H\u0016J \u0010v\u001a\u0002042\u0006\u0010y\u001a\u00020z2\u0006\u00107\u001a\u00020L2\u0006\u00108\u001a\u00020LH\u0016J \u0010v\u001a\u0002042\u0006\u0010y\u001a\u00020z2\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u0005H\u0016J\u0010\u0010{\u001a\u0002042\u0006\u0010;\u001a\u00020<H\u0016J8\u0010|\u001a\u0002042\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u0005H\u0016J(\u0010}\u001a\u0002042\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0005H\u0016J \u0010~\u001a\u0002042\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020j2\u0006\u0010l\u001a\u00020\u0005H\u0016J(\u0010\u007f\u001a\u0002042\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0005H\u0016J9\u0010\u0080\u0001\u001a\u0002042\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u00052\u0006\u0010t\u001a\u00020\u00052\u0006\u0010u\u001a\u00020\u0005H\u0016J\t\u0010\u0081\u0001\u001a\u00020UH\u0016J\u000b\u0010\u0082\u0001\u001a\u0004\u0018\u00010<H\u0016J\u000b\u0010\u0083\u0001\u001a\u0004\u0018\u00010\nH\u0016J\t\u0010\u0084\u0001\u001a\u00020UH\u0016J\n\u0010\u0085\u0001\u001a\u00030\u0086\u0001H\u0016J\t\u0010\u0087\u0001\u001a\u00020\u0018H\u0016J\n\u0010\u0088\u0001\u001a\u00030\u0089\u0001H\u0016J\u0014\u0010\u008a\u0001\u001a\u00030\u008b\u00012\b\u0010\u008c\u0001\u001a\u00030\u0089\u0001H\u0016J\n\u0010\u008d\u0001\u001a\u00030\u008e\u0001H\u0016J\n\u0010\u008f\u0001\u001a\u00030\u0090\u0001H\u0016J\u0016\u0010\u0091\u0001\u001a\u0005\u0018\u00010\u0092\u00012\b\u0010\u0093\u0001\u001a\u00030\u0094\u0001H\u0016J\t\u0010\u0095\u0001\u001a\u00020\u001dH\u0016J\n\u0010\u0096\u0001\u001a\u00030\u0097\u0001H\u0016J\t\u0010\u0098\u0001\u001a\u00020QH\u0016J\u0007\u0010\u0099\u0001\u001a\u000204J#\u0010\u009a\u0001\u001a\u00020#2\u0007\u0010\u009b\u0001\u001a\u00020\n2\u0006\u0010;\u001a\u00020<2\u0007\u0010\u009c\u0001\u001a\u00020#H\u0016J\u0007\u0010\u009d\u0001\u001a\u000204J\u0010\u0010\u009e\u0001\u001a\u0002042\u0007\u0010\u009f\u0001\u001a\u00020\u0010J\u000f\u0010\u00a0\u0001\u001a\u0002042\u0006\u00102\u001a\u00020\u001bJ\t\u0010\u00a1\u0001\u001a\u000204H\u0002J\u0013\u0010\u00a2\u0001\u001a\u0002042\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u0001H\u0016J%\u0010\u00a2\u0001\u001a\u0002042\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u00012\u0007\u00107\u001a\u00030\u00a4\u00012\u0007\u00108\u001a\u00030\u00a4\u0001H\u0016J\u001d\u0010\u00a5\u0001\u001a\u0002042\b\u0010\u00a6\u0001\u001a\u00030\u00a4\u00012\b\u0010\u00a7\u0001\u001a\u00030\u00a4\u0001H\u0016J\u0012\u0010\u00a8\u0001\u001a\u0002042\u0007\u0010\u00a9\u0001\u001a\u00020#H\u0002J\u0012\u0010\u00aa\u0001\u001a\u0002042\u0007\u0010\u00ab\u0001\u001a\u00020UH\u0016J\u0012\u0010\u00ac\u0001\u001a\u0002042\u0007\u0010\u009f\u0001\u001a\u00020\u0010H\u0002J\u0014\u0010\u00ad\u0001\u001a\u0002042\t\u0010\u00ae\u0001\u001a\u0004\u0018\u00010<H\u0016J\u001e\u0010\u00ad\u0001\u001a\u0002042\n\u0010\u00ae\u0001\u001a\u0005\u0018\u00010\u00af\u00012\u0007\u0010\u00b0\u0001\u001a\u00020#H\u0002J)\u0010\u00ad\u0001\u001a\u0002042\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0005H\u0016J\u0012\u0010\u00b1\u0001\u001a\u0002042\u0007\u0010\u00b2\u0001\u001a\u00020UH\u0016J\u0013\u0010\u00b3\u0001\u001a\u0002042\b\u0010\u00b4\u0001\u001a\u00030\u0086\u0001H\u0016J\t\u0010\u00b5\u0001\u001a\u000204H\u0002J\u0013\u0010\u00b6\u0001\u001a\u0002042\b\u0010\u00b7\u0001\u001a\u00030\u0089\u0001H\u0016J\u0013\u0010\u00b8\u0001\u001a\u0002042\b\u0010\u00b9\u0001\u001a\u00030\u0090\u0001H\u0016J\n\u0010\u00ba\u0001\u001a\u00030\u00bb\u0001H\u0016J\u001d\u0010\u00bc\u0001\u001a\u0002042\b\u0010\u0093\u0001\u001a\u00030\u0094\u00012\b\u0010\u00bd\u0001\u001a\u00030\u0092\u0001H\u0016J\u001b\u0010\u00be\u0001\u001a\u0002042\u0010\u0010\u001c\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u000105H\u0016J\u0012\u0010\u00bf\u0001\u001a\u0002042\u0007\u0010;\u001a\u00030\u0097\u0001H\u0016J\u0012\u0010\u00c0\u0001\u001a\u0002042\u0007\u0010\u00c1\u0001\u001a\u00020QH\u0016J\u0013\u0010\u00c2\u0001\u001a\u00030\u00bb\u00012\u0007\u0010\u00b2\u0001\u001a\u00020UH\u0016J\u001d\u0010\u00c3\u0001\u001a\u0002042\b\u0010\u00c4\u0001\u001a\u00030\u00a4\u00012\b\u0010\u00c5\u0001\u001a\u00030\u00a4\u0001H\u0016J\u0012\u0010\u00c1\u0001\u001a\u0002042\u0007\u0010\u00c6\u0001\u001a\u00020QH\u0016J\u001b\u0010\u00c7\u0001\u001a\u0002042\u0007\u00107\u001a\u00030\u00a4\u00012\u0007\u00108\u001a\u00030\u00a4\u0001H\u0016J\u0019\u0010\u00c7\u0001\u001a\u0002042\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u0005H\u0016R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0010\u0010(\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u0006\u00c9\u0001"}, d2={"Lorg/anglur/joglext/jogl2d/GLGraphics2D;", "Ljava/awt/Graphics2D;", "", "()V", "<set-?>", "", "canvasHeight", "getCanvasHeight", "()I", "clip", "Ljava/awt/Rectangle;", "colorHelper", "Lorg/anglur/joglext/jogl2d/impl/gl2/GL2ColorHelper;", "getColorHelper", "()Lorg/anglur/joglext/jogl2d/impl/gl2/GL2ColorHelper;", "glContext", "Lcom/jogamp/opengl/GLContext;", "getGlContext", "()Lcom/jogamp/opengl/GLContext;", "setGlContext", "(Lcom/jogamp/opengl/GLContext;)V", "glDrawable", "Lcom/jogamp/opengl/GLDrawable;", "graphicsConfig", "Ljava/awt/GraphicsConfiguration;", "helpers", "Lorg/anglur/joglext/cacheable/CachedList;", "Lorg/anglur/joglext/jogl2d/G2DDrawingHelper;", "hints", "Ljava/awt/RenderingHints;", "imageHelper", "Lorg/anglur/joglext/jogl2d/GLG2DImageHelper;", "getImageHelper", "()Lorg/anglur/joglext/jogl2d/GLG2DImageHelper;", "isDisposed", "", "matrixHelper", "Lorg/anglur/joglext/jogl2d/GLG2DTransformHelper;", "getMatrixHelper", "()Lorg/anglur/joglext/jogl2d/GLG2DTransformHelper;", "parent", "shapeHelper", "Lorg/anglur/joglext/jogl2d/GLG2DShapeHelper;", "getShapeHelper", "()Lorg/anglur/joglext/jogl2d/GLG2DShapeHelper;", "stringHelper", "Lorg/anglur/joglext/jogl2d/GLG2DTextHelper;", "getStringHelper", "()Lorg/anglur/joglext/jogl2d/GLG2DTextHelper;", "addG2DDrawingHelper", "helper", "addRenderingHints", "", "", "clearRect", "x", "y", "width", "height", "s", "Ljava/awt/Shape;", "clipRect", "clone", "copyArea", "dx", "dy", "create", "Ljava/awt/Graphics;", "dispose", "draw", "drawArc", "startAngle", "arcAngle", "drawGlyphVector", "g", "Ljava/awt/font/GlyphVector;", "", "drawImage", "img", "Ljava/awt/Image;", "xform", "Ljava/awt/geom/AffineTransform;", "obs", "Ljava/awt/image/ImageObserver;", "bgcolor", "Ljava/awt/Color;", "observer", "dx1", "dy1", "dx2", "dy2", "sx1", "sy1", "sx2", "sy2", "Ljava/awt/image/BufferedImage;", "op", "Ljava/awt/image/BufferedImageOp;", "drawLine", "x1", "y1", "x2", "y2", "drawOval", "drawPolygon", "xPoints", "", "yPoints", "nPoints", "drawPolyline", "drawRect", "drawRenderableImage", "Ljava/awt/image/renderable/RenderableImage;", "drawRenderedImage", "Ljava/awt/image/RenderedImage;", "drawRoundRect", "arcWidth", "arcHeight", "drawString", "iterator", "Ljava/text/AttributedCharacterIterator;", "str", "", "fill", "fillArc", "fillOval", "fillPolygon", "fillRect", "fillRoundRect", "getBackground", "getClip", "getClipBounds", "getColor", "getComposite", "Ljava/awt/Composite;", "getDeviceConfiguration", "getFont", "Ljava/awt/Font;", "getFontMetrics", "Ljava/awt/FontMetrics;", "f", "getFontRenderContext", "Ljava/awt/font/FontRenderContext;", "getPaint", "Ljava/awt/Paint;", "getRenderingHint", "", "hintKey", "Ljava/awt/RenderingHints$Key;", "getRenderingHints", "getStroke", "Ljava/awt/Stroke;", "getTransform", "glDispose", "hit", "rect", "onStroke", "postPaint", "prePaint", "context", "removeG2DDrawingHelper", "resetRenderingHints", "rotate", "theta", "", "scale", "sx", "sy", "scissor", "enable", "setBackground", "color", "setCanvas", "setClip", "clipShape", "Ljava/awt/geom/Rectangle2D;", "intersect", "setColor", "c", "setComposite", "comp", "setDefaultState", "setFont", "font", "setPaint", "paint", "setPaintMode", "", "setRenderingHint", "hintValue", "setRenderingHints", "setStroke", "setTransform", "transform", "setXORMode", "shear", "shx", "shy", "Tx", "translate", "Companion", "JOGLExt"})
public final class GLGraphics2D
extends Graphics2D
implements Cloneable {
    private GLGraphics2D parent;
    private GLDrawable glDrawable;
    @NotNull
    public GLContext glContext;
    private boolean isDisposed;
    private int canvasHeight;
    private CachedList<? extends G2DDrawingHelper> helpers = new CachedList(5);
    @NotNull
    private final GLG2DShapeHelper shapeHelper;
    @NotNull
    private final GLG2DImageHelper imageHelper;
    @NotNull
    private final GLG2DTextHelper stringHelper;
    @NotNull
    private final GLG2DTransformHelper matrixHelper;
    @NotNull
    private final GL2ColorHelper colorHelper;
    private Rectangle clip;
    private GraphicsConfiguration graphicsConfig;
    private RenderingHints hints;
    private static final Font defaultFont;
    private static final BasicStroke defaultStroke;
    public static final Companion Companion;

    @NotNull
    public final GLContext getGlContext() {
        GLContext gLContext = this.glContext;
        if (gLContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"glContext");
        }
        return gLContext;
    }

    public final void setGlContext(@NotNull GLContext gLContext) {
        Intrinsics.checkParameterIsNotNull((Object)gLContext, (String)"<set-?>");
        this.glContext = gLContext;
    }

    public final int getCanvasHeight() {
        return this.canvasHeight;
    }

    @NotNull
    public final GLG2DShapeHelper getShapeHelper() {
        return this.shapeHelper;
    }

    @NotNull
    public final GLG2DImageHelper getImageHelper() {
        return this.imageHelper;
    }

    @NotNull
    public final GLG2DTextHelper getStringHelper() {
        return this.stringHelper;
    }

    @NotNull
    public final GLG2DTransformHelper getMatrixHelper() {
        return this.matrixHelper;
    }

    @NotNull
    public final GL2ColorHelper getColorHelper() {
        return this.colorHelper;
    }

    @NotNull
    public final G2DDrawingHelper addG2DDrawingHelper(@NotNull G2DDrawingHelper helper) {
        Intrinsics.checkParameterIsNotNull((Object)helper, (String)"helper");
        this.helpers.add(helper);
        return helper;
    }

    public final void removeG2DDrawingHelper(@NotNull G2DDrawingHelper helper) {
        Intrinsics.checkParameterIsNotNull((Object)helper, (String)"helper");
        this.helpers.remove(helper);
    }

    private final void setCanvas(GLContext context) {
        GLDrawable gLDrawable = context.getGLDrawable();
        Intrinsics.checkExpressionValueIsNotNull((Object)gLDrawable, (String)"context.glDrawable");
        this.glDrawable = gLDrawable;
        this.glContext = context;
        for (G2DDrawingHelper g2DDrawingHelper : this.helpers) {
            g2DDrawingHelper.setG2D(this);
        }
    }

    public final void prePaint(@NotNull GLContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        GL gL = context.getGL();
        Intrinsics.checkExpressionValueIsNotNull((Object)gL, (String)"context.gl");
        this.canvasHeight = GLG2DUtils.INSTANCE.getViewportHeight(gL);
        this.setCanvas(context);
        this.setDefaultState();
    }

    private final void setDefaultState() {
        Color color = Color.black;
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.black");
        this.setBackground(color);
        Color color2 = Color.white;
        Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"Color.white");
        this.setColor(color2);
        this.setFont(defaultFont);
        this.setStroke(defaultStroke);
        AlphaComposite alphaComposite = AlphaComposite.SrcOver;
        Intrinsics.checkExpressionValueIsNotNull((Object)alphaComposite, (String)"AlphaComposite.SrcOver");
        this.setComposite(alphaComposite);
        this.setClip(null);
        this.setRenderingHints(null);
        GLDrawable gLDrawable = this.glDrawable;
        if (gLDrawable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"glDrawable");
        }
        this.graphicsConfig = GLGraphicsConfiguration.INSTANCE.setDrawable(gLDrawable);
    }

    public final void postPaint() {
    }

    public final void glDispose() {
        for (G2DDrawingHelper g2DDrawingHelper : this.helpers) {
            g2DDrawingHelper.dispose();
        }
    }

    @Override
    public void draw(@NotNull Shape s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this.shapeHelper.draw(s);
    }

    @Override
    public void drawString(@NotNull String str, int x, int y) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        this.stringHelper.drawString(str, x, y);
    }

    @Override
    public void drawString(@NotNull String str, float x, float y) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        this.stringHelper.drawString(str, x, y);
    }

    @Override
    public void drawString(@NotNull AttributedCharacterIterator iterator, int x, int y) {
        Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
        this.stringHelper.drawString(iterator, x, y);
    }

    @Override
    public void drawString(@NotNull AttributedCharacterIterator iterator, float x, float y) {
        Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
        this.stringHelper.drawString(iterator, x, y);
    }

    @Override
    public void drawGlyphVector(@NotNull GlyphVector g, float x, float y) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Shape shape = g.getOutline(x, y);
        Intrinsics.checkExpressionValueIsNotNull((Object)shape, (String)"g.getOutline(x, y)");
        this.shapeHelper.fill(shape);
    }

    @Override
    public void fill(@NotNull Shape s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this.shapeHelper.fill(s);
    }

    @Override
    public boolean hit(@NotNull Rectangle rect, @NotNull Shape s, boolean onStroke) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Rectangle rect2 = rect;
        Shape s2 = s;
        if (this.clip != null) {
            Rectangle rectangle = this.clip;
            if (rectangle == null) {
                Intrinsics.throwNpe();
            }
            Rectangle rectangle2 = rectangle.intersection(rect2);
            Intrinsics.checkExpressionValueIsNotNull((Object)rectangle2, (String)"clip!!.intersection(rect)");
            rect2 = rectangle2;
        }
        if (rect2.isEmpty()) {
            return false;
        }
        if (onStroke) {
            Shape shape = this.shapeHelper.getStroke().createStrokedShape(s2);
            Intrinsics.checkExpressionValueIsNotNull((Object)shape, (String)"shapeHelper.stroke.createStrokedShape(s)");
            s2 = shape;
        }
        Shape shape = this.getTransform().createTransformedShape(s2);
        Intrinsics.checkExpressionValueIsNotNull((Object)shape, (String)"transform.createTransformedShape(s)");
        s2 = shape;
        return s2.intersects(rect2);
    }

    @Override
    @NotNull
    public GraphicsConfiguration getDeviceConfiguration() {
        GraphicsConfiguration graphicsConfiguration = this.graphicsConfig;
        if (graphicsConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"graphicsConfig");
        }
        return graphicsConfiguration;
    }

    @Override
    @NotNull
    public Composite getComposite() {
        return this.colorHelper.getComposite();
    }

    @Override
    public void setComposite(@NotNull Composite comp) {
        Intrinsics.checkParameterIsNotNull((Object)comp, (String)"comp");
        this.colorHelper.setComposite(comp);
    }

    @Override
    public void setPaint(@NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        this.colorHelper.setPaint(paint);
    }

    @Override
    public void setRenderingHint(@NotNull RenderingHints.Key hintKey, @NotNull Object hintValue) {
        Intrinsics.checkParameterIsNotNull((Object)hintKey, (String)"hintKey");
        Intrinsics.checkParameterIsNotNull((Object)hintValue, (String)"hintValue");
        if (!hintKey.isCompatibleValue(hintValue)) {
            throw (Throwable)new IllegalArgumentException(hintValue + " is not compatible with " + hintKey);
        }
        for (G2DDrawingHelper g2DDrawingHelper : this.helpers) {
            g2DDrawingHelper.setHint(hintKey, hintValue);
        }
    }

    @Override
    @Nullable
    public Object getRenderingHint(@NotNull RenderingHints.Key hintKey) {
        Intrinsics.checkParameterIsNotNull((Object)hintKey, (String)"hintKey");
        return this.hints.get(hintKey);
    }

    @Override
    public void setRenderingHints(@Nullable Map<?, ?> hints) {
        this.resetRenderingHints();
        if (hints != null) {
            this.addRenderingHints(hints);
        }
    }

    private final void resetRenderingHints() {
        this.hints.clear();
        for (G2DDrawingHelper g2DDrawingHelper : this.helpers) {
            g2DDrawingHelper.resetHints();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addRenderingHints(@NotNull Map<?, ?> hints) {
        Intrinsics.checkParameterIsNotNull(hints, (String)"hints");
        Map<Object, Object> map2 = hints;
        boolean bl = false;
        Iterator<Map.Entry<?, ?>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<?, ?> entry;
            Map.Entry<?, ?> entry2 = entry = iterator.next();
            boolean bl2 = false;
            map2 = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Object value = entry2.getValue();
            if (!(key instanceof RenderingHints.Key)) continue;
            RenderingHints.Key key2 = (RenderingHints.Key)key;
            Object obj = value;
            if (obj == null) {
                Intrinsics.throwNpe();
            }
            this.setRenderingHint(key2, obj);
        }
    }

    @Override
    @NotNull
    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    @Override
    public void translate(int x, int y) {
        this.matrixHelper.translate(x, y);
    }

    @Override
    public void translate(double x, double y) {
        this.matrixHelper.translate(x, y);
    }

    @Override
    public void rotate(double theta) {
        this.matrixHelper.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.matrixHelper.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.matrixHelper.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.matrixHelper.shear(shx, shy);
    }

    @Override
    public void transform(@NotNull AffineTransform Tx) {
        Intrinsics.checkParameterIsNotNull((Object)Tx, (String)"Tx");
        this.matrixHelper.transform(Tx);
    }

    @Override
    public void setTransform(@NotNull AffineTransform transform) {
        Intrinsics.checkParameterIsNotNull((Object)transform, (String)"transform");
        this.matrixHelper.setTransform(transform);
    }

    @Override
    @NotNull
    public AffineTransform getTransform() {
        return this.matrixHelper.getTransform();
    }

    @Override
    @NotNull
    public Paint getPaint() {
        return this.colorHelper.getPaint();
    }

    @Override
    @NotNull
    public Color getColor() {
        return this.colorHelper.getColor();
    }

    @Override
    public void setColor(@NotNull Color c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        this.colorHelper.setColor(c);
    }

    @Override
    public void setBackground(@NotNull Color color) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        this.colorHelper.setBackground(color);
    }

    @Override
    @NotNull
    public Color getBackground() {
        return this.colorHelper.getBackground();
    }

    @Override
    @NotNull
    public Stroke getStroke() {
        return this.shapeHelper.getStroke();
    }

    @Override
    public void setStroke(@NotNull Stroke s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this.shapeHelper.setStroke(s);
    }

    @NotNull
    public Void setPaintMode() {
        Void void_ = this.colorHelper.setPaintMode();
        throw null;
    }

    @NotNull
    public Void setXORMode(@NotNull Color c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Void void_ = this.colorHelper.setXORMode(c);
        throw null;
    }

    @Override
    @NotNull
    public Font getFont() {
        return this.stringHelper.getFont();
    }

    @Override
    public void setFont(@NotNull Font font) {
        Intrinsics.checkParameterIsNotNull((Object)font, (String)"font");
        this.stringHelper.setFont(font);
    }

    @Override
    @NotNull
    public FontMetrics getFontMetrics(@NotNull Font f) {
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        return this.stringHelper.getFontMetrics(f);
    }

    @Override
    @NotNull
    public FontRenderContext getFontRenderContext() {
        return this.stringHelper.getFontRenderContext();
    }

    @Override
    @Nullable
    public Rectangle getClipBounds() {
        if (this.clip == null) {
            return null;
        }
        try {
            double[] pts = new double[8];
            Rectangle rectangle = this.clip;
            if (rectangle == null) {
                Intrinsics.throwNpe();
            }
            pts[0] = rectangle.getMinX();
            Rectangle rectangle2 = this.clip;
            if (rectangle2 == null) {
                Intrinsics.throwNpe();
            }
            pts[1] = rectangle2.getMinY();
            Rectangle rectangle3 = this.clip;
            if (rectangle3 == null) {
                Intrinsics.throwNpe();
            }
            pts[2] = rectangle3.getMaxX();
            Rectangle rectangle4 = this.clip;
            if (rectangle4 == null) {
                Intrinsics.throwNpe();
            }
            pts[3] = rectangle4.getMinY();
            Rectangle rectangle5 = this.clip;
            if (rectangle5 == null) {
                Intrinsics.throwNpe();
            }
            pts[4] = rectangle5.getMaxX();
            Rectangle rectangle6 = this.clip;
            if (rectangle6 == null) {
                Intrinsics.throwNpe();
            }
            pts[5] = rectangle6.getMaxY();
            Rectangle rectangle7 = this.clip;
            if (rectangle7 == null) {
                Intrinsics.throwNpe();
            }
            pts[6] = rectangle7.getMinX();
            Rectangle rectangle8 = this.clip;
            if (rectangle8 == null) {
                Intrinsics.throwNpe();
            }
            pts[7] = rectangle8.getMaxY();
            this.getTransform().inverseTransform(pts, 0, pts, 0, 4);
            int minX = (int)Math.min(pts[0], Math.min(pts[2], Math.min(pts[4], pts[6])));
            int maxX = (int)Math.max(pts[0], Math.max(pts[2], Math.max(pts[4], pts[6])));
            int minY = (int)Math.min(pts[1], Math.min(pts[3], Math.min(pts[5], pts[7])));
            int maxY = (int)Math.max(pts[1], Math.max(pts[3], Math.max(pts[5], pts[7])));
            return new Rectangle(minX, minY, maxX - minX, maxY - minY);
        }
        catch (NoninvertibleTransformException e) {
            Logger.getLogger(GLGraphics2D.class.getName()).log(Level.WARNING, "User transform is non-invertible", e);
            Rectangle rectangle = this.clip;
            if (rectangle == null) {
                Intrinsics.throwNpe();
            }
            return rectangle.getBounds();
        }
    }

    @Override
    public void clip(@NotNull Shape s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this.setClip(s.getBounds(), true);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height), true);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height), false);
    }

    @Override
    @Nullable
    public Shape getClip() {
        return this.getClipBounds();
    }

    @Override
    public void setClip(@Nullable Shape clipShape) {
        if (clipShape instanceof Rectangle2D) {
            this.setClip((Rectangle2D)clipShape, false);
        } else if (clipShape == null) {
            this.setClip(null, false);
        } else {
            this.setClip(clipShape.getBounds2D());
        }
    }

    private final void setClip(Rectangle2D clipShape, boolean intersect) {
        if (clipShape == null) {
            this.clip = null;
            this.scissor(false);
        } else if (intersect && this.clip != null) {
            Shape shape = this.getTransform().createTransformedShape(clipShape);
            Intrinsics.checkExpressionValueIsNotNull((Object)shape, (String)"transform.createTransformedShape(clipShape)");
            Rectangle rect = shape.getBounds();
            Rectangle rectangle = this.clip;
            if (rectangle == null) {
                Intrinsics.throwNpe();
            }
            this.clip = rect.intersection(rectangle);
            this.scissor(true);
        } else {
            Shape shape = this.getTransform().createTransformedShape(clipShape);
            Intrinsics.checkExpressionValueIsNotNull((Object)shape, (String)"transform.createTransformedShape(clipShape)");
            this.clip = shape.getBounds();
            this.scissor(true);
        }
    }

    private final void scissor(boolean enable) {
        GLContext gLContext = this.glContext;
        if (gLContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"glContext");
        }
        GL gl = gLContext.getGL();
        if (enable) {
            Rectangle rectangle = this.clip;
            if (rectangle == null) {
                Intrinsics.throwNpe();
            }
            int n = rectangle.x;
            Rectangle rectangle2 = this.clip;
            if (rectangle2 == null) {
                Intrinsics.throwNpe();
            }
            int n2 = this.canvasHeight - rectangle2.y;
            Rectangle rectangle3 = this.clip;
            if (rectangle3 == null) {
                Intrinsics.throwNpe();
            }
            int n3 = n2 - rectangle3.height;
            Rectangle rectangle4 = this.clip;
            if (rectangle4 == null) {
                Intrinsics.throwNpe();
            }
            int n4 = Math.max(rectangle4.width, 0);
            Rectangle rectangle5 = this.clip;
            if (rectangle5 == null) {
                Intrinsics.throwNpe();
            }
            gl.glScissor(n, n3, n4, Math.max(rectangle5.height, 0));
            gl.glEnable(3089);
        } else {
            this.clip = null;
            gl.glDisable(3089);
        }
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.colorHelper.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.shapeHelper.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.shapeHelper.drawRect(x, y, width, height, true);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Color c = this.getColor();
        this.colorHelper.setColorNoRespectComposite(this.getBackground());
        this.fillRect(x, y, width, height);
        this.colorHelper.setColorRespectComposite(c);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.shapeHelper.drawRect(x, y, width, height, false);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.shapeHelper.drawRoundRect(x, y, width, height, arcWidth, arcHeight, false);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.shapeHelper.drawRoundRect(x, y, width, height, arcWidth, arcHeight, true);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.shapeHelper.drawOval(x, y, width, height, false);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.shapeHelper.drawOval(x, y, width, height, true);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.shapeHelper.drawArc(x, y, width, height, startAngle, arcAngle, false);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.shapeHelper.drawArc(x, y, width, height, startAngle, arcAngle, true);
    }

    @Override
    public void drawPolyline(@NotNull int[] xPoints, @NotNull int[] yPoints, int nPoints) {
        Intrinsics.checkParameterIsNotNull((Object)xPoints, (String)"xPoints");
        Intrinsics.checkParameterIsNotNull((Object)yPoints, (String)"yPoints");
        this.shapeHelper.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(@NotNull int[] xPoints, @NotNull int[] yPoints, int nPoints) {
        Intrinsics.checkParameterIsNotNull((Object)xPoints, (String)"xPoints");
        Intrinsics.checkParameterIsNotNull((Object)yPoints, (String)"yPoints");
        this.shapeHelper.drawPolygon(xPoints, yPoints, nPoints, false);
    }

    @Override
    public void fillPolygon(@NotNull int[] xPoints, @NotNull int[] yPoints, int nPoints) {
        Intrinsics.checkParameterIsNotNull((Object)xPoints, (String)"xPoints");
        Intrinsics.checkParameterIsNotNull((Object)yPoints, (String)"yPoints");
        this.shapeHelper.drawPolygon(xPoints, yPoints, nPoints, true);
    }

    @Override
    public boolean drawImage(@NotNull Image img, @NotNull AffineTransform xform, @NotNull ImageObserver obs) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        Intrinsics.checkParameterIsNotNull((Object)xform, (String)"xform");
        Intrinsics.checkParameterIsNotNull((Object)obs, (String)"obs");
        return this.imageHelper.drawImage(img, xform, obs);
    }

    @Override
    public void drawImage(@NotNull BufferedImage img, @NotNull BufferedImageOp op, int x, int y) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        Intrinsics.checkParameterIsNotNull((Object)op, (String)"op");
        this.imageHelper.drawImage(img, op, x, y);
    }

    @Override
    public void drawRenderedImage(@NotNull RenderedImage img, @NotNull AffineTransform xform) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        Intrinsics.checkParameterIsNotNull((Object)xform, (String)"xform");
        this.imageHelper.drawImage(img, xform);
    }

    @Override
    public void drawRenderableImage(@NotNull RenderableImage img, @NotNull AffineTransform xform) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        Intrinsics.checkParameterIsNotNull((Object)xform, (String)"xform");
        this.imageHelper.drawImage(img, xform);
    }

    @Override
    public boolean drawImage(@NotNull Image img, int x, int y, @NotNull ImageObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        Color color = Color.WHITE;
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.WHITE");
        return this.imageHelper.drawImage(img, x, y, color, observer);
    }

    @Override
    public boolean drawImage(@NotNull Image img, int x, int y, @NotNull Color bgcolor, @NotNull ImageObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        Intrinsics.checkParameterIsNotNull((Object)bgcolor, (String)"bgcolor");
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        return this.imageHelper.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(@NotNull Image img, int x, int y, int width, int height, @NotNull ImageObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        Color color = Color.WHITE;
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.WHITE");
        return this.imageHelper.drawImage(img, x, y, width, height, color, observer);
    }

    @Override
    public boolean drawImage(@NotNull Image img, int x, int y, int width, int height, @NotNull Color bgcolor, @NotNull ImageObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        Intrinsics.checkParameterIsNotNull((Object)bgcolor, (String)"bgcolor");
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        return this.imageHelper.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(@NotNull Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, @NotNull ImageObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        Color color = Color.WHITE;
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.WHITE");
        return this.imageHelper.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, color, observer);
    }

    @Override
    public boolean drawImage(@NotNull Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, @NotNull Color bgcolor, @NotNull ImageObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        Intrinsics.checkParameterIsNotNull((Object)bgcolor, (String)"bgcolor");
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        return this.imageHelper.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    @NotNull
    public Graphics create() {
        GLGraphics2D newG2d = this.clone();
        for (G2DDrawingHelper g2DDrawingHelper : this.helpers) {
            g2DDrawingHelper.push(newG2d);
        }
        return newG2d;
    }

    @Override
    public void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            if (this.parent != null) {
                GLGraphics2D gLGraphics2D = this.parent;
                if (gLGraphics2D == null) {
                    Intrinsics.throwNpe();
                }
                GLGraphics2D gLGraphics2D2 = this.parent;
                if (gLGraphics2D2 == null) {
                    Intrinsics.throwNpe();
                }
                gLGraphics2D.scissor(gLGraphics2D2.clip != null);
            }
        }
    }

    @NotNull
    public GLGraphics2D clone() {
        try {
            Object object = super.clone();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.anglur.joglext.jogl2d.GLGraphics2D");
            }
            GLGraphics2D clone = (GLGraphics2D)object;
            clone.parent = this;
            Object object2 = this.hints.clone();
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.awt.RenderingHints");
            }
            clone.hints = (RenderingHints)object2;
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw (Throwable)((Object)new AssertionError((Object)exception));
        }
    }

    public GLGraphics2D() {
        G2DDrawingHelper g2DDrawingHelper = this.addG2DDrawingHelper(new GL2ShapeDrawer());
        if (g2DDrawingHelper == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.anglur.joglext.jogl2d.GLG2DShapeHelper");
        }
        this.shapeHelper = (GLG2DShapeHelper)g2DDrawingHelper;
        G2DDrawingHelper g2DDrawingHelper2 = this.addG2DDrawingHelper(new GL2ImageDrawer());
        if (g2DDrawingHelper2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.anglur.joglext.jogl2d.GLG2DImageHelper");
        }
        this.imageHelper = (GLG2DImageHelper)g2DDrawingHelper2;
        G2DDrawingHelper g2DDrawingHelper3 = this.addG2DDrawingHelper(new GL2StringDrawer());
        if (g2DDrawingHelper3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.anglur.joglext.jogl2d.GLG2DTextHelper");
        }
        this.stringHelper = (GLG2DTextHelper)g2DDrawingHelper3;
        G2DDrawingHelper g2DDrawingHelper4 = this.addG2DDrawingHelper(new GL2Transformhelper());
        if (g2DDrawingHelper4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.anglur.joglext.jogl2d.GLG2DTransformHelper");
        }
        this.matrixHelper = (GLG2DTransformHelper)g2DDrawingHelper4;
        G2DDrawingHelper g2DDrawingHelper5 = this.addG2DDrawingHelper(new GL2ColorHelper());
        if (g2DDrawingHelper5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.anglur.joglext.jogl2d.impl.gl2.GL2ColorHelper");
        }
        this.colorHelper = (GL2ColorHelper)g2DDrawingHelper5;
        this.hints = new RenderingHints(MapsKt.emptyMap());
    }

    static {
        Companion = new Companion(null);
        defaultFont = new Font("Arial", 0, 12);
        defaultStroke = new BasicStroke();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/anglur/joglext/jogl2d/GLGraphics2D$Companion;", "", "()V", "defaultFont", "Ljava/awt/Font;", "defaultStroke", "Ljava/awt/BasicStroke;", "JOGLExt"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

