/*
 * Decompiled with CFR 0.152.
 */
package org.anglur.joglext.jogl2d.impl;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import java.awt.Color;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.VolatileImage;
import java.awt.image.renderable.RenderableImage;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.anglur.joglext.jogl2d.GLG2DImageHelper;
import org.anglur.joglext.jogl2d.GLG2DRenderingHints;
import org.anglur.joglext.jogl2d.GLGraphics2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 B2\u00020\u0001:\u0003BCDB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JP\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH$J\"\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H$J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010&\u001a\u00020\u000eH\u0016J(\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020,H\u0002J \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010+\u001a\u00020,H\u0016J0\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010+\u001a\u00020,H\u0016J@\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010+\u001a\u00020,H\u0016J`\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010+\u001a\u00020,H\u0016J(\u0010'\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020$2\u0006\u00101\u001a\u0002022\u0006\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u0015H\u0016J\u0018\u0010'\u001a\u00020\u000e2\u0006\u0010)\u001a\u0002032\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010'\u001a\u00020\u000e2\u0006\u0010)\u001a\u0002042\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u00105\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H$J\u001a\u00106\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u00107\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\u0006H\u0016J\u0010\u00109\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\u0006H\u0016J\b\u0010;\u001a\u00020\u000eH\u0016J\u0010\u0010<\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010=\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010\u0004H\u0016J\u0012\u0010A\u001a\u0004\u0018\u00010$2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/anglur/joglext/jogl2d/impl/AbstractImageHelper;", "Lorg/anglur/joglext/jogl2d/GLG2DImageHelper;", "()V", "clearCachePolicy", "", "g2d", "Lorg/anglur/joglext/jogl2d/GLGraphics2D;", "getG2d", "()Lorg/anglur/joglext/jogl2d/GLGraphics2D;", "setG2d", "(Lorg/anglur/joglext/jogl2d/GLGraphics2D;)V", "imageCache", "Lorg/anglur/joglext/jogl2d/impl/AbstractImageHelper$TextureCache;", "addToCache", "", "image", "Ljava/awt/Image;", "texture", "Lcom/jogamp/opengl/util/texture/Texture;", "applyTexture", "dx1", "", "dy1", "dx2", "dy2", "sx1", "", "sy1", "sx2", "sy2", "begin", "xform", "Ljava/awt/geom/AffineTransform;", "bgcolor", "Ljava/awt/Color;", "create", "Ljava/awt/image/BufferedImage;", "destroy", "dispose", "drawImage", "", "img", "color", "observer", "Ljava/awt/image/ImageObserver;", "x", "y", "width", "height", "op", "Ljava/awt/image/BufferedImageOp;", "Ljava/awt/image/RenderedImage;", "Ljava/awt/image/renderable/RenderableImage;", "end", "getTexture", "pop", "parentG2d", "push", "newG2d", "resetHints", "setG2D", "setHint", "key", "Ljava/awt/RenderingHints$Key;", "value", "toBufferedImage", "Companion", "TextureCache", "WeakKey", "JOGLExt"})
public abstract class AbstractImageHelper
implements GLG2DImageHelper {
    private TextureCache imageCache = new TextureCache();
    private Object clearCachePolicy;
    @NotNull
    protected GLGraphics2D g2d;
    private static final Logger LOGGER;
    public static final Companion Companion;

    @NotNull
    protected final GLGraphics2D getG2d() {
        GLGraphics2D gLGraphics2D = this.g2d;
        if (gLGraphics2D == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"g2d");
        }
        return gLGraphics2D;
    }

    protected final void setG2d(@NotNull GLGraphics2D gLGraphics2D) {
        Intrinsics.checkParameterIsNotNull((Object)gLGraphics2D, (String)"<set-?>");
        this.g2d = gLGraphics2D;
    }

    protected abstract void begin(@NotNull Texture var1, @Nullable AffineTransform var2, @NotNull Color var3);

    protected abstract void applyTexture(@NotNull Texture var1, int var2, int var3, int var4, int var5, float var6, float var7, float var8, float var9);

    protected abstract void end(@NotNull Texture var1);

    @Override
    public void setG2D(@NotNull GLGraphics2D g2d) {
        Intrinsics.checkParameterIsNotNull((Object)g2d, (String)"g2d");
        this.g2d = g2d;
        if (this.clearCachePolicy == GLG2DRenderingHints.INSTANCE.getVALUE_CLEAR_TEXTURES_CACHE_EACH_PAINT()) {
            this.imageCache.clear();
        }
    }

    @Override
    public void push(@NotNull GLGraphics2D newG2d) {
        Intrinsics.checkParameterIsNotNull((Object)newG2d, (String)"newG2d");
    }

    @Override
    public void pop(@NotNull GLGraphics2D parentG2d) {
        Intrinsics.checkParameterIsNotNull((Object)parentG2d, (String)"parentG2d");
    }

    @Override
    public void setHint(@NotNull RenderingHints.Key key, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (key == GLG2DRenderingHints.INSTANCE.getKEY_CLEAR_TEXTURES_CACHE()) {
            this.clearCachePolicy = value;
        }
    }

    @Override
    public void resetHints() {
        this.clearCachePolicy = GLG2DRenderingHints.INSTANCE.getVALUE_CLEAR_TEXTURES_CACHE_DEFAULT();
    }

    @Override
    public void dispose() {
        this.imageCache.clear();
    }

    @Override
    public boolean drawImage(@NotNull Image img, int x, int y, @NotNull Color bgcolor, @NotNull ImageObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        Intrinsics.checkParameterIsNotNull((Object)bgcolor, (String)"bgcolor");
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(x, y);
        Intrinsics.checkExpressionValueIsNotNull((Object)affineTransform, (String)"AffineTransform.getTrans\u2026toDouble(), y.toDouble())");
        return this.drawImage(img, affineTransform, bgcolor, observer);
    }

    @Override
    public boolean drawImage(@NotNull Image img, @NotNull AffineTransform xform, @NotNull ImageObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        Intrinsics.checkParameterIsNotNull((Object)xform, (String)"xform");
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        Color color = Color.WHITE;
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.WHITE");
        return this.drawImage(img, xform, color, observer);
    }

    @Override
    public boolean drawImage(@NotNull Image img, int x, int y, int width, int height, @NotNull Color bgcolor, @NotNull ImageObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        Intrinsics.checkParameterIsNotNull((Object)bgcolor, (String)"bgcolor");
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        double imgHeight = img.getHeight(null);
        double imgWidth = img.getWidth(null);
        if (imgHeight < 0.0 || imgWidth < 0.0) {
            return false;
        }
        AffineTransform transform = AffineTransform.getTranslateInstance(x, y);
        transform.scale((double)width / imgWidth, (double)height / imgHeight);
        AffineTransform affineTransform = transform;
        Intrinsics.checkExpressionValueIsNotNull((Object)affineTransform, (String)"transform");
        return this.drawImage(img, affineTransform, bgcolor, observer);
    }

    @Override
    public boolean drawImage(@NotNull Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, @NotNull Color bgcolor, @NotNull ImageObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        Intrinsics.checkParameterIsNotNull((Object)bgcolor, (String)"bgcolor");
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        Texture texture = this.getTexture(img, observer);
        if (texture == null) {
            return false;
        }
        Texture texture2 = texture;
        float height = texture2.getHeight();
        float width = texture2.getWidth();
        this.begin(texture2, null, bgcolor);
        this.applyTexture(texture2, dx1, dy1, dx2, dy2, (float)sx1 / width, (float)sy1 / height, (float)sx2 / width, (float)sy2 / height);
        this.end(texture2);
        return true;
    }

    private final boolean drawImage(Image img, AffineTransform xform, Color color, ImageObserver observer) {
        Texture texture = this.getTexture(img, observer);
        if (texture == null) {
            return false;
        }
        Texture texture2 = texture;
        this.begin(texture2, xform, color);
        this.applyTexture(texture2);
        this.end(texture2);
        return true;
    }

    private final void applyTexture(Texture texture) {
        int width = texture.getWidth();
        int height = texture.getHeight();
        TextureCoords coords = texture.getImageTexCoords();
        this.applyTexture(texture, 0, 0, width, height, coords.left(), coords.top(), coords.right(), coords.bottom());
    }

    private final Texture getTexture(Image image, ImageObserver observer) {
        Texture texture = this.imageCache.get(image);
        if (texture == null) {
            BufferedImage bufferedImage = null;
            bufferedImage = image instanceof BufferedImage && ((BufferedImage)image).getType() != 0 ? (BufferedImage)image : this.toBufferedImage(image);
            if (bufferedImage != null) {
                texture = this.create(bufferedImage);
                this.addToCache(image, texture);
            }
        }
        return texture;
    }

    private final Texture create(BufferedImage image) {
        GLGraphics2D gLGraphics2D = this.g2d;
        if (gLGraphics2D == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"g2d");
        }
        GL gL = gLGraphics2D.getGlContext().getGL();
        Intrinsics.checkExpressionValueIsNotNull((Object)gL, (String)"g2d.glContext.gl");
        Texture texture = AWTTextureIO.newTexture((GLProfile)gL.getGLProfile(), (BufferedImage)image, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)texture, (String)"AWTTextureIO.newTexture(\u2026.glProfile, image, false)");
        return texture;
    }

    private final void destroy(Texture texture) {
        GLGraphics2D gLGraphics2D = this.g2d;
        if (gLGraphics2D == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"g2d");
        }
        texture.destroy(gLGraphics2D.getGlContext().getGL());
    }

    private final void addToCache(Image image, Texture texture) {
        if (this.clearCachePolicy instanceof Number) {
            Object object = this.clearCachePolicy;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
            }
            int maxSize = ((Number)object).intValue();
            if (this.imageCache.size() > maxSize) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Clearing texture cache with size " + this.imageCache.size());
                }
                this.imageCache.clear();
            }
        }
        this.imageCache.put(image, texture);
    }

    private final BufferedImage toBufferedImage(Image image) {
        if (image instanceof VolatileImage) {
            return ((VolatileImage)image).getSnapshot();
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (width < 0 || height < 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 6);
        bufferedImage.createGraphics().drawImage(image, null, null);
        return bufferedImage;
    }

    @Override
    public void drawImage(@NotNull BufferedImage img, @NotNull BufferedImageOp op, int x, int y) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        Intrinsics.checkParameterIsNotNull((Object)op, (String)"op");
        String string = "drawImage(BufferedImage, BufferedImageOp, int, int)";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void drawImage(@NotNull RenderedImage img, @NotNull AffineTransform xform) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        Intrinsics.checkParameterIsNotNull((Object)xform, (String)"xform");
        String string = "drawImage(RenderedImage, AffineTransform)";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void drawImage(@NotNull RenderableImage img, @NotNull AffineTransform xform) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        Intrinsics.checkParameterIsNotNull((Object)xform, (String)"xform");
        String string = "drawImage(RenderableImage, AffineTransform)";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    static {
        Companion = new Companion(null);
        LOGGER = Logger.getLogger(AbstractImageHelper.class.getName());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0013\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u0003H\u0086\u0002J\u0018\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0004R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/anglur/joglext/jogl2d/impl/AbstractImageHelper$TextureCache;", "Ljava/util/HashMap;", "Lorg/anglur/joglext/jogl2d/impl/AbstractImageHelper$WeakKey;", "Ljava/awt/Image;", "Lcom/jogamp/opengl/util/texture/Texture;", "(Lorg/anglur/joglext/jogl2d/impl/AbstractImageHelper;)V", "queue", "Ljava/lang/ref/ReferenceQueue;", "expungeStaleEntries", "", "get", "image", "put", "texture", "JOGLExt"})
    private final class TextureCache
    extends HashMap<WeakKey<Image>, Texture> {
        private final ReferenceQueue<Image> queue = new ReferenceQueue();

        public final void expungeStaleEntries() {
            Reference<Image> ref = this.queue.poll();
            while (ref != null) {
                TextureCache textureCache = this;
                boolean bl = false;
                TextureCache textureCache2 = textureCache;
                if (textureCache2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
                }
                Texture texture = (Texture)TypeIntrinsics.asMutableMap((Object)textureCache2).remove(ref);
                if (texture != null) {
                    AbstractImageHelper.this.destroy(texture);
                }
                ref = this.queue.poll();
            }
        }

        @Nullable
        public final Texture get(@NotNull Image image) {
            Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
            this.expungeStaleEntries();
            WeakKey<Image> key = new WeakKey<Image>(image, (ReferenceQueue<Image>)null);
            return (Texture)this.get((Object)key);
        }

        @Override
        @Nullable
        public final Texture put(@NotNull Image image, @NotNull Texture texture) {
            Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
            Intrinsics.checkParameterIsNotNull((Object)texture, (String)"texture");
            this.expungeStaleEntries();
            WeakKey<Image> key = new WeakKey<Image>(image, this.queue);
            return this.put(key, texture);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/anglur/joglext/jogl2d/impl/AbstractImageHelper$WeakKey;", "T", "Ljava/lang/ref/WeakReference;", "value", "queue", "Ljava/lang/ref/ReferenceQueue;", "(Ljava/lang/Object;Ljava/lang/ref/ReferenceQueue;)V", "hash", "", "equals", "", "other", "", "hashCode", "JOGLExt"})
    private static final class WeakKey<T>
    extends WeakReference<T> {
        private final int hash;

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof WeakKey) {
                return ((WeakKey)other).hash == this.hash && this.get() == ((WeakKey)other).get();
            }
            return false;
        }

        public WeakKey(T value, @Nullable ReferenceQueue<T> queue) {
            super(value, queue);
            T t = value;
            if (t == null) {
                Intrinsics.throwNpe();
            }
            this.hash = t.hashCode();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/anglur/joglext/jogl2d/impl/AbstractImageHelper$Companion;", "", "()V", "LOGGER", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "JOGLExt"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

