/*
 * Decompiled with CFR 0.152.
 */
package org.anglur.joglext.jogl2d.impl;

import java.awt.BasicStroke;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayDeque;
import java.util.Deque;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.anglur.joglext.cacheable.CachedFloatArray;
import org.anglur.joglext.jogl2d.GLG2DShapeHelper;
import org.anglur.joglext.jogl2d.GLGraphics2D;
import org.anglur.joglext.jogl2d.PathVisitor;
import org.anglur.joglext.jogl2d.shape.ShapeIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 >2\u00020\u0001:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J@\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0016J0\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J0\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0018H\u0002J(\u0010%\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010&\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u0011H\u0016J0\u0010'\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J@\u0010(\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0018H$J\u0010\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u000200H\u0016J\b\u00103\u001a\u00020\u000eH\u0016J\u0010\u00104\u001a\u00020\u000e2\u0006\u00105\u001a\u000200H\u0016J\u001a\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010:H\u0016J\u0018\u0010;\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,2\u0006\u0010<\u001a\u00020=H\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/anglur/joglext/jogl2d/impl/AbstractShapeHelper;", "Lorg/anglur/joglext/jogl2d/GLG2DShapeHelper;", "()V", "EMPTY", "Ljava/awt/BasicStroke;", "stroke", "Ljava/awt/Stroke;", "getStroke", "()Ljava/awt/Stroke;", "setStroke", "(Ljava/awt/Stroke;)V", "strokeStack", "Ljava/util/Deque;", "dispose", "", "drawArc", "x", "", "y", "width", "height", "startAngle", "arcAngle", "fill", "", "drawLine", "x1", "y1", "x2", "y2", "drawOval", "drawPoly", "xPoints", "", "yPoints", "nPoints", "close", "drawPolygon", "drawPolyline", "drawRect", "drawRoundRect", "arcWidth", "arcHeight", "shape", "Ljava/awt/Shape;", "isDefinitelySimpleConvex", "pop", "parentG2d", "Lorg/anglur/joglext/jogl2d/GLGraphics2D;", "push", "newG2d", "resetHints", "setG2D", "g2d", "setHint", "key", "Ljava/awt/RenderingHints$Key;", "value", "", "traceShape", "visitor", "Lorg/anglur/joglext/jogl2d/PathVisitor;", "Companion", "JOGLExt"})
public abstract class AbstractShapeHelper
implements GLG2DShapeHelper {
    private Deque<Stroke> strokeStack = new ArrayDeque();
    private final BasicStroke EMPTY;
    private static final Ellipse2D.Float ELLIPSE;
    private static final RoundRectangle2D.Float ROUND_RECT;
    private static final Arc2D.Float ARC;
    private static final Rectangle2D.Float RECT;
    private static final Line2D.Float LINE;
    public static final Companion Companion;

    @Override
    public void setG2D(@NotNull GLGraphics2D g2d) {
        Intrinsics.checkParameterIsNotNull((Object)g2d, (String)"g2d");
        this.strokeStack.clear();
        this.strokeStack.push(this.EMPTY);
    }

    @Override
    public void push(@NotNull GLGraphics2D newG2d) {
        Intrinsics.checkParameterIsNotNull((Object)newG2d, (String)"newG2d");
        this.strokeStack.push(newG2d.getStroke());
    }

    @Override
    public void pop(@NotNull GLGraphics2D parentG2d) {
        Intrinsics.checkParameterIsNotNull((Object)parentG2d, (String)"parentG2d");
        this.strokeStack.pop();
    }

    @Override
    public void setHint(@NotNull RenderingHints.Key key, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
    }

    @Override
    public void resetHints() {
        RenderingHints.Key key = RenderingHints.KEY_ANTIALIASING;
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"RenderingHints.KEY_ANTIALIASING");
        this.setHint(key, null);
    }

    @Override
    public void dispose() {
    }

    @Override
    @NotNull
    public Stroke getStroke() {
        Stroke stroke = this.strokeStack.peek();
        Intrinsics.checkExpressionValueIsNotNull((Object)stroke, (String)"strokeStack.peek()");
        return stroke;
    }

    @Override
    public void setStroke(@NotNull Stroke stroke) {
        Intrinsics.checkParameterIsNotNull((Object)stroke, (String)"stroke");
        this.strokeStack.pop();
        this.strokeStack.push(stroke);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight, boolean fill) {
        ROUND_RECT.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        if (fill) {
            this.fill(ROUND_RECT, true);
        } else {
            this.draw(ROUND_RECT);
        }
    }

    @Override
    public void drawRect(int x, int y, int width, int height, boolean fill) {
        RECT.setRect(x, y, width, height);
        if (fill) {
            this.fill(RECT, true);
        } else {
            this.draw(RECT);
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        LINE.setLine(x1, y1, x2, y2);
        this.draw(LINE);
    }

    @Override
    public void drawOval(int x, int y, int width, int height, boolean fill) {
        ELLIPSE.setFrame(x, y, width, height);
        if (fill) {
            this.fill(ELLIPSE, true);
        } else {
            this.draw(ELLIPSE);
        }
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle, boolean fill) {
        ARC.setArc(x, y, width, height, startAngle, arcAngle, fill ? 2 : 0);
        if (fill) {
            this.fill(ARC, true);
        } else {
            this.draw(ARC);
        }
    }

    @Override
    public void drawPolyline(@NotNull int[] xPoints, @NotNull int[] yPoints, int nPoints) {
        Intrinsics.checkParameterIsNotNull((Object)xPoints, (String)"xPoints");
        Intrinsics.checkParameterIsNotNull((Object)yPoints, (String)"yPoints");
        this.drawPoly(xPoints, yPoints, nPoints, false, false);
    }

    @Override
    public void drawPolygon(@NotNull int[] xPoints, @NotNull int[] yPoints, int nPoints, boolean fill) {
        Intrinsics.checkParameterIsNotNull((Object)xPoints, (String)"xPoints");
        Intrinsics.checkParameterIsNotNull((Object)yPoints, (String)"yPoints");
        this.drawPoly(xPoints, yPoints, nPoints, fill, true);
    }

    /*
     * WARNING - void declaration
     */
    private final void drawPoly(int[] xPoints, int[] yPoints, int nPoints, boolean fill, boolean close) {
        Path2D.Float path = new Path2D.Float(1, nPoints);
        path.moveTo(xPoints[0], yPoints[0]);
        int n = 1;
        int n2 = nPoints - 1;
        if (n <= n2) {
            while (true) {
                void i;
                path.lineTo(xPoints[i], yPoints[i]);
                if (i == n2) break;
                ++i;
            }
        }
        if (close) {
            path.closePath();
        }
        if (fill) {
            this.fill(path);
        } else {
            this.draw(path);
        }
    }

    @Override
    public void fill(@NotNull Shape shape) {
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        if (shape instanceof Rectangle2D || shape instanceof Ellipse2D || shape instanceof Arc2D || shape instanceof RoundRectangle2D) {
            this.fill(shape, true);
        } else {
            this.fill(shape, false);
        }
    }

    protected abstract void fill(@NotNull Shape var1, boolean var2);

    protected final void traceShape(@NotNull Shape shape, @NotNull PathVisitor visitor) {
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Companion.visitShape(shape, visitor);
    }

    public AbstractShapeHelper() {
        this.strokeStack.push(new BasicStroke());
        this.EMPTY = new BasicStroke();
    }

    static {
        Companion = new Companion(null);
        ELLIPSE = new Ellipse2D.Float();
        ROUND_RECT = new RoundRectangle2D.Float();
        ARC = new Arc2D.Float();
        RECT = new Rectangle2D.Float();
        LINE = new Line2D.Float();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/anglur/joglext/jogl2d/impl/AbstractShapeHelper$Companion;", "", "()V", "ARC", "Ljava/awt/geom/Arc2D$Float;", "ELLIPSE", "Ljava/awt/geom/Ellipse2D$Float;", "LINE", "Ljava/awt/geom/Line2D$Float;", "RECT", "Ljava/awt/geom/Rectangle2D$Float;", "ROUND_RECT", "Ljava/awt/geom/RoundRectangle2D$Float;", "visitShape", "", "shape", "Ljava/awt/Shape;", "visitor", "Lorg/anglur/joglext/jogl2d/PathVisitor;", "JOGLExt"})
    public static final class Companion {
        public final void visitShape(@NotNull Shape shape, @NotNull PathVisitor visitor) {
            Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
            Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
            PathIterator iterator = ShapeIterator.INSTANCE.get(shape);
            visitor.beginPoly(iterator.getWindingRule());
            float[] coords = CachedFloatArray.INSTANCE.invoke(10);
            float[] previousVertex = CachedFloatArray.INSTANCE.invoke(2);
            while (!iterator.isDone()) {
                int type = iterator.currentSegment(coords);
                switch (type) {
                    case 0: {
                        visitor.moveTo(coords);
                        break;
                    }
                    case 1: {
                        visitor.lineTo(coords);
                        break;
                    }
                    case 2: {
                        visitor.quadTo(previousVertex, coords);
                        break;
                    }
                    case 3: {
                        visitor.cubicTo(previousVertex, coords);
                        break;
                    }
                    case 4: {
                        visitor.closeLine();
                    }
                }
                switch (type) {
                    case 0: 
                    case 1: {
                        previousVertex[0] = coords[0];
                        previousVertex[1] = coords[1];
                        break;
                    }
                    case 2: {
                        previousVertex[0] = coords[2];
                        previousVertex[1] = coords[3];
                        break;
                    }
                    case 3: {
                        previousVertex[0] = coords[4];
                        previousVertex[1] = coords[5];
                    }
                }
                iterator.next();
            }
            visitor.endPoly();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

