/*
 * Decompiled with CFR 0.152.
 */
package org.anglur.joglext.jogl2d.impl;

import com.jogamp.common.nio.Buffers;
import java.awt.BasicStroke;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.anglur.joglext.cacheable.CachedFloatArray;
import org.anglur.joglext.jogl2d.VertexBuffer;
import org.anglur.joglext.jogl2d.impl.SimplePathVisitor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b \n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 K2\u00020\u0001:\u0001KB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J \u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\nH\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0006H\u0002J \u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u0004H\u0016J\b\u0010+\u001a\u00020\u001fH\u0002J\b\u0010,\u001a\u00020\u001fH\u0016J\u0018\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0006H\u0016J\u0018\u00100\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\b\u00101\u001a\u00020\u001fH$J \u00102\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0002J \u00103\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0002J \u00104\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0002J \u00105\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u0006H\u0002J \u00107\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u0006H\u0002J \u00108\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u0006H\u0002J\b\u00109\u001a\u00020\u001fH\u0016J\b\u0010:\u001a\u00020\u001fH\u0002J(\u0010;\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010<\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u0006H\u0002J \u0010>\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u0006H\u0002J(\u0010?\u001a\u00020\u00062\u0006\u0010@\u001a\u00020\u00062\u0006\u0010A\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00062\u0006\u0010B\u001a\u00020\nH\u0002J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010@\u001a\u00020\u00062\u0006\u0010A\u001a\u00020\u0006H\u0002J\u0010\u0010C\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0006H\u0016J\u0010\u0010D\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0006H\u0016J\u0010\u0010E\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0018\u0010F\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0006H\u0016J\u0010\u0010G\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020IH\u0016J\u0018\u0010J\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006L"}, d2={"Lorg/anglur/joglext/jogl2d/impl/BasicStrokeLineVisitor;", "Lorg/anglur/joglext/jogl2d/impl/SimplePathVisitor;", "()V", "endCap", "", "firstPoint", "", "lastPoint", "lineJoin", "lineOffset", "", "miterLimit", "secondLastPoint", "secondPoint", "tmpBuffer", "Ljava/nio/FloatBuffer;", "kotlin.jvm.PlatformType", "vBuffer", "Lorg/anglur/joglext/jogl2d/VertexBuffer;", "getVBuffer", "()Lorg/anglur/joglext/jogl2d/VertexBuffer;", "setVBuffer", "(Lorg/anglur/joglext/jogl2d/VertexBuffer;)V", "add", "pt1", "pt2", "addScaled", "pt", "v", "alpha", "addVertex", "", "x", "y", "applyCorner", "vertex", "applyEndCap", "point1", "point2", "first", "", "beginPoly", "windingRule", "clear", "closeLine", "cubicTo", "previousVertex", "control", "distance", "drawBuffer", "drawCapButt", "drawCapRound", "drawCapSquare", "drawCornerBevel", "point", "drawCornerMiter", "drawCornerRound", "endPoly", "finishAndDrawLine", "getIntersectionAlpha", "v1", "v2", "getMiterIntersections", "lineCorners", "linePoint1", "linePoint2", "offset", "lineTo", "moveTo", "normalize", "quadTo", "setStroke", "stroke", "Ljava/awt/BasicStroke;", "subtract", "Companion", "JOGLExt"})
public abstract class BasicStrokeLineVisitor
extends SimplePathVisitor {
    private int lineJoin;
    private int endCap;
    private float lineOffset;
    private float miterLimit;
    private float[] lastPoint;
    private float[] secondLastPoint;
    private float[] firstPoint;
    private float[] secondPoint;
    @NotNull
    private VertexBuffer vBuffer = new VertexBuffer(1024);
    private FloatBuffer tmpBuffer = Buffers.newDirectFloatBuffer((int)1024);
    private static float THETA_STEP;
    private static float COS_STEP;
    private static float SIN_STEP;
    public static final Companion Companion;

    @NotNull
    protected final VertexBuffer getVBuffer() {
        return this.vBuffer;
    }

    protected final void setVBuffer(@NotNull VertexBuffer vertexBuffer) {
        Intrinsics.checkParameterIsNotNull((Object)vertexBuffer, (String)"<set-?>");
        this.vBuffer = vertexBuffer;
    }

    @Override
    public void setStroke(@NotNull BasicStroke stroke) {
        Intrinsics.checkParameterIsNotNull((Object)stroke, (String)"stroke");
        this.lineJoin = stroke.getLineJoin();
        this.lineOffset = stroke.getLineWidth() / (float)2;
        this.endCap = stroke.getEndCap();
        this.miterLimit = stroke.getMiterLimit();
        if (stroke.getDashArray() != null) {
            String string = "BasicStroke with dash array";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
    }

    @Override
    public void beginPoly(int windingRule) {
        this.clear();
    }

    @Override
    public void endPoly() {
        this.finishAndDrawLine();
    }

    @Override
    public void moveTo(@NotNull float[] vertex) {
        Intrinsics.checkParameterIsNotNull((Object)vertex, (String)"vertex");
        this.finishAndDrawLine();
        this.lastPoint = new float[]{vertex[0], vertex[1]};
        this.firstPoint = this.lastPoint;
    }

    @Override
    public void lineTo(@NotNull float[] vertex) {
        Intrinsics.checkParameterIsNotNull((Object)vertex, (String)"vertex");
        if (this.lastPoint == null) {
            Intrinsics.throwNpe();
        }
        if (this.lastPoint[0] == vertex[0]) {
            if (this.lastPoint == null) {
                Intrinsics.throwNpe();
            }
            if (this.lastPoint[1] == vertex[1]) {
                return;
            }
        }
        float[] vClone = new float[]{vertex[0], vertex[1]};
        if (this.secondPoint == null) {
            this.secondPoint = vClone;
        }
        if (this.secondLastPoint != null) {
            this.applyCorner(vertex);
        }
        this.secondLastPoint = this.lastPoint;
        this.lastPoint = vClone;
    }

    @Override
    public void closeLine() {
        if (this.firstPoint != null && this.secondPoint != null) {
            if (this.firstPoint == null) {
                Intrinsics.throwNpe();
            }
            this.lineTo(this.firstPoint);
            if (this.secondPoint == null) {
                Intrinsics.throwNpe();
            }
            this.lineTo(this.secondPoint);
            FloatBuffer buf = this.vBuffer.getBuffer();
            this.addVertex(buf.get(0), buf.get(1));
            this.addVertex(buf.get(2), buf.get(3));
            this.drawBuffer();
        }
        this.clear();
    }

    private final void clear() {
        this.vBuffer.clear();
        this.firstPoint = null;
        this.lastPoint = null;
        this.secondPoint = null;
        this.secondLastPoint = null;
    }

    private final void finishAndDrawLine() {
        if (this.firstPoint != null && this.secondPoint != null) {
            if (this.secondLastPoint == null) {
                Intrinsics.throwNpe();
            }
            if (this.lastPoint == null) {
                Intrinsics.throwNpe();
            }
            this.applyEndCap(this.secondLastPoint, this.lastPoint, false);
            FloatBuffer buf = this.vBuffer.getBuffer();
            if (this.tmpBuffer.capacity() < buf.position()) {
                this.tmpBuffer = Buffers.newDirectFloatBuffer((int)buf.position());
            }
            this.tmpBuffer.clear();
            buf.flip();
            this.tmpBuffer.put(buf);
            this.tmpBuffer.flip();
            buf.clear();
            if (this.firstPoint == null) {
                Intrinsics.throwNpe();
            }
            if (this.secondPoint == null) {
                Intrinsics.throwNpe();
            }
            this.applyEndCap(this.firstPoint, this.secondPoint, true);
            buf.put(this.tmpBuffer);
            this.drawBuffer();
        }
        this.clear();
    }

    @Override
    public void quadTo(@NotNull float[] previousVertex, @NotNull float[] control) {
        Intrinsics.checkParameterIsNotNull((Object)previousVertex, (String)"previousVertex");
        Intrinsics.checkParameterIsNotNull((Object)control, (String)"control");
        int originalJoin = this.lineJoin;
        this.lineJoin = 2;
        super.quadTo(previousVertex, control);
        this.lineJoin = originalJoin;
    }

    @Override
    public void cubicTo(@NotNull float[] previousVertex, @NotNull float[] control) {
        Intrinsics.checkParameterIsNotNull((Object)previousVertex, (String)"previousVertex");
        Intrinsics.checkParameterIsNotNull((Object)control, (String)"control");
        int originalJoin = this.lineJoin;
        this.lineJoin = 2;
        super.cubicTo(previousVertex, control);
        this.lineJoin = originalJoin;
    }

    private final void applyCorner(float[] vertex) {
        switch (this.lineJoin) {
            case 2: {
                if (this.secondLastPoint == null) {
                    Intrinsics.throwNpe();
                }
                if (this.lastPoint == null) {
                    Intrinsics.throwNpe();
                }
                this.drawCornerBevel(this.secondLastPoint, this.lastPoint, vertex);
                break;
            }
            case 1: {
                if (this.secondLastPoint == null) {
                    Intrinsics.throwNpe();
                }
                if (this.lastPoint == null) {
                    Intrinsics.throwNpe();
                }
                this.drawCornerRound(this.secondLastPoint, this.lastPoint, vertex);
                break;
            }
            case 0: {
                if (this.secondLastPoint == null) {
                    Intrinsics.throwNpe();
                }
                if (this.lastPoint == null) {
                    Intrinsics.throwNpe();
                }
                this.drawCornerMiter(this.secondLastPoint, this.lastPoint, vertex);
                break;
            }
            default: {
                String string = "BasicStroke with unknown line join: " + this.lineJoin;
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawCornerRound(float[] secondLastPoint, float[] lastPoint, float[] point) {
        float[] offset1 = this.lineOffset(secondLastPoint, lastPoint);
        float[] offset2 = this.lineOffset(lastPoint, point);
        float[] v1 = this.subtract(lastPoint, secondLastPoint);
        this.normalize(v1);
        float[] v2 = this.subtract(lastPoint, point);
        this.normalize(v2);
        float[] rightPt1 = this.add(lastPoint, offset1);
        float[] rightPt2 = this.add(lastPoint, offset2);
        float[] leftPt1 = this.subtract(lastPoint, offset1);
        float[] leftPt2 = this.subtract(lastPoint, offset2);
        float alpha = this.getIntersectionAlpha(rightPt1, v1, rightPt2, v2);
        float theta = (float)(Math.PI - Math.acos(v1[0] * v2[0] + v1[1] * v2[1]));
        if (alpha <= 0.0f) {
            float[] rightInside = this.addScaled(rightPt1, v1, alpha);
            this.addVertex(rightInside[0], rightInside[1]);
            this.addVertex(leftPt1[0], leftPt1[1]);
            int max = (int)Math.ceil(theta / THETA_STEP);
            int n = 0;
            int n2 = max - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    float newX = COS_STEP * offset1[0] + SIN_STEP * offset1[1];
                    offset1[1] = -SIN_STEP * offset1[0] + COS_STEP * offset1[1];
                    offset1[0] = newX;
                    this.addVertex(rightInside[0], rightInside[1]);
                    this.addVertex(lastPoint[0] - offset1[0], lastPoint[1] - offset1[1]);
                    if (i == n2) break;
                    ++i;
                }
            }
            this.addVertex(rightInside[0], rightInside[1]);
            this.addVertex(leftPt2[0], leftPt2[1]);
        } else {
            alpha = -alpha;
            float[] leftInside = this.addScaled(leftPt1, v1, alpha);
            this.addVertex(rightPt1[0], rightPt1[1]);
            this.addVertex(leftInside[0], leftInside[1]);
            int max = (int)Math.ceil(theta / THETA_STEP);
            int i = 0;
            int n = max - 1;
            if (i <= n) {
                while (true) {
                    float newX = COS_STEP * offset1[0] - SIN_STEP * offset1[1];
                    offset1[1] = SIN_STEP * offset1[0] + COS_STEP * offset1[1];
                    offset1[0] = newX;
                    this.addVertex(lastPoint[0] + offset1[0], lastPoint[1] + offset1[1]);
                    this.addVertex(leftInside[0], leftInside[1]);
                    if (i == n) break;
                    ++i;
                }
            }
            this.addVertex(rightPt2[0], rightPt2[1]);
            this.addVertex(leftInside[0], leftInside[1]);
        }
    }

    private final void drawCornerBevel(float[] secondLastPoint, float[] lastPoint, float[] point) {
        float[] offset1 = this.lineOffset(secondLastPoint, lastPoint);
        float[] offset2 = this.lineOffset(lastPoint, point);
        float[] v1 = this.subtract(lastPoint, secondLastPoint);
        this.normalize(v1);
        float[] v2 = this.subtract(lastPoint, point);
        this.normalize(v2);
        float[] rightPt1 = this.add(lastPoint, offset1);
        float[] rightPt2 = this.add(lastPoint, offset2);
        float[] leftPt1 = this.subtract(lastPoint, offset1);
        float[] leftPt2 = this.subtract(lastPoint, offset2);
        float alpha = this.getIntersectionAlpha(rightPt1, v1, rightPt2, v2);
        if (alpha <= 0.0f) {
            float[] rightInside = this.addScaled(rightPt1, v1, alpha);
            this.addVertex(rightInside[0], rightInside[1]);
            this.addVertex(leftPt1[0], leftPt1[1]);
            this.addVertex(rightInside[0], rightInside[1]);
            this.addVertex(leftPt2[0], leftPt2[1]);
        } else {
            alpha = -alpha;
            float[] leftInside = this.addScaled(leftPt1, v1, alpha);
            this.addVertex(rightPt1[0], rightPt1[1]);
            this.addVertex(leftInside[0], leftInside[1]);
            this.addVertex(rightPt2[0], rightPt2[1]);
            this.addVertex(leftInside[0], leftInside[1]);
        }
    }

    private final void drawCornerMiter(float[] secondLastPoint, float[] lastPoint, float[] point) {
        float[] offset1 = this.lineOffset(secondLastPoint, lastPoint);
        float[] offset2 = this.lineOffset(lastPoint, point);
        float[] v1 = this.subtract(lastPoint, secondLastPoint);
        this.normalize(v1);
        float[] v2 = this.subtract(lastPoint, point);
        this.normalize(v2);
        float[] rightPt1 = this.add(lastPoint, offset1);
        float[] rightPt2 = this.add(lastPoint, offset2);
        float[] leftPt1 = this.subtract(lastPoint, offset1);
        float alpha = this.getIntersectionAlpha(rightPt1, v1, rightPt2, v2);
        float[] rightCorner = this.addScaled(rightPt1, v1, alpha);
        alpha = -alpha;
        float[] leftCorner = this.addScaled(leftPt1, v1, alpha);
        float dist = this.distance(rightCorner, leftCorner);
        if (dist > this.miterLimit * this.lineOffset * 2.0f) {
            this.drawCornerBevel(secondLastPoint, lastPoint, point);
        } else {
            this.addVertex(rightCorner[0], rightCorner[1]);
            this.addVertex(leftCorner[0], leftCorner[1]);
        }
    }

    private final float distance(float[] pt1, float[] pt2) {
        double diffX = pt1[0] - pt2[0];
        double diffY = pt1[1] - pt2[1];
        double distSq = diffX * diffX + diffY * diffY;
        return (float)Math.sqrt(distSq);
    }

    private final float[] addScaled(float[] pt, float[] v, float alpha) {
        return new float[]{pt[0] + v[0] * alpha, pt[1] + v[1] * alpha};
    }

    private final void normalize(float[] v) {
        float norm = (float)Math.sqrt(v[0] * v[0] + v[1] * v[1]);
        v[0] = v[0] / norm;
        v[1] = v[1] / norm;
    }

    private final float[] subtract(float[] pt1, float[] pt2) {
        return new float[]{pt1[0] - pt2[0], pt1[1] - pt2[1]};
    }

    private final float[] add(float[] pt1, float[] pt2) {
        return new float[]{pt2[0] + pt1[0], pt2[1] + pt1[1]};
    }

    private final float getIntersectionAlpha(float[] pt1, float[] v1, float[] pt2, float[] v2) {
        float t = (pt2[0] - pt1[0]) * v2[1] - (pt2[1] - pt1[1]) * v2[0];
        return t /= v1[0] * v2[1] - v1[1] * v2[0];
    }

    private final float[] lineOffset(float[] linePoint1, float[] linePoint2) {
        float[] vec = CachedFloatArray.INSTANCE.invoke(2);
        vec[0] = linePoint2[0] - linePoint1[0];
        vec[1] = linePoint2[1] - linePoint1[1];
        float norm = vec[0] * vec[0] + vec[1] * vec[1];
        norm = (float)Math.sqrt(norm);
        float scale = this.lineOffset / norm;
        float[] offset = CachedFloatArray.INSTANCE.invoke(2);
        offset[0] = vec[1] * scale;
        offset[1] = -vec[0] * scale;
        return offset;
    }

    private final float[] lineCorners(float[] linePoint1, float[] linePoint2, float[] vertex, float offset) {
        float[] translated = CachedFloatArray.INSTANCE.invoke(2);
        translated[0] = linePoint2[0] - linePoint1[0];
        translated[1] = linePoint2[1] - linePoint1[1];
        float norm = translated[0] * translated[0] + translated[1] * translated[1];
        norm = (float)Math.sqrt(norm);
        float scale = offset / norm;
        float[] corners = CachedFloatArray.INSTANCE.invoke(4);
        corners[0] = translated[1] * scale + vertex[0];
        corners[1] = -translated[0] * scale + vertex[1];
        corners[2] = -translated[1] * scale + vertex[0];
        corners[3] = translated[0] * scale + vertex[1];
        return corners;
    }

    private final float[] getMiterIntersections(float[] secondLastPoint, float[] lastPoint, float[] point) {
        float[] o1 = this.lineCorners(secondLastPoint, lastPoint, lastPoint, this.lineOffset);
        float[] o2 = this.lineCorners(lastPoint, point, lastPoint, this.lineOffset);
        float[] v1 = CachedFloatArray.INSTANCE.invoke(2);
        v1[0] = lastPoint[0] - secondLastPoint[0];
        v1[1] = lastPoint[1] - secondLastPoint[1];
        float[] v2 = CachedFloatArray.INSTANCE.invoke(2);
        v2[0] = lastPoint[0] - point[0];
        v2[1] = lastPoint[1] - point[1];
        float norm = (float)Math.sqrt(v1[0] * v1[0] + v1[1] * v1[1]);
        v1[0] = v1[0] / norm;
        v1[1] = v1[1] / norm;
        norm = (float)Math.sqrt(v2[0] * v2[0] + v2[1] * v2[1]);
        v2[0] = v2[0] / norm;
        v2[1] = v2[1] / norm;
        float[] intersections = CachedFloatArray.INSTANCE.invoke(4);
        float t = (o2[0] - o1[0]) * v2[1] - (o2[1] - o1[1]) * v2[0];
        intersections[0] = o1[0] + (t /= v1[0] * v2[1] - v1[1] * v2[0]) * v1[0];
        intersections[1] = o1[1] + t * v1[1];
        t = (o2[2] - o1[2]) * v2[1] - (o2[3] - o1[3]) * v2[0];
        intersections[2] = o1[2] + (t /= v1[0] * v2[1] - v1[1] * v2[0]) * v1[0];
        intersections[3] = o1[3] + t * v1[1];
        return intersections;
    }

    private final void applyEndCap(float[] point1, float[] point2, boolean first) {
        switch (this.endCap) {
            case 0: {
                this.drawCapButt(point1, point2, first);
                break;
            }
            case 2: {
                this.drawCapSquare(point1, point2, first);
                break;
            }
            case 1: {
                this.drawCapRound(point1, point2, first);
            }
        }
    }

    private final void drawCapButt(float[] point1, float[] point2, boolean first) {
        float[] offset = this.lineOffset(point1, point2);
        float[] pt = first ? point1 : point2;
        float[] cornerPt = this.add(pt, offset);
        this.addVertex(cornerPt[0], cornerPt[1]);
        cornerPt = this.subtract(pt, offset);
        this.addVertex(cornerPt[0], cornerPt[1]);
    }

    private final void drawCapSquare(float[] point1, float[] point2, boolean first) {
        float[] offset = this.lineOffset(point1, point2);
        float[] offsetRotated = null;
        float[] pt = null;
        if (first) {
            offsetRotated = new float[]{offset[1], -offset[0]};
            pt = point1;
        } else {
            offsetRotated = new float[]{-offset[1], offset[0]};
            pt = point2;
        }
        float[] cornerPt = this.add(this.add(pt, offset), offsetRotated);
        this.addVertex(cornerPt[0], cornerPt[1]);
        cornerPt = this.add(this.subtract(pt, offset), offsetRotated);
        this.addVertex(cornerPt[0], cornerPt[1]);
    }

    /*
     * WARNING - void declaration
     */
    private final void drawCapRound(float[] point1, float[] point2, boolean first) {
        float[] offsetRight = null;
        float[] offsetLeft = null;
        float[] pt = null;
        if (first) {
            float[] v = this.subtract(point1, point2);
            this.normalize(v);
            v[0] = v[0] * this.lineOffset;
            v[1] = v[1] * this.lineOffset;
            offsetRight = v;
            offsetLeft = new float[]{v[0], v[1]};
            pt = point1;
        } else {
            offsetRight = this.lineOffset(point1, point2);
            offsetLeft = new float[]{-offsetRight[0], -offsetRight[1]};
            pt = point2;
        }
        int max = (int)Math.ceil(1.5707963267948966 / (double)THETA_STEP);
        int n = 0;
        int n2 = max - 1;
        if (n <= n2) {
            while (true) {
                void i;
                this.addVertex(pt[0] + offsetRight[0], pt[1] + offsetRight[1]);
                this.addVertex(pt[0] + offsetLeft[0], pt[1] + offsetLeft[1]);
                float newX = COS_STEP * offsetRight[0] + -SIN_STEP * offsetRight[1];
                offsetRight[1] = SIN_STEP * offsetRight[0] + COS_STEP * offsetRight[1];
                offsetRight[0] = newX;
                newX = COS_STEP * offsetLeft[0] + SIN_STEP * offsetLeft[1];
                offsetLeft[1] = -SIN_STEP * offsetLeft[0] + COS_STEP * offsetLeft[1];
                offsetLeft[0] = newX;
                if (i == n2) break;
                ++i;
            }
        }
        if (first) {
            offsetRight = this.lineOffset(point1, point2);
            this.addVertex(pt[0] + offsetRight[0], point1[1] + offsetRight[1]);
            this.addVertex(pt[0] - offsetRight[0], point1[1] - offsetRight[1]);
        } else {
            float[] v = this.subtract(point2, point1);
            this.normalize(v);
            v[0] = v[0] * this.lineOffset;
            v[1] = v[1] * this.lineOffset;
            this.addVertex(pt[0] + v[0], pt[1] + v[1]);
        }
    }

    private final void addVertex(float x, float y) {
        this.vBuffer.addVertex(x, y);
    }

    protected abstract void drawBuffer();

    static {
        Companion = new Companion(null);
        THETA_STEP = 0.5f;
        COS_STEP = (float)Math.cos(THETA_STEP);
        SIN_STEP = (float)Math.sin(THETA_STEP);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/anglur/joglext/jogl2d/impl/BasicStrokeLineVisitor$Companion;", "", "()V", "COS_STEP", "", "SIN_STEP", "THETA_STEP", "JOGLExt"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

