/*
 * Decompiled with CFR 0.152.
 */
package org.anglur.joglext.jogl2d.impl;

import com.jogamp.opengl.GL;
import java.awt.BasicStroke;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.anglur.joglext.cacheable.CachedFloatArray;
import org.anglur.joglext.jogl2d.PathVisitor;
import org.anglur.joglext.jogl2d.VertexBuffer;
import org.anglur.joglext.jogl2d.impl.SimplePathVisitor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u000fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/anglur/joglext/jogl2d/impl/SimpleOrTesselatingVisitor;", "Lorg/anglur/joglext/jogl2d/impl/SimplePathVisitor;", "simpleFallback", "Lorg/anglur/joglext/jogl2d/PathVisitor;", "tesselatorFallback", "(Lorg/anglur/joglext/jogl2d/PathVisitor;Lorg/anglur/joglext/jogl2d/PathVisitor;)V", "firstContour", "", "isConvexSoFar", "numberOfPreviousVertices", "", "previousVertices", "", "sign", "totalCurvature", "", "vBuffer", "Lorg/anglur/joglext/jogl2d/VertexBuffer;", "windingRule", "beginPoly", "", "closeLine", "drawToVisitor", "visitor", "doClose", "endPoly", "isValidCorner", "vertex", "lineTo", "moveTo", "setGLContext", "context", "Lcom/jogamp/opengl/GL;", "setStroke", "stroke", "Ljava/awt/BasicStroke;", "setUseTesselator", "value", "JOGLExt"})
public final class SimpleOrTesselatingVisitor
extends SimplePathVisitor {
    private VertexBuffer vBuffer;
    private float[] previousVertices;
    private int numberOfPreviousVertices;
    private double totalCurvature;
    private int sign;
    private boolean isConvexSoFar;
    private boolean firstContour;
    private int windingRule;
    private PathVisitor simpleFallback;
    private PathVisitor tesselatorFallback;

    @Override
    public void setGLContext(@NotNull GL context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.simpleFallback.setGLContext(context);
        this.tesselatorFallback.setGLContext(context);
    }

    @Override
    public void setStroke(@NotNull BasicStroke stroke) {
        Intrinsics.checkParameterIsNotNull((Object)stroke, (String)"stroke");
    }

    @Override
    public void beginPoly(int windingRule) {
        this.isConvexSoFar = true;
        this.firstContour = true;
        this.sign = 0;
        this.totalCurvature = 0.0;
        this.windingRule = windingRule;
    }

    @Override
    public void moveTo(@NotNull float[] vertex) {
        Intrinsics.checkParameterIsNotNull((Object)vertex, (String)"vertex");
        if (this.firstContour) {
            this.firstContour = false;
        } else if (this.isConvexSoFar) {
            this.setUseTesselator(false);
        }
        if (this.isConvexSoFar) {
            this.numberOfPreviousVertices = 1;
            this.previousVertices = new float[]{vertex[0], vertex[1], 0.0f, 0.0f};
            this.vBuffer.clear();
            this.vBuffer.addVertex(vertex[0], vertex[1]);
        } else {
            this.tesselatorFallback.closeLine();
            this.tesselatorFallback.moveTo(vertex);
        }
    }

    @Override
    public void lineTo(@NotNull float[] vertex) {
        Intrinsics.checkParameterIsNotNull((Object)vertex, (String)"vertex");
        if (this.isConvexSoFar) {
            this.vBuffer.addVertex(vertex[0], vertex[1]);
            if (!this.isValidCorner(vertex)) {
                this.setUseTesselator(false);
            }
        } else {
            this.tesselatorFallback.lineTo(vertex);
        }
    }

    private final boolean isValidCorner(float[] vertex) {
        if (this.numberOfPreviousVertices >= 2) {
            double diff1 = this.previousVertices[2] - this.previousVertices[0];
            double diff2 = this.previousVertices[3] - this.previousVertices[1];
            double diff3 = vertex[0] - this.previousVertices[0];
            double diff4 = vertex[1] - this.previousVertices[1];
            double cross2 = diff1 * diff4 - diff2 * diff3;
            int currentSign = this.sign(cross2);
            if (this.sign == 0) {
                this.sign = currentSign;
            } else if (currentSign * this.sign == -1) {
                return false;
            }
            double norm1sq = diff1 * diff1 + diff2 * diff2;
            double norm2sq = diff3 * diff3 + diff4 * diff4;
            double dot = diff1 * diff3 + diff2 * diff4;
            double cosThetasq = dot * dot / (norm1sq * norm2sq);
            double theta = Math.acos(Math.sqrt(cosThetasq));
            this.totalCurvature += theta;
            if (this.totalCurvature > 6.284185307179587) {
                return false;
            }
        }
        int n = this.numberOfPreviousVertices;
        this.numberOfPreviousVertices = n + 1;
        this.previousVertices[2] = this.previousVertices[0];
        this.previousVertices[3] = this.previousVertices[1];
        this.previousVertices[0] = vertex[0];
        this.previousVertices[1] = vertex[1];
        return true;
    }

    private final int sign(double value) {
        if (value > 1.0E-8) {
            return 1;
        }
        if (value < -1.0E-8) {
            return -1;
        }
        return 0;
    }

    @Override
    public void closeLine() {
        if (this.isConvexSoFar) {
            FloatBuffer buf = this.vBuffer.getBuffer();
            float[] vertex = CachedFloatArray.INSTANCE.invoke(2);
            int position = buf.position();
            buf.rewind();
            buf.get(vertex);
            boolean good = false;
            if (this.isValidCorner(vertex)) {
                buf.get(vertex);
                if (this.isValidCorner(vertex)) {
                    good = true;
                }
            }
            buf.position(position);
            if (!good) {
                this.setUseTesselator(true);
            }
        } else {
            this.tesselatorFallback.closeLine();
        }
    }

    @Override
    public void endPoly() {
        if (this.isConvexSoFar) {
            this.simpleFallback.beginPoly(this.windingRule);
            this.drawToVisitor(this.simpleFallback, true);
            this.simpleFallback.endPoly();
        } else {
            this.tesselatorFallback.endPoly();
        }
    }

    private final void setUseTesselator(boolean doClose) {
        this.isConvexSoFar = false;
        this.tesselatorFallback.beginPoly(this.windingRule);
        this.drawToVisitor(this.tesselatorFallback, doClose);
    }

    private final void drawToVisitor(PathVisitor visitor, boolean doClose) {
        FloatBuffer buf = this.vBuffer.getBuffer();
        buf.flip();
        float[] vertex = CachedFloatArray.INSTANCE.invoke(2);
        if (buf.hasRemaining()) {
            buf.get(vertex);
            visitor.moveTo(vertex);
        }
        while (buf.hasRemaining()) {
            buf.get(vertex);
            visitor.lineTo(vertex);
        }
        if (doClose) {
            visitor.closeLine();
        }
        this.vBuffer.clear();
    }

    public SimpleOrTesselatingVisitor(@NotNull PathVisitor simpleFallback, @NotNull PathVisitor tesselatorFallback) {
        Intrinsics.checkParameterIsNotNull((Object)simpleFallback, (String)"simpleFallback");
        Intrinsics.checkParameterIsNotNull((Object)tesselatorFallback, (String)"tesselatorFallback");
        this.simpleFallback = simpleFallback;
        this.tesselatorFallback = tesselatorFallback;
        this.vBuffer = new VertexBuffer(1024);
        this.previousVertices = CachedFloatArray.INSTANCE.invoke(4);
    }
}

