/*
 * Decompiled with CFR 0.152.
 */
package org.anglur.joglext.jogl2d.impl.gl2;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import java.awt.BasicStroke;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.anglur.joglext.cacheable.CachedFloatArray;
import org.anglur.joglext.jogl2d.VertexBuffer;
import org.anglur.joglext.jogl2d.impl.SimplePathVisitor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\nJ\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\fH\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\fH\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/anglur/joglext/jogl2d/impl/gl2/FastLineVisitor;", "Lorg/anglur/joglext/jogl2d/impl/SimplePathVisitor;", "()V", "buffer", "Lorg/anglur/joglext/jogl2d/VertexBuffer;", "gl", "Lcom/jogamp/opengl/GL2;", "glLineWidth", "", "stroke2", "Ljava/awt/BasicStroke;", "testMatrix", "", "beginPoly", "", "windingRule", "", "closeLine", "drawLine", "close", "", "endPoly", "isValid", "stroke", "lineTo", "vertex", "moveTo", "setGLContext", "context", "Lcom/jogamp/opengl/GL;", "setStroke", "JOGLExt"})
public final class FastLineVisitor
extends SimplePathVisitor {
    private float[] testMatrix = CachedFloatArray.INSTANCE.invoke(16);
    private VertexBuffer buffer = VertexBuffer.Companion.getSharedBuffer();
    private GL2 gl;
    private BasicStroke stroke2;
    private float glLineWidth;

    @Override
    public void setGLContext(@NotNull GL context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        GL2 gL2 = context.getGL2();
        Intrinsics.checkExpressionValueIsNotNull((Object)gL2, (String)"context.gL2");
        this.gl = gL2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setStroke(@NotNull BasicStroke stroke) {
        Intrinsics.checkParameterIsNotNull((Object)stroke, (String)"stroke");
        GL2 gL2 = this.gl;
        if (gL2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL2.glLineWidth(this.glLineWidth);
        GL2 gL22 = this.gl;
        if (gL22 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL22.glPointSize(this.glLineWidth);
        float[] dash = stroke.getDashArray();
        if (dash != null) {
            float totalLength = 0.0f;
            for (float f : dash) {
                totalLength += f;
            }
            float lengthSoFar = 0.0f;
            int prevIndex = 0;
            int mask = 0;
            int n = 0;
            int n2 = dash.length;
            while (n < n2) {
                void i;
                int n3 = prevIndex;
                int nextIndex = (int)((lengthSoFar += dash[i]) / totalLength * (float)16);
                int n4 = nextIndex - 1;
                if (n3 <= n4) {
                    while (true) {
                        void j;
                        mask |= (~i & 1) << j;
                        if (j == n4) break;
                        ++j;
                    }
                }
                prevIndex = nextIndex;
                ++i;
            }
            GL2 gL23 = this.gl;
            if (gL23 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
            }
            gL23.glEnable(2852);
            int factor = (int)totalLength;
            GL2 gL24 = this.gl;
            if (gL24 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
            }
            gL24.glLineStipple(factor >> 4, (short)mask);
        } else {
            GL2 gL25 = this.gl;
            if (gL25 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
            }
            gL25.glDisable(2852);
        }
        this.stroke2 = stroke;
    }

    public final boolean isValid(@NotNull BasicStroke stroke) {
        Intrinsics.checkParameterIsNotNull((Object)stroke, (String)"stroke");
        float[] dash = stroke.getDashArray();
        if (dash != null && (dash.length & 1) == 1) {
            return false;
        }
        GL2 gL2 = this.gl;
        if (gL2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL2.glGetFloatv(2982, this.testMatrix, 0);
        float scaleX = Math.abs(this.testMatrix[0]);
        float scaleY = Math.abs(this.testMatrix[5]);
        if ((double)Math.abs(scaleX - scaleY) > 1.0E-6) {
            return false;
        }
        float strokeWidth = stroke.getLineWidth();
        this.glLineWidth = strokeWidth * scaleX;
        return this.glLineWidth <= (float)2;
    }

    @Override
    public void moveTo(@NotNull float[] vertex) {
        Intrinsics.checkParameterIsNotNull((Object)vertex, (String)"vertex");
        this.drawLine(false);
        this.drawLine(false);
        this.buffer.addVertex(vertex, 0, 1);
    }

    @Override
    public void lineTo(@NotNull float[] vertex) {
        Intrinsics.checkParameterIsNotNull((Object)vertex, (String)"vertex");
        this.buffer.addVertex(vertex, 0, 1);
    }

    @Override
    public void closeLine() {
        this.drawLine(true);
    }

    private final void drawLine(boolean close) {
        FloatBuffer buf = this.buffer.getBuffer();
        int p = buf.position();
        GL2 gL2 = this.gl;
        if (gL2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        this.buffer.drawBuffer(gL2, close ? 2 : 3);
        BasicStroke basicStroke = this.stroke2;
        if (basicStroke == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stroke2");
        }
        if (basicStroke.getDashArray() == null) {
            buf.position(p);
            GL2 gL22 = this.gl;
            if (gL22 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
            }
            this.buffer.drawBuffer(gL22, 0);
        }
        this.buffer.clear();
    }

    @Override
    public void beginPoly(int windingRule) {
        this.buffer.clear();
        GL2 gL2 = this.gl;
        if (gL2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL2.glMatrixMode(5888);
        GL2 gL22 = this.gl;
        if (gL22 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL22.glPushMatrix();
        GL2 gL23 = this.gl;
        if (gL23 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL23.glTranslatef(0.5f, 0.5f, 0.0f);
        GL2 gL24 = this.gl;
        if (gL24 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL24.glPushAttrib(6);
    }

    @Override
    public void endPoly() {
        this.drawLine(false);
        GL2 gL2 = this.gl;
        if (gL2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL2.glDisable(2852);
        GL2 gL22 = this.gl;
        if (gL22 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL22.glPopMatrix();
        GL2 gL23 = this.gl;
        if (gL23 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL23.glPopAttrib();
    }
}

