/*
 * Decompiled with CFR 0.152.
 */
package org.anglur.joglext.jogl2d.impl.gl2;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import java.awt.BasicStroke;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.anglur.joglext.jogl2d.GLGraphics2D;
import org.anglur.joglext.jogl2d.impl.AbstractShapeHelper;
import org.anglur.joglext.jogl2d.impl.SimpleOrTesselatingVisitor;
import org.anglur.joglext.jogl2d.impl.SimplePathVisitor;
import org.anglur.joglext.jogl2d.impl.gl2.FastLineVisitor;
import org.anglur.joglext.jogl2d.impl.gl2.FillSimpleConvexPolygonVisitor;
import org.anglur.joglext.jogl2d.impl.gl2.GL2TesselatorVisitor;
import org.anglur.joglext.jogl2d.impl.gl2.LineDrawingVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/anglur/joglext/jogl2d/impl/gl2/GL2ShapeDrawer;", "Lorg/anglur/joglext/jogl2d/impl/AbstractShapeHelper;", "()V", "complexFillVisitor", "Lorg/anglur/joglext/jogl2d/impl/SimpleOrTesselatingVisitor;", "fastLineVisitor", "Lorg/anglur/joglext/jogl2d/impl/gl2/FastLineVisitor;", "gl", "Lcom/jogamp/opengl/GL2;", "simpleFillVisitor", "Lorg/anglur/joglext/jogl2d/impl/gl2/FillSimpleConvexPolygonVisitor;", "simpleStrokeVisitor", "Lorg/anglur/joglext/jogl2d/impl/gl2/LineDrawingVisitor;", "draw", "", "shape", "Ljava/awt/Shape;", "fill", "forceSimple", "", "setG2D", "g2d", "Lorg/anglur/joglext/jogl2d/GLGraphics2D;", "setHint", "key", "Ljava/awt/RenderingHints$Key;", "value", "", "JOGLExt"})
public final class GL2ShapeDrawer
extends AbstractShapeHelper {
    private GL2 gl;
    private FillSimpleConvexPolygonVisitor simpleFillVisitor = new FillSimpleConvexPolygonVisitor();
    private SimpleOrTesselatingVisitor complexFillVisitor = new SimpleOrTesselatingVisitor(this.simpleFillVisitor, new GL2TesselatorVisitor());
    private LineDrawingVisitor simpleStrokeVisitor = new LineDrawingVisitor();
    private FastLineVisitor fastLineVisitor = new FastLineVisitor();

    @Override
    public void setG2D(@NotNull GLGraphics2D g2d) {
        GL gl;
        Intrinsics.checkParameterIsNotNull((Object)g2d, (String)"g2d");
        super.setG2D(g2d);
        GL gL = gl = g2d.getGlContext().getGL();
        Intrinsics.checkExpressionValueIsNotNull((Object)gL, (String)"gl");
        this.simpleFillVisitor.setGLContext(gL);
        this.complexFillVisitor.setGLContext(gl);
        this.simpleStrokeVisitor.setGLContext(gl);
        this.fastLineVisitor.setGLContext(gl);
        GL2 gL2 = gl.getGL2();
        Intrinsics.checkExpressionValueIsNotNull((Object)gL2, (String)"gl.gL2");
        this.gl = gL2;
    }

    @Override
    public void setHint(@NotNull RenderingHints.Key key, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        super.setHint(key, value);
        if (key == RenderingHints.KEY_ANTIALIASING) {
            if (value == RenderingHints.VALUE_ANTIALIAS_ON) {
                GL2 gL2 = this.gl;
                if (gL2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
                }
                gL2.glEnable(32925);
            } else {
                GL2 gL2 = this.gl;
                if (gL2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
                }
                gL2.glDisable(32925);
            }
        }
    }

    @Override
    public void draw(@NotNull Shape shape) {
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            if (this.fastLineVisitor.isValid((BasicStroke)stroke)) {
                this.fastLineVisitor.setStroke((BasicStroke)stroke);
                this.traceShape(shape, this.fastLineVisitor);
                return;
            }
            if (((BasicStroke)stroke).getDashArray() == null) {
                this.simpleStrokeVisitor.setStroke((BasicStroke)stroke);
                this.traceShape(shape, this.simpleStrokeVisitor);
                return;
            }
        }
        Shape shape2 = stroke.createStrokedShape(shape);
        Intrinsics.checkExpressionValueIsNotNull((Object)shape2, (String)"stroke.createStrokedShape(shape)");
        this.fill(shape2);
    }

    @Override
    protected void fill(@NotNull Shape shape, boolean forceSimple) {
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        this.traceShape(shape, forceSimple ? (SimplePathVisitor)this.simpleFillVisitor : (SimplePathVisitor)this.complexFillVisitor);
    }
}

