/*
 * Decompiled with CFR 0.152.
 */
package org.anglur.joglext.jogl2d.impl.gl2;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.glu.gl2.GLUgl2;
import java.text.AttributedCharacterIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.anglur.joglext.cacheable.CachedIntArray;
import org.anglur.joglext.jogl2d.font.BitmapCharRec;
import org.anglur.joglext.jogl2d.font.BitmapFontRec;
import org.anglur.joglext.jogl2d.font.GLUTBitmap8x13;
import org.anglur.joglext.jogl2d.font.GLUTBitmap9x15;
import org.anglur.joglext.jogl2d.font.GLUTBitmapHelvetica10;
import org.anglur.joglext.jogl2d.font.GLUTBitmapHelvetica12;
import org.anglur.joglext.jogl2d.font.GLUTBitmapHelvetica18;
import org.anglur.joglext.jogl2d.font.GLUTBitmapTimesRoman10;
import org.anglur.joglext.jogl2d.font.GLUTBitmapTimesRoman24;
import org.anglur.joglext.jogl2d.impl.AbstractTextDrawer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0016J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/anglur/joglext/jogl2d/impl/gl2/GL2StringDrawer;", "Lorg/anglur/joglext/jogl2d/impl/AbstractTextDrawer;", "()V", "alignment", "", "bitmapFonts", "", "Lorg/anglur/joglext/jogl2d/font/BitmapFontRec;", "[Lorg/anglur/joglext/jogl2d/font/BitmapFontRec;", "lsbfirst", "rowlength", "skippixels", "skiprows", "swapbytes", "beginBitmap", "", "gl", "Lcom/jogamp/opengl/GL2;", "bitmapCharacterImpl", "font", "", "cin", "", "dispose", "drawString", "iterator", "Ljava/text/AttributedCharacterIterator;", "x", "", "y", "string", "", "endBitmap", "getBitmapFont", "glutBitmapString", "JOGLExt"})
public final class GL2StringDrawer
extends AbstractTextDrawer {
    private final int[] swapbytes = CachedIntArray.INSTANCE.invoke(1);
    private final int[] lsbfirst = CachedIntArray.INSTANCE.invoke(1);
    private final int[] rowlength = CachedIntArray.INSTANCE.invoke(1);
    private final int[] skiprows = CachedIntArray.INSTANCE.invoke(1);
    private final int[] skippixels = CachedIntArray.INSTANCE.invoke(1);
    private final int[] alignment = CachedIntArray.INSTANCE.invoke(1);
    private final BitmapFontRec[] bitmapFonts = new BitmapFontRec[9];

    @Override
    public void dispose() {
    }

    @Override
    public void drawString(@NotNull AttributedCharacterIterator iterator, float x, float y) {
        Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
        this.drawString(iterator, (int)x, (int)y);
    }

    @Override
    public void drawString(@NotNull AttributedCharacterIterator iterator, int x, int y) {
        Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
        StringBuilder builder = new StringBuilder(iterator.getEndIndex() - iterator.getBeginIndex());
        while (iterator.next() != '\uffff') {
            builder.append(iterator.current());
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        this.drawString(string, x, y);
    }

    @Override
    public void drawString(@NotNull String string, float x, float y) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        this.drawString(string, (int)x, (int)y);
    }

    @Override
    public void drawString(@NotNull String string, int x, int y) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        GL gL = this.getG2d().getGlContext().getGL();
        Intrinsics.checkExpressionValueIsNotNull((Object)gL, (String)"g2d.glContext.gl");
        gL.getGL2().glRasterPos2d((double)x, (double)y);
        this.glutBitmapString(4, string);
    }

    /*
     * WARNING - void declaration
     */
    public final void glutBitmapString(int font, @NotNull String string) {
        GL2 gl;
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        GL2 gL2 = gl = GLUgl2.getCurrentGL2();
        Intrinsics.checkExpressionValueIsNotNull((Object)gL2, (String)"gl");
        this.beginBitmap(gL2);
        int len = string.length();
        int n = 0;
        int n2 = len - 1;
        if (n <= n2) {
            while (true) {
                void i;
                this.bitmapCharacterImpl(gl, font, string.charAt((int)i));
                if (i == n2) break;
                ++i;
            }
        }
        this.endBitmap(gl);
    }

    private final void beginBitmap(GL2 gl) {
        gl.glGetIntegerv(3312, this.swapbytes, 0);
        gl.glGetIntegerv(3313, this.lsbfirst, 0);
        gl.glGetIntegerv(3314, this.rowlength, 0);
        gl.glGetIntegerv(3315, this.skiprows, 0);
        gl.glGetIntegerv(3316, this.skippixels, 0);
        gl.glGetIntegerv(3317, this.alignment, 0);
        gl.glPixelStorei(3312, 0);
        gl.glPixelStorei(3313, 0);
        gl.glPixelStorei(3314, 0);
        gl.glPixelStorei(3315, 0);
        gl.glPixelStorei(3316, 0);
        gl.glPixelStorei(3317, 1);
    }

    private final void endBitmap(GL2 gl) {
        gl.glPixelStorei(3312, this.swapbytes[0]);
        gl.glPixelStorei(3313, this.lsbfirst[0]);
        gl.glPixelStorei(3314, this.rowlength[0]);
        gl.glPixelStorei(3315, this.skiprows[0]);
        gl.glPixelStorei(3316, this.skippixels[0]);
        gl.glPixelStorei(3317, this.alignment[0]);
    }

    private final void bitmapCharacterImpl(GL2 gl, int font, char cin) {
        int c = cin & 0xFFFF;
        BitmapFontRec fontinfo = this.getBitmapFont(font);
        if (c < fontinfo.getFirst() || c >= fontinfo.getFirst() + fontinfo.getNum_chars()) {
            return;
        }
        BitmapCharRec ch = fontinfo.getCh()[c - fontinfo.getFirst()];
        if (ch != null) {
            gl.glBitmap(ch.getWidth(), ch.getHeight(), ch.getXorig(), ch.getYorig(), ch.getAdvance(), 0.0f, ch.getBitmap(), 0);
        }
    }

    private final BitmapFontRec getBitmapFont(int font) {
        BitmapFontRec rec = this.bitmapFonts[font];
        if (rec == null) {
            switch (font) {
                case 2: {
                    rec = GLUTBitmap9x15.INSTANCE.getGlutBitmap9By15();
                    break;
                }
                case 3: {
                    rec = GLUTBitmap8x13.INSTANCE.getGlutBitmap8By13();
                    break;
                }
                case 4: {
                    rec = GLUTBitmapTimesRoman10.INSTANCE.getGlutBitmapTimesRoman10();
                    break;
                }
                case 5: {
                    rec = GLUTBitmapTimesRoman24.INSTANCE.getGlutBitmapTimesRoman24();
                    break;
                }
                case 6: {
                    rec = GLUTBitmapHelvetica10.INSTANCE.getGlutBitmapHelvetica10();
                    break;
                }
                case 7: {
                    rec = GLUTBitmapHelvetica12.INSTANCE.getGlutBitmapHelvetica12();
                    break;
                }
                case 8: {
                    rec = GLUTBitmapHelvetica18.INSTANCE.getGlutBitmapHelvetica18();
                    break;
                }
                default: {
                    throw (Throwable)new GLException("Unknown bitmap font number " + font);
                }
            }
            this.bitmapFonts[font] = rec;
        }
        return rec;
    }
}

