/*
 * Decompiled with CFR 0.152.
 */
package org.anglur.joglext.jogl2d.impl.gl2;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import java.awt.geom.AffineTransform;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.anglur.joglext.cacheable.CachedFloatArray;
import org.anglur.joglext.cacheable.CachedIntArray;
import org.anglur.joglext.jogl2d.GLGraphics2D;
import org.anglur.joglext.jogl2d.impl.AbstractMatrixHelper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/anglur/joglext/jogl2d/impl/gl2/GL2Transformhelper;", "Lorg/anglur/joglext/jogl2d/impl/AbstractMatrixHelper;", "()V", "gl", "Lcom/jogamp/opengl/GL2;", "matrixBuf", "", "viewportDimensions", "", "getViewportDimensions", "()[I", "flushTransformToOpenGL", "", "getGLMatrix", "transform", "Ljava/awt/geom/AffineTransform;", "setG2D", "g2d", "Lorg/anglur/joglext/jogl2d/GLGraphics2D;", "setupGLView", "JOGLExt"})
public final class GL2Transformhelper
extends AbstractMatrixHelper {
    private GL2 gl;
    private final float[] matrixBuf = CachedFloatArray.INSTANCE.invoke(16);
    @NotNull
    private final int[] viewportDimensions = CachedIntArray.INSTANCE.invoke(4);

    @Override
    public void setG2D(@NotNull GLGraphics2D g2d) {
        Intrinsics.checkParameterIsNotNull((Object)g2d, (String)"g2d");
        super.setG2D(g2d);
        GL gL = g2d.getGlContext().getGL();
        Intrinsics.checkExpressionValueIsNotNull((Object)gL, (String)"g2d.glContext.gl");
        GL2 gL2 = gL.getGL2();
        Intrinsics.checkExpressionValueIsNotNull((Object)gL2, (String)"g2d.glContext.gl.gL2");
        this.gl = gL2;
        this.setupGLView();
        this.flushTransformToOpenGL();
    }

    @NotNull
    public final int[] getViewportDimensions() {
        return this.viewportDimensions;
    }

    private final void setupGLView() {
        GL2 gL2 = this.gl;
        if (gL2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL2.glGetIntegerv(2978, this.viewportDimensions, 0);
        int width = this.viewportDimensions[2];
        int height = this.viewportDimensions[3];
        GL2 gL22 = this.gl;
        if (gL22 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL22.glMatrixMode(5889);
        GL2 gL23 = this.gl;
        if (gL23 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL23.glLoadIdentity();
        GL2 gL24 = this.gl;
        if (gL24 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL24.glOrtho(0.0, (double)width, 0.0, (double)height, -1.0, 1.0);
        GL2 gL25 = this.gl;
        if (gL25 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL25.glMatrixMode(5890);
        GL2 gL26 = this.gl;
        if (gL26 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL26.glLoadIdentity();
    }

    @Override
    protected void flushTransformToOpenGL() {
        AffineTransform affineTransform = this.getStack().peek();
        Intrinsics.checkExpressionValueIsNotNull((Object)affineTransform, (String)"stack.peek()");
        float[] matrix = this.getGLMatrix(affineTransform);
        GL2 gL2 = this.gl;
        if (gL2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL2.glMatrixMode(5888);
        GL2 gL22 = this.gl;
        if (gL22 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gl");
        }
        gL22.glLoadMatrixf(matrix, 0);
    }

    private final float[] getGLMatrix(AffineTransform transform) {
        this.matrixBuf[0] = (float)transform.getScaleX();
        this.matrixBuf[1] = -((float)transform.getShearY());
        this.matrixBuf[4] = (float)transform.getShearX();
        this.matrixBuf[5] = -((float)transform.getScaleY());
        this.matrixBuf[10] = 1.0f;
        this.matrixBuf[12] = (float)transform.getTranslateX();
        this.matrixBuf[13] = (float)this.getG2d().getCanvasHeight() - (float)transform.getTranslateY();
        this.matrixBuf[15] = 1.0f;
        return this.matrixBuf;
    }
}

