/*
 * Decompiled with CFR 0.152.
 */
package org.annolab.tt4j;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.annolab.tt4j.LittleEndianDataInputStream;
import org.annolab.tt4j.TreeTaggerModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeTaggerModelReader {
    private String charsetName = "UTF-8";
    private InputStream inStream;
    private DataInput in;
    private boolean readDictionary = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeTaggerModel read(InputStream aIn) throws IOException {
        TreeTaggerModel model = new TreeTaggerModel();
        this.inStream = aIn;
        this.in = new DataInputStream(this.inStream);
        try {
            int version = this.in.readInt();
            if (!this.decodeVersion(model, version, ByteOrder.BIG_ENDIAN)) {
                if (this.decodeVersion(model, Integer.reverseBytes(version), ByteOrder.LITTLE_ENDIAN)) {
                    this.in = new LittleEndianDataInputStream(aIn);
                } else {
                    throw new IllegalStateException("Unknown version or file format");
                }
            }
            int numberOfTags = -1;
            switch (model.getVersion()) {
                case 31: {
                    this.in.readInt();
                    numberOfTags = this.in.readInt();
                    break;
                }
                case 32: {
                    this.in.readInt();
                    this.in.readInt();
                    numberOfTags = this.in.readInt();
                }
            }
            model.setTags(this.readStrings(numberOfTags));
            if (this.readDictionary) {
                int lemmaSize = this.in.readInt();
                model.setLemmas(this.readStrings(lemmaSize));
                int tokenSize = this.in.readInt();
                assert (-2 == this.in.readInt());
                assert (0 == this.in.readByte());
                int c1 = this.in.readInt();
                for (int c1i = 0; c1i < c1; ++c1i) {
                    this.in.readInt();
                    this.in.readInt();
                    this.in.readInt();
                }
                this.in.readInt();
                assert (0 == this.in.readByte());
                int c2 = this.in.readInt();
                this.in.readInt();
                for (int band = 0; band < 3; ++band) {
                    for (int c2i = 0; c2i < c2; ++c2i) {
                        this.in.readInt();
                    }
                }
                ArrayList<String> tokens = new ArrayList<String>();
                for (int ct = 0; ct < tokenSize; ++ct) {
                    String token = this.readZeroTerminatedString(this.charsetName);
                    tokens.add(token);
                    int bsize = this.in.readInt();
                    this.in.readInt();
                    for (int cb = 0; cb < bsize; ++cb) {
                        this.in.readInt();
                        this.in.readInt();
                        this.in.readInt();
                    }
                }
                model.setTokens(tokens);
            }
            TreeTaggerModel treeTaggerModel = model;
            return treeTaggerModel;
        }
        finally {
            this.inStream = null;
            this.in = null;
        }
    }

    protected List<String> readStrings(int aCount) throws IOException {
        ArrayList<String> tags = new ArrayList<String>();
        for (int i = 0; i < aCount; ++i) {
            String tag = this.readZeroTerminatedString(this.charsetName);
            tags.add(tag);
        }
        return tags;
    }

    protected boolean decodeVersion(TreeTaggerModel aModel, int aVersion, ByteOrder aByteOrder) {
        switch (aVersion) {
            case 31: 
            case 32: {
                aModel.setVersion(aVersion);
                aModel.setByteOrder(aByteOrder);
                return true;
            }
        }
        return false;
    }

    protected String readZeroTerminatedString(String aCharsetName) throws IOException {
        return new String(this.readZeroTerminatedByteArray(), aCharsetName);
    }

    protected byte[] readZeroTerminatedByteArray() throws IOException {
        int b;
        int bytesRead = 0;
        byte[] buffer = new byte[128];
        int i = 0;
        while ((b = this.inStream.read()) != -1) {
            byte[] buf;
            if (b == 0) {
                buf = buffer;
                buffer = new byte[bytesRead];
                System.arraycopy(buf, 0, buffer, 0, bytesRead);
                return buffer;
            }
            if (i == buffer.length) {
                buf = buffer;
                buffer = new byte[buf.length + 128];
                System.arraycopy(buf, 0, buffer, 0, buf.length);
                i = 0;
            }
            buffer[i] = (byte)b;
            ++bytesRead;
            ++i;
        }
        throw new IOException("Unexpected end of file.");
    }

    public String getEncoding() {
        return this.charsetName;
    }

    public void setEncoding(String aCharsetName) {
        this.charsetName = aCharsetName;
    }

    public boolean isReadDictionary() {
        return this.readDictionary;
    }

    public void setReadDictionary(boolean aReadDictionary) {
        this.readDictionary = aReadDictionary;
    }
}

