/*
 * Decompiled with CFR 0.152.
 */
package org.annolab.tt4j;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.CharBuffer;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private Util() {
    }

    public static List<String> getSearchPaths(List<String> aAdditionalPaths, String aSubPath) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.addAll(aAdditionalPaths);
        if (System.getProperty("treetagger.home") != null) {
            paths.add(System.getProperty("treetagger.home") + File.separator + aSubPath);
        }
        if (System.getenv("TREETAGGER_HOME") != null) {
            paths.add(System.getenv("TREETAGGER_HOME") + File.separator + aSubPath);
        }
        if (System.getenv("TAGDIR") != null) {
            paths.add(System.getenv("TAGDIR") + File.separator + aSubPath);
        }
        return paths;
    }

    public static String join(String[] aStrings, String aSeparator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < aStrings.length; ++i) {
            sb.append(aStrings[i]);
            if (i >= aStrings.length - 1) continue;
            sb.append(aSeparator);
        }
        return sb.toString();
    }

    public static String join(Collection<String> aStrings, String aSeparator) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> i = aStrings.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(aSeparator);
        }
        return sb.toString();
    }

    public static boolean matches(String tokenSent, String tokenReturned) {
        if (tokenSent == null && tokenReturned == null) {
            return true;
        }
        if (tokenSent == null || tokenReturned == null) {
            return false;
        }
        if (tokenSent.length() != tokenReturned.length()) {
            return false;
        }
        for (int i = 0; i < tokenSent.length(); ++i) {
            if (tokenReturned.charAt(i) == '?' || tokenSent.charAt(i) == tokenReturned.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static void close(Closeable aClosable) {
        if (aClosable != null) {
            try {
                aClosable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readFile(File aFile, String aEncoding) throws IOException {
        String string;
        InputStreamReader reader = null;
        try {
            StringBuilder sb = new StringBuilder();
            CharBuffer buffer = CharBuffer.allocate(65535);
            reader = new InputStreamReader((InputStream)new FileInputStream(aFile), aEncoding);
            while (((Reader)reader).ready()) {
                ((Reader)reader).read(buffer);
                buffer.flip();
                sb.append(buffer.toString());
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            Util.close(reader);
            throw throwable;
        }
        Util.close(reader);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeFile(String aText, File aFile, String aEncoding) throws IOException {
        OutputStreamWriter writer = null;
        try {
            aFile.getParentFile().mkdirs();
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(aFile), aEncoding);
            writer.write(aText);
        }
        catch (Throwable throwable) {
            Util.close(writer);
            throw throwable;
        }
        Util.close(writer);
    }

    protected static String[] tokenize(String aText, Locale aLocale) {
        ArrayList<String> tokens = new ArrayList<String>();
        BreakIterator bi = BreakIterator.getWordInstance(aLocale);
        bi.setText(aText);
        int begin = 0;
        while (bi.next() != -1) {
            tokens.add(aText.substring(begin, bi.current()));
            begin = bi.current();
        }
        return tokens.toArray(new String[tokens.size()]);
    }
}

