/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.mojo.antlr3;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.antlr.Tool;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;

@Mojo(name="antlr", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true, threadSafe=true)
public class Antlr3Mojo
extends AbstractMojo {
    @Parameter(property="report", defaultValue="false")
    protected boolean report;
    @Parameter(property="printGrammar", defaultValue="false")
    protected boolean printGrammar;
    @Parameter(property="debug", defaultValue="false")
    protected boolean debug;
    @Parameter(property="profile", defaultValue="false")
    protected boolean profile;
    @Parameter(property="nfa", defaultValue="false")
    protected boolean nfa;
    @Parameter(property="dfa", defaultValue="false")
    protected boolean dfa;
    @Parameter(property="trace", defaultValue="false")
    protected boolean trace;
    @Parameter(property="messageFormat", defaultValue="antlr")
    protected String messageFormat;
    @Parameter(property="verbose", defaultValue="true")
    protected boolean verbose;
    @Parameter(property="maxSwitchCaseLabels", defaultValue="300")
    private int maxSwitchCaseLabels;
    @Parameter(property="minSwitchAlts", defaultValue="3")
    private int minSwitchAlts;
    @Parameter
    protected Set<String> includes = new HashSet<String>();
    @Parameter
    protected Set<String> excludes = new HashSet<String>();
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${basedir}/src/main/antlr3")
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/antlr3", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${basedir}/src/main/antlr3/imports")
    private File libDirectory;
    protected Tool tool;

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public File getLibDirectory() {
        return this.libDirectory;
    }

    void addSourceRoot(File outputDir) {
        this.project.addCompileSourceRoot(outputDir.getPath());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File outputDir;
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            for (String e : this.excludes) {
                log.debug((CharSequence)("ANTLR: Exclude: " + e));
            }
            for (String e : this.includes) {
                log.debug((CharSequence)("ANTLR: Include: " + e));
            }
            log.debug((CharSequence)("ANTLR: Output: " + this.outputDirectory));
            log.debug((CharSequence)("ANTLR: Library: " + this.libDirectory));
            log.debug((CharSequence)("ANTLR: report              : " + this.report));
            log.debug((CharSequence)("ANTLR: printGrammar        : " + this.printGrammar));
            log.debug((CharSequence)("ANTLR: debug               : " + this.debug));
            log.debug((CharSequence)("ANTLR: profile             : " + this.profile));
            log.debug((CharSequence)("ANTLR: nfa                 : " + this.nfa));
            log.debug((CharSequence)("ANTLR: dfa                 : " + this.dfa));
            log.debug((CharSequence)("ANTLR: trace               : " + this.trace));
            log.debug((CharSequence)("ANTLR: messageFormat       : " + this.messageFormat));
            log.debug((CharSequence)("ANTLR: maxSwitchCaseLabels : " + this.maxSwitchCaseLabels));
            log.debug((CharSequence)("ANTLR: minSwitchAlts       : " + this.minSwitchAlts));
            log.debug((CharSequence)("ANTLR: verbose             : " + this.verbose));
        }
        if (!(outputDir = this.getOutputDirectory()).exists()) {
            outputDir.mkdirs();
        }
        try {
            this.tool = new Tool();
        }
        catch (Exception e) {
            log.error((CharSequence)"The attempt to create the ANTLR build tool failed, see exception report for details");
            throw new MojoFailureException("Jim failed you!");
        }
        this.tool.setDebug(this.debug);
        this.tool.setGenerate_DFA_dot(this.dfa);
        this.tool.setGenerate_NFA_dot(this.nfa);
        this.tool.setProfile(this.profile);
        this.tool.setReport(this.report);
        this.tool.setPrintGrammar(this.printGrammar);
        this.tool.setTrace(this.trace);
        this.tool.setVerbose(this.verbose);
        this.tool.setMessageFormat(this.messageFormat);
        this.tool.setMaxSwitchCaseLabels(this.maxSwitchCaseLabels);
        this.tool.setMinSwitchAlts(this.minSwitchAlts);
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Output directory base will be " + this.outputDirectory.getAbsolutePath()));
        }
        this.tool.setOutputDirectory(this.outputDirectory.getAbsolutePath());
        this.tool.setForceRelativeOutput(true);
        this.tool.setLibDirectory(this.libDirectory.getAbsolutePath());
        if (!this.sourceDirectory.exists()) {
            if (log.isInfoEnabled()) {
                log.info((CharSequence)("No ANTLR grammars to compile in " + this.sourceDirectory.getAbsolutePath()));
            }
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((CharSequence)("ANTLR: Processing source directory " + this.sourceDirectory.getAbsolutePath()));
        }
        this.tool.setInputDirectory(this.sourceDirectory.getAbsolutePath());
        try {
            this.processGrammarFiles(this.sourceDirectory, this.outputDirectory);
        }
        catch (InclusionScanException ie) {
            log.error((Throwable)ie);
            throw new MojoExecutionException("Fatal error occured while evaluating the names of the grammar files to analyze");
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
        this.tool.process();
        if (this.tool.getNumErrors() > 0) {
            throw new MojoExecutionException("ANTLR caught " + this.tool.getNumErrors() + " build errors.");
        }
        if (this.project != null) {
            this.addSourceRoot(this.getOutputDirectory());
        }
    }

    private void processGrammarFiles(File sourceDirectory, File outputDirectory) throws IOException, InclusionScanException {
        SuffixMapping mapping = new SuffixMapping("g", Collections.emptySet());
        Set<String> includes = this.getIncludesPatterns();
        this.excludes.add("imports/**");
        SimpleSourceInclusionScanner scan = new SimpleSourceInclusionScanner(includes, this.excludes);
        scan.addSourceMapping((SourceMapping)mapping);
        Set grammarFiles = scan.getIncludedSources(sourceDirectory, null);
        if (grammarFiles.isEmpty()) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"No grammars to process");
            }
        } else {
            this.tool.setMake(true);
            for (File grammar : grammarFiles) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Grammar file '" + grammar.getPath() + "' detected."));
                }
                String relPath = this.findSourceSubdir(sourceDirectory, grammar.getPath()) + grammar.getName();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("  ... relative path is: " + relPath));
                }
                this.tool.addGrammarFile(relPath);
            }
        }
    }

    public Set<String> getIncludesPatterns() {
        if (this.includes == null || this.includes.isEmpty()) {
            return Collections.singleton("**/*.g");
        }
        return this.includes;
    }

    private String findSourceSubdir(File sourceDirectory, String grammarFileName) {
        String srcPath = sourceDirectory.getPath() + File.separator;
        if (!grammarFileName.startsWith(srcPath)) {
            throw new IllegalArgumentException("expected " + grammarFileName + " to be prefixed with " + sourceDirectory);
        }
        File unprefixedGrammarFileName = new File(grammarFileName.substring(srcPath.length()));
        if (unprefixedGrammarFileName.getParent() != null) {
            return unprefixedGrammarFileName.getParent() + File.separator;
        }
        return "";
    }
}

