/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.intellij.adaptor;

import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiNamedElement;
import java.util.Collection;
import org.antlr.intellij.adaptor.psi.ScopeNode;
import org.antlr.intellij.adaptor.psi.Trees;
import org.antlr.intellij.adaptor.xpath.XPath;

public class SymtabUtils {
    public static PsiElement resolve(ScopeNode scope, Language language, PsiNamedElement namedElement, String xpathToIDNodes) {
        Collection<? extends PsiElement> defIDNodes = XPath.findAll(language, scope, xpathToIDNodes);
        String id = namedElement.getName();
        PsiElement idNode = Trees.toMap(defIDNodes).get(id);
        if (idNode != null) {
            return idNode.getParent();
        }
        ScopeNode context = scope.getContext();
        if (context != null) {
            return context.resolve(namedElement);
        }
        return null;
    }

    public static ScopeNode getContextFor(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof ScopeNode) {
            return (ScopeNode)parent;
        }
        if (parent instanceof PsiErrorElement) {
            return null;
        }
        return (ScopeNode)parent.getContext();
    }
}

