/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.intellij.adaptor.lexer;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.misc.Interval;

class CharSequenceCharStream
implements CharStream {
    private final CharSequence buffer;
    private final int endOffset;
    private final String sourceName;
    private int position;

    public CharSequenceCharStream(CharSequence buffer, int endOffset, String sourceName) {
        this.buffer = buffer;
        this.sourceName = sourceName;
        this.endOffset = endOffset;
    }

    protected final CharSequence getBuffer() {
        return this.buffer;
    }

    protected final int getPosition() {
        return this.position;
    }

    protected final void setPosition(int position) {
        this.position = position;
    }

    public String getText(Interval interval) {
        int start = interval.a;
        int stop = interval.b;
        int n = this.size();
        if (stop >= n) {
            stop = n - 1;
        }
        if (start >= n) {
            return "";
        }
        return this.buffer.subSequence(start, stop + 1).toString();
    }

    public void consume() {
        if (this.position == this.size()) {
            throw new IllegalStateException("attempted to consume EOF");
        }
        ++this.position;
    }

    public int LA(int i) {
        if (i > 0) {
            int index = this.position + i - 1;
            if (index >= this.size()) {
                return -1;
            }
            return this.buffer.charAt(index);
        }
        if (i < 0) {
            int index = this.position + i;
            if (index < 0) {
                return 0;
            }
            return this.buffer.charAt(index);
        }
        return 0;
    }

    public int mark() {
        return 0;
    }

    public void release(int marker) {
    }

    public int index() {
        return this.position;
    }

    public void seek(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index cannot be negative");
        }
        this.position = index = Math.min(index, this.size());
    }

    public int size() {
        if (this.endOffset >= 0) {
            return this.endOffset;
        }
        int n = this.buffer.length();
        return n;
    }

    public String getSourceName() {
        return this.sourceName;
    }
}

