/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.intellij.adaptor.lexer;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.antlr.intellij.adaptor.lexer.CharSequenceCharStream;
import org.antlr.intellij.adaptor.lexer.TokenIElementType;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.misc.Pair;

public class PSITokenSource
implements TokenSource {
    protected PsiBuilder builder;
    protected TokenFactory tokenFactory = CommonTokenFactory.DEFAULT;

    public PSITokenSource(PsiBuilder builder) {
        this.builder = builder;
    }

    public int getCharPositionInLine() {
        return 0;
    }

    public Token nextToken() {
        ProgressIndicatorProvider.checkCanceled();
        TokenIElementType ideaTType = (TokenIElementType)this.builder.getTokenType();
        int type = ideaTType != null ? ideaTType.getANTLRTokenType() : -1;
        int channel = 0;
        Pair source = new Pair((Object)this, null);
        String text = this.builder.getTokenText();
        int start = this.builder.getCurrentOffset();
        int length = text != null ? text.length() : 0;
        int stop = start + length - 1;
        int line = 0;
        int charPositionInLine = 0;
        Token t = this.tokenFactory.create(source, type, text, channel, start, stop, line, charPositionInLine);
        this.builder.advanceLexer();
        return t;
    }

    public int getLine() {
        return 0;
    }

    public CharStream getInputStream() {
        CharSequence text = this.builder.getOriginalText();
        return new CharSequenceCharStream(text, text.length(), this.getSourceName());
    }

    public String getSourceName() {
        return "<unknown>";
    }

    public void setTokenFactory(TokenFactory<?> tokenFactory) {
        this.tokenFactory = tokenFactory;
    }

    public TokenFactory<?> getTokenFactory() {
        return this.tokenFactory;
    }
}

