/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.intellij.adaptor.parser;

import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.intellij.adaptor.lexer.PSIElementTypeFactory;
import org.antlr.intellij.adaptor.lexer.RuleIElementType;
import org.antlr.intellij.adaptor.lexer.TokenIElementType;
import org.antlr.intellij.adaptor.parser.SyntaxError;
import org.antlr.intellij.adaptor.parser.SyntaxErrorListener;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ANTLRParseTreeToPSIConverter
implements ParseTreeListener {
    protected final Language language;
    protected final PsiBuilder builder;
    protected List<SyntaxError> syntaxErrors;
    protected final Deque<PsiBuilder.Marker> markers = new ArrayDeque<PsiBuilder.Marker>();
    protected final List<TokenIElementType> tokenElementTypes;
    protected final List<RuleIElementType> ruleElementTypes;
    protected Map<Integer, SyntaxError> tokenToErrorMap = new HashMap<Integer, SyntaxError>();

    public ANTLRParseTreeToPSIConverter(Language language, Parser parser, PsiBuilder builder) {
        this.language = language;
        this.builder = builder;
        this.tokenElementTypes = PSIElementTypeFactory.getTokenIElementTypes(language);
        this.ruleElementTypes = PSIElementTypeFactory.getRuleIElementTypes(language);
        for (ANTLRErrorListener listener : parser.getErrorListeners()) {
            if (!(listener instanceof SyntaxErrorListener)) continue;
            this.syntaxErrors = ((SyntaxErrorListener)listener).getSyntaxErrors();
            for (SyntaxError error : this.syntaxErrors) {
                int StartIndex = error.getOffendingSymbol().getStartIndex();
                if (this.tokenToErrorMap.containsKey(StartIndex)) continue;
                this.tokenToErrorMap.put(StartIndex, error);
            }
        }
    }

    protected final Language getLanguage() {
        return this.language;
    }

    protected final PsiBuilder getBuilder() {
        return this.builder;
    }

    protected final Deque<PsiBuilder.Marker> getMarkers() {
        return this.markers;
    }

    protected final List<TokenIElementType> getTokenElementTypes() {
        return this.tokenElementTypes;
    }

    protected final List<RuleIElementType> getRuleElementTypes() {
        return this.ruleElementTypes;
    }

    public void visitTerminal(TerminalNode node) {
        this.builder.advanceLexer();
    }

    public void visitErrorNode(ErrorNode node) {
        ProgressIndicatorProvider.checkCanceled();
        Token badToken = node.getSymbol();
        boolean isConjuredToken = badToken.getTokenIndex() < 0;
        int nodeStartIndex = badToken.getStartIndex();
        SyntaxError error = this.tokenToErrorMap.get(nodeStartIndex);
        if (error != null) {
            PsiBuilder.Marker errorMarker = this.builder.mark();
            if (badToken.getStartIndex() >= 0 && badToken.getType() != -1 && !isConjuredToken) {
                this.builder.advanceLexer();
            }
            String message = String.format("%s%n", error.getMessage());
            errorMarker.error(message);
        } else if (isConjuredToken) {
            PsiBuilder.Marker errorMarker = this.builder.mark();
            errorMarker.error(badToken.getText());
        } else {
            this.builder.advanceLexer();
        }
    }

    public void enterEveryRule(ParserRuleContext ctx) {
        ProgressIndicatorProvider.checkCanceled();
        this.markers.push(this.getBuilder().mark());
    }

    public void exitEveryRule(ParserRuleContext ctx) {
        ProgressIndicatorProvider.checkCanceled();
        PsiBuilder.Marker marker = this.markers.pop();
        marker.done((IElementType)this.getRuleElementTypes().get(ctx.getRuleIndex()));
    }
}

