/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.intellij.adaptor.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.intellij.adaptor.lexer.RuleIElementType;
import org.antlr.intellij.adaptor.lexer.TokenIElementType;
import org.antlr.intellij.adaptor.psi.ANTLRPsiNode;
import org.jetbrains.annotations.NotNull;

public class Trees {
    private Trees() {
    }

    public static List<? extends PsiElement> getAncestors(PsiElement t) {
        if (t.getParent() == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiElement> ancestors = new ArrayList<PsiElement>();
        for (t = t.getParent(); t != null; t = t.getParent()) {
            ancestors.add(0, t);
        }
        return ancestors;
    }

    public static boolean isAncestorOf(PsiElement t, PsiElement u) {
        if (t == null || u == null || t.getParent() == null) {
            return false;
        }
        for (PsiElement p = u.getParent(); p != null; p = p.getParent()) {
            if (t != p) continue;
            return true;
        }
        return false;
    }

    public static ANTLRPsiNode getRoot(PsiElement t) {
        PsiFile contextOfType = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)t, PsiFile.class);
        return (ANTLRPsiNode)Trees.getChildren((PsiElement)contextOfType)[0];
    }

    public static Map<String, PsiElement> toMap(Collection<? extends PsiElement> nodes) {
        HashMap<String, PsiElement> m = new HashMap<String, PsiElement>();
        for (PsiElement psiElement : nodes) {
            m.put(psiElement.getText(), psiElement);
        }
        return m;
    }

    public static Collection<PsiElement> findAllTokenNodes(PsiElement t, int ttype) {
        return Trees.findAllNodes(t, ttype, true);
    }

    public static Collection<PsiElement> findAllRuleNodes(PsiElement t, int ruleIndex) {
        return Trees.findAllNodes(t, ruleIndex, false);
    }

    public static List<PsiElement> findAllNodes(PsiElement t, int index, boolean findTokens) {
        ArrayList<PsiElement> nodes = new ArrayList<PsiElement>();
        Trees._findAllNodes(t, index, findTokens, nodes);
        return nodes;
    }

    public static void _findAllNodes(PsiElement t, int index, boolean findTokens, List<? super PsiElement> nodes) {
        ANTLRPsiNode ctx;
        IElementType elType;
        if (findTokens && t instanceof LeafPsiElement) {
            LeafPsiElement tnode = (LeafPsiElement)t;
            elType = tnode.getNode().getElementType();
            if (elType instanceof TokenIElementType && ((TokenIElementType)elType).getANTLRTokenType() == index) {
                nodes.add((PsiElement)t);
            }
        } else if (!findTokens && t instanceof ANTLRPsiNode && (elType = (ctx = (ANTLRPsiNode)t).getNode().getElementType()) instanceof RuleIElementType && ((RuleIElementType)elType).getRuleIndex() == index) {
            nodes.add((PsiElement)t);
        }
        for (PsiElement c : t.getChildren()) {
            Trees._findAllNodes(c, index, findTokens, nodes);
        }
    }

    public static List<PsiElement> getDescendants(PsiElement t) {
        ArrayList<PsiElement> nodes = new ArrayList<PsiElement>();
        nodes.add(t);
        for (PsiElement c : t.getChildren()) {
            nodes.addAll(Trees.getDescendants(c));
        }
        return nodes;
    }

    @NotNull
    public static PsiElement[] getChildren(PsiElement t) {
        if (t == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                Trees.$$$reportNull$$$0(0);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement psiChild = t.getFirstChild();
        if (psiChild == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                Trees.$$$reportNull$$$0(1);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        while (psiChild != null) {
            if (!(psiChild instanceof PsiComment) && !(psiChild instanceof PsiWhiteSpace)) {
                result.add(psiChild);
            }
            psiChild = psiChild.getNextSibling();
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result);
        if (psiElementArray == null) {
            Trees.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    public static PsiElement getRootOfSubtreeEnclosingRegion(PsiElement t, int startCharIndex, int stopCharIndex) {
        TextRange r;
        for (PsiElement c : t.getChildren()) {
            PsiElement sub = Trees.getRootOfSubtreeEnclosingRegion(c, startCharIndex, stopCharIndex);
            if (sub == null) continue;
            return sub;
        }
        IElementType elementType = t.getNode().getElementType();
        if (elementType instanceof RuleIElementType && startCharIndex >= (r = t.getNode().getTextRange()).getStartOffset() && stopCharIndex < r.getEndOffset()) {
            return t;
        }
        return null;
    }

    public static PsiElement findNodeSuchThat(PsiElement t, Predicate<PsiElement> pred) {
        if (pred.test(t)) {
            return t;
        }
        for (PsiElement c : t.getChildren()) {
            PsiElement u = Trees.findNodeSuchThat(c, pred);
            if (u == null) continue;
            return u;
        }
        return null;
    }

    public static PsiElement createLeafFromText(Project project, Language language, PsiElement context, String text, IElementType type) {
        PsiFileFactoryImpl factory = (PsiFileFactoryImpl)PsiFileFactory.getInstance((Project)project);
        PsiElement el = factory.createElementFromText(text, language, type, context);
        if (el == null) {
            return null;
        }
        return PsiTreeUtil.getDeepestFirst((PsiElement)el);
    }

    public static void replacePsiFileFromText(Project project, Language language, final PsiFile psiFile, String text) {
        final PsiFile newPsiFile = Trees.createFile(project, language, text);
        if (newPsiFile == null) {
            return;
        }
        WriteCommandAction setTextAction = new WriteCommandAction(project, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                psiFile.deleteChildRange(psiFile.getFirstChild(), psiFile.getLastChild());
                psiFile.addRange(newPsiFile.getFirstChild(), newPsiFile.getLastChild());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/antlr/intellij/adaptor/psi/Trees$1", "run"));
            }
        };
        setTextAction.execute();
    }

    public static PsiFile createFile(Project project, Language language, String text) {
        LanguageFileType ftype = language.getAssociatedFileType();
        if (ftype == null) {
            return null;
        }
        String ext = ftype.getDefaultExtension();
        String fileName = "___fubar___." + ext;
        PsiFileFactoryImpl factory = (PsiFileFactoryImpl)PsiFileFactory.getInstance((Project)project);
        return factory.createFileFromText(fileName, language, (CharSequence)text, false, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/antlr/intellij/adaptor/psi/Trees", "getChildren"));
    }

    public static interface Predicate<T> {
        public boolean test(T var1);
    }
}

