/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.intellij.adaptor.xpath;

import com.intellij.lang.Language;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.intellij.adaptor.lexer.PSIElementTypeFactory;
import org.antlr.intellij.adaptor.lexer.RuleIElementType;
import org.antlr.intellij.adaptor.lexer.TokenIElementType;
import org.antlr.intellij.adaptor.psi.Trees;
import org.antlr.intellij.adaptor.xpath.XPathElement;
import org.antlr.intellij.adaptor.xpath.XPathLexerErrorListener;
import org.antlr.intellij.adaptor.xpath.XPathRuleAnywhereElement;
import org.antlr.intellij.adaptor.xpath.XPathRuleElement;
import org.antlr.intellij.adaptor.xpath.XPathTokenAnywhereElement;
import org.antlr.intellij.adaptor.xpath.XPathTokenElement;
import org.antlr.intellij.adaptor.xpath.XPathWildcardAnywhereElement;
import org.antlr.intellij.adaptor.xpath.XPathWildcardElement;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.tree.xpath.XPathLexer;
import org.jetbrains.annotations.NotNull;

public class XPath {
    public static final String WILDCARD = "*";
    public static final String NOT = "!";
    private final List<TokenIElementType> tokenElementTypes;
    private final List<RuleIElementType> ruleElementTypes;
    private final Map<String, Integer> ruleIndexes;
    private final Map<String, Integer> tokenTypes;
    protected String path;

    public XPath(Language language, String path) {
        this.path = path;
        this.tokenElementTypes = PSIElementTypeFactory.getTokenIElementTypes(language);
        this.ruleElementTypes = PSIElementTypeFactory.getRuleIElementTypes(language);
        this.ruleIndexes = PSIElementTypeFactory.getRuleNameToIndexMap(language);
        this.tokenTypes = PSIElementTypeFactory.getTokenNameToTypeMap(language);
    }

    public XPathElement[] split(String path) {
        ANTLRInputStream in;
        try {
            in = new ANTLRInputStream((Reader)new StringReader(path));
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not read path: " + path, ioe);
        }
        XPathLexer lexer = new XPathLexer((CharStream)in){

            public void recover(LexerNoViableAltException e) {
                throw e;
            }
        };
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new XPathLexerErrorListener());
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        try {
            tokenStream.fill();
        }
        catch (LexerNoViableAltException e) {
            int pos = lexer.getCharPositionInLine();
            String msg = "Invalid tokens or characters at index " + pos + " in path '" + path + "'";
            throw new IllegalArgumentException(msg, e);
        }
        List tokens = tokenStream.getTokens();
        ArrayList<XPathElement> elements = new ArrayList<XPathElement>();
        int n = tokens.size();
        int i = 0;
        block9: while (i < n) {
            Token el = (Token)tokens.get(i);
            Token next = null;
            switch (el.getType()) {
                case 3: 
                case 4: {
                    boolean invert;
                    boolean anywhere = el.getType() == 3;
                    next = (Token)tokens.get(++i);
                    boolean bl = invert = next.getType() == 6;
                    if (invert) {
                        next = (Token)tokens.get(++i);
                    }
                    XPathElement pathElement = this.getXPathElement(next, anywhere);
                    pathElement.invert = invert;
                    elements.add(pathElement);
                    ++i;
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    elements.add(this.getXPathElement(el, false));
                    ++i;
                    break;
                }
                case -1: {
                    break block9;
                }
                default: {
                    throw new IllegalArgumentException("Unknowth path element " + el);
                }
            }
        }
        return elements.toArray(new XPathElement[0]);
    }

    protected XPathElement getXPathElement(Token wordToken, boolean anywhere) {
        if (wordToken.getType() == -1) {
            throw new IllegalArgumentException("Missing path element at end of path");
        }
        String word = wordToken.getText();
        Integer ttype = this.tokenTypes.get(word);
        Integer ruleIndex = this.ruleIndexes.get(word);
        switch (wordToken.getType()) {
            case 5: {
                return anywhere ? new XPathWildcardAnywhereElement() : new XPathWildcardElement();
            }
            case 1: 
            case 8: {
                if (ttype == null || ttype == 0) {
                    throw new IllegalArgumentException(word + " at index " + wordToken.getStartIndex() + " isn't a valid token name");
                }
                return anywhere ? new XPathTokenAnywhereElement(word, ttype) : new XPathTokenElement(word, ttype);
            }
        }
        if (ruleIndex == null || ruleIndex == -1) {
            throw new IllegalArgumentException(word + " at index " + wordToken.getStartIndex() + " isn't a valid rule name");
        }
        return anywhere ? new XPathRuleAnywhereElement(word, ruleIndex) : new XPathRuleElement(word, ruleIndex);
    }

    public static Collection<? extends PsiElement> findAll(Language language, PsiElement tree, String xpath) {
        XPath p = new XPath(language, xpath);
        XPathElement[] elements = p.split(xpath);
        return p.evaluate(tree, elements);
    }

    public Collection<? extends PsiElement> evaluate(PsiElement t, XPathElement[] elements) {
        if (t == null) {
            return Collections.emptyList();
        }
        if (t instanceof PsiFile) {
            t = Trees.getChildren(t)[0];
        }
        DummyRoot dummyRoot = new DummyRoot(t);
        Set<DummyRoot> work = Collections.singleton(dummyRoot);
        for (int i = 0; i < elements.length; ++i) {
            LinkedHashSet<DummyRoot> next = new LinkedHashSet<DummyRoot>();
            for (PsiElement psiElement : work) {
                if (psiElement.getChildren().length <= 0) continue;
                Collection<PsiElement> matching = elements[i].evaluate(psiElement);
                next.addAll(matching);
            }
            work = next;
        }
        return work;
    }

    public static class DummyRoot
    extends CompositePsiElement {
        public final PsiElement child;

        public DummyRoot(PsiElement child) {
            super(GeneratedParserUtilBase.DUMMY_BLOCK);
            this.child = child;
        }

        @NotNull
        public PsiElement[] getChildren() {
            PsiElement[] psiElementArray = new PsiElement[]{this.child};
            if (psiElementArray == null) {
                DummyRoot.$$$reportNull$$$0(0);
            }
            return psiElementArray;
        }

        @NotNull
        public PsiReference[] getReferences() {
            if (PsiReference.EMPTY_ARRAY == null) {
                DummyRoot.$$$reportNull$$$0(1);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        @NotNull
        public Language getLanguage() {
            Language language = this.getParent().getLanguage();
            if (language == null) {
                DummyRoot.$$$reportNull$$$0(2);
            }
            return language;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/antlr/intellij/adaptor/xpath/XPath$DummyRoot";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferences";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

