// $ANTLR 3.5-rc-2 org\\antlr\\v4\\parse\\ANTLRLexer.g 2012-12-16 17:30:44

/*
 [The "BSD licence"]
 Copyright (c) 2005-2009 Terence Parr
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:
 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.
 3. The name of the author may not be used to endorse or promote products
    derived from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
package org.antlr.v4.parse;
import org.antlr.v4.tool.*;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/** Read in an ANTLR grammar and build an AST.  Try not to do
 *  any actions, just build the tree.
 *
 *  The phases are:
 *
 *		A3Lexer.g (this file)
 *              A3Parser.g
 *              A3Verify.g (derived from A3Walker.g)
 *		assign.types.g
 *		define.g
 *		buildnfa.g
 *		antlr.print.g (optional)
 *		codegen.g
 *
 *  Terence Parr
 *  University of San Francisco
 *  2005
 *  Jim Idle (this v3 grammar)
 *  Temporal Wave LLC
 *  2009
 */
@SuppressWarnings("all")
public class ANTLRLexer extends Lexer {
	public static final int EOF=-1;
	public static final int ACTION=4;
	public static final int ACTION_CHAR_LITERAL=5;
	public static final int ACTION_ESC=6;
	public static final int ACTION_STRING_LITERAL=7;
	public static final int ARG_ACTION=8;
	public static final int ARG_OR_CHARSET=9;
	public static final int ASSIGN=10;
	public static final int AT=11;
	public static final int CATCH=12;
	public static final int COLON=13;
	public static final int COLONCOLON=14;
	public static final int COMMA=15;
	public static final int COMMENT=16;
	public static final int DOC_COMMENT=17;
	public static final int DOLLAR=18;
	public static final int DOT=19;
	public static final int ERRCHAR=20;
	public static final int ESC_SEQ=21;
	public static final int FINALLY=22;
	public static final int FRAGMENT=23;
	public static final int GRAMMAR=24;
	public static final int GT=25;
	public static final int HEX_DIGIT=26;
	public static final int ID=27;
	public static final int IMPORT=28;
	public static final int INT=29;
	public static final int LEXER=30;
	public static final int LEXER_CHAR_SET=31;
	public static final int LOCALS=32;
	public static final int LPAREN=33;
	public static final int LT=34;
	public static final int MODE=35;
	public static final int NESTED_ACTION=36;
	public static final int NLCHARS=37;
	public static final int NOT=38;
	public static final int NameChar=39;
	public static final int NameStartChar=40;
	public static final int OPTIONS=41;
	public static final int OR=42;
	public static final int PARSER=43;
	public static final int PLUS=44;
	public static final int PLUS_ASSIGN=45;
	public static final int POUND=46;
	public static final int PRIVATE=47;
	public static final int PROTECTED=48;
	public static final int PUBLIC=49;
	public static final int QUESTION=50;
	public static final int RANGE=51;
	public static final int RARROW=52;
	public static final int RBRACE=53;
	public static final int RETURNS=54;
	public static final int RPAREN=55;
	public static final int RULE_REF=56;
	public static final int SEMI=57;
	public static final int SEMPRED=58;
	public static final int SRC=59;
	public static final int STAR=60;
	public static final int STRING_LITERAL=61;
	public static final int SYNPRED=62;
	public static final int THROWS=63;
	public static final int TOKENS_SPEC=64;
	public static final int TOKEN_REF=65;
	public static final int TREE_GRAMMAR=66;
	public static final int UNICODE_ESC=67;
	public static final int WS=68;
	public static final int WSCHARS=69;
	public static final int WSNLCHARS=70;

	    public CommonTokenStream tokens; // track stream we push to; need for context info
	    public boolean isLexerRule = false;

		public void grammarError(ErrorType etype, org.antlr.runtime.Token token, Object... args) { }

		/** scan backwards from current point in this.tokens list
		 *  looking for the start of the rule or subrule.
		 *  Return token or null if for some reason we can't find the start.
		 */
		public Token getRuleOrSubruleStartToken() {
		    if ( tokens==null ) return null;
			int i = tokens.index();
	        int n = tokens.size();
	        if ( i>=n ) i = n-1; // seems index == n as we lex
			while ( i>=0 && i<n) {
				int ttype = tokens.get(i).getType();
				if ( ttype == LPAREN || ttype == TOKEN_REF || ttype == RULE_REF ) {
					return tokens.get(i);
				}
				i--;
			}
			return null;
		}


	// delegates
	// delegators
	public Lexer[] getDelegates() {
		return new Lexer[] {};
	}

	public ANTLRLexer() {} 
	public ANTLRLexer(CharStream input) {
		this(input, new RecognizerSharedState());
	}
	public ANTLRLexer(CharStream input, RecognizerSharedState state) {
		super(input,state);
	}
	@Override public String getGrammarFileName() { return "org\\antlr\\v4\\parse\\ANTLRLexer.g"; }

	// $ANTLR start "DOC_COMMENT"
	public final void mDOC_COMMENT() throws RecognitionException {
		try {
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:189:22: ()
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:189:24: 
			{
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DOC_COMMENT"

	// $ANTLR start "COMMENT"
	public final void mCOMMENT() throws RecognitionException {
		try {
			int _type = COMMENT;
			int _channel = DEFAULT_TOKEN_CHANNEL;


				// Record the start line and offsets as if we need to report an
				// unterminated comment, then we want to show the start of the comment
				// we think is broken, not the end, where people will have to try and work
				// it out themselves.
				//
				int startLine = state.tokenStartLine;
				int offset    = getCharPositionInLine();

			// org\\antlr\\v4\\parse\\ANTLRLexer.g:201:5: ( '/' ( '/' ( ( ' $ANTLR' )=> ' $ANTLR' SRC | (~ ( NLCHARS ) )* ) | '*' ({...}? => '*' |{...}? =>) ({...}? . )* ( '*/' |) |) )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:204:7: '/' ( '/' ( ( ' $ANTLR' )=> ' $ANTLR' SRC | (~ ( NLCHARS ) )* ) | '*' ({...}? => '*' |{...}? =>) ({...}? . )* ( '*/' |) |)
			{
			match('/'); if (state.failed) return;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:206:7: ( '/' ( ( ' $ANTLR' )=> ' $ANTLR' SRC | (~ ( NLCHARS ) )* ) | '*' ({...}? => '*' |{...}? =>) ({...}? . )* ( '*/' |) |)
			int alt6=3;
			switch ( input.LA(1) ) {
			case '/':
				{
				alt6=1;
				}
				break;
			case '*':
				{
				alt6=2;
				}
				break;
			default:
				alt6=3;
			}
			switch (alt6) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:212:11: '/' ( ( ' $ANTLR' )=> ' $ANTLR' SRC | (~ ( NLCHARS ) )* )
					{
					match('/'); if (state.failed) return;
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:213:13: ( ( ' $ANTLR' )=> ' $ANTLR' SRC | (~ ( NLCHARS ) )* )
					int alt2=2;
					alt2 = dfa2.predict(input);
					switch (alt2) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRLexer.g:214:17: ( ' $ANTLR' )=> ' $ANTLR' SRC
							{
							match(" $ANTLR"); if (state.failed) return;

							mSRC(); if (state.failed) return;

							}
							break;
						case 2 :
							// org\\antlr\\v4\\parse\\ANTLRLexer.g:215:17: (~ ( NLCHARS ) )*
							{
							// org\\antlr\\v4\\parse\\ANTLRLexer.g:215:17: (~ ( NLCHARS ) )*
							loop1:
							while (true) {
								int alt1=2;
								int LA1_0 = input.LA(1);
								if ( ((LA1_0 >= '\u0000' && LA1_0 <= '\t')||(LA1_0 >= '\u000B' && LA1_0 <= '\f')||(LA1_0 >= '\u000E' && LA1_0 <= '\uFFFF')) ) {
									alt1=1;
								}

								switch (alt1) {
								case 1 :
									// org\\antlr\\v4\\parse\\ANTLRLexer.g:
									{
									if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '\t')||(input.LA(1) >= '\u000B' && input.LA(1) <= '\f')||(input.LA(1) >= '\u000E' && input.LA(1) <= '\uFFFF') ) {
										input.consume();
										state.failed=false;
									}
									else {
										if (state.backtracking>0) {state.failed=true; return;}
										MismatchedSetException mse = new MismatchedSetException(null,input);
										recover(mse);
										throw mse;
									}
									}
									break;

								default :
									break loop1;
								}
							}

							}
							break;

					}

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:222:12: '*' ({...}? => '*' |{...}? =>) ({...}? . )* ( '*/' |)
					{
					match('*'); if (state.failed) return;
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:222:16: ({...}? => '*' |{...}? =>)
					int alt3=2;
					int LA3_0 = input.LA(1);
					if ( (LA3_0=='*') && ((( input.LA(2) != '/')||( true )))) {
						int LA3_1 = input.LA(2);
						if ( (( input.LA(2) != '/')) ) {
							alt3=1;
						}
						else if ( (( true )) ) {
							alt3=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 3, 1, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					switch (alt3) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRLexer.g:223:17: {...}? => '*'
							{
							if ( !(( input.LA(2) != '/')) ) {
								if (state.backtracking>0) {state.failed=true; return;}
								throw new FailedPredicateException(input, "COMMENT", " input.LA(2) != '/'");
							}
							match('*'); if (state.failed) return;
							if ( state.backtracking==0 ) { _type = DOC_COMMENT; }
							}
							break;
						case 2 :
							// org\\antlr\\v4\\parse\\ANTLRLexer.g:224:17: {...}? =>
							{
							if ( !(( true )) ) {
								if (state.backtracking>0) {state.failed=true; return;}
								throw new FailedPredicateException(input, "COMMENT", " true ");
							}
							}
							break;

					}

					// org\\antlr\\v4\\parse\\ANTLRLexer.g:229:16: ({...}? . )*
					loop4:
					while (true) {
						int alt4=2;
						int LA4_0 = input.LA(1);
						if ( (LA4_0=='*') ) {
							switch ( input.LA(2) ) {
							case '/':
								{
								int LA4_4 = input.LA(3);
								if ( ((    !(input.LA(1) == '*' && input.LA(2) == '/') )) ) {
									alt4=1;
								}

								}
								break;
							default:
								alt4=1;
								break;
							}
						}
						else if ( ((LA4_0 >= '\u0000' && LA4_0 <= ')')||(LA4_0 >= '+' && LA4_0 <= '\uFFFF')) ) {
							alt4=1;
						}

						switch (alt4) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRLexer.g:233:20: {...}? .
							{
							if ( !((    !(input.LA(1) == '*' && input.LA(2) == '/') )) ) {
								if (state.backtracking>0) {state.failed=true; return;}
								throw new FailedPredicateException(input, "COMMENT", "    !(input.LA(1) == '*' && input.LA(2) == '/') ");
							}
							matchAny(); if (state.failed) return;
							}
							break;

						default :
							break loop4;
						}
					}

					// org\\antlr\\v4\\parse\\ANTLRLexer.g:240:13: ( '*/' |)
					int alt5=2;
					switch ( input.LA(1) ) {
					case '*':
						{
						alt5=1;
						}
						break;
					default:
						alt5=2;
					}
					switch (alt5) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRLexer.g:246:18: '*/'
							{
							match("*/"); if (state.failed) return;

							}
							break;
						case 2 :
							// org\\antlr\\v4\\parse\\ANTLRLexer.g:250:18: 
							{
							if ( state.backtracking==0 ) {
							                   // ErrorManager.msg(Msg.UNTERMINATED_DOC_COMMENT, startLine, offset, state.tokenStartCharPositionInLine, startLine, offset, state.tokenStartCharPositionInLine, (Object)null);
							                 }
							}
							break;

					}

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:258:12: 
					{
					if ( state.backtracking==0 ) {
					           	 // TODO: Insert error message relative to comment start
					             //
					           }
					}
					break;

			}

			if ( state.backtracking==0 ) {
			         // Unless we had a documentation comment, then we do not wish to
			         // pass the comments in to the parser. If you are writing a formatter
			         // then you will want to preserve the comments off channel, but could
			         // just skip and save token space if not.
			         //
			         if (_type != DOC_COMMENT) {

			             _channel=2;  // Comments are on channel 2
			         }
			       }
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COMMENT"

	// $ANTLR start "ARG_OR_CHARSET"
	public final void mARG_OR_CHARSET() throws RecognitionException {
		try {
			int _type = ARG_OR_CHARSET;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:278:5: ({...}? => LEXER_CHAR_SET |{...}? => ARG_ACTION )
			int alt7=2;
			int LA7_0 = input.LA(1);
			if ( (LA7_0=='[') && (((!isLexerRule)||(isLexerRule)))) {
				int LA7_1 = input.LA(2);
				if ( ((isLexerRule)) ) {
					alt7=1;
				}
				else if ( ((!isLexerRule)) ) {
					alt7=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 7, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			switch (alt7) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:278:9: {...}? => LEXER_CHAR_SET
					{
					if ( !((isLexerRule)) ) {
						if (state.backtracking>0) {state.failed=true; return;}
						throw new FailedPredicateException(input, "ARG_OR_CHARSET", "isLexerRule");
					}
					mLEXER_CHAR_SET(); if (state.failed) return;

					if ( state.backtracking==0 ) {_type=LEXER_CHAR_SET;}
					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:279:9: {...}? => ARG_ACTION
					{
					if ( !((!isLexerRule)) ) {
						if (state.backtracking>0) {state.failed=true; return;}
						throw new FailedPredicateException(input, "ARG_OR_CHARSET", "!isLexerRule");
					}
					mARG_ACTION(); if (state.failed) return;

					if ( state.backtracking==0 ) {
					        _type=ARG_ACTION;
					        // Set the token text to our gathered string minus outer [ ]
					        String t = getText();
					        t = t.substring(1,t.length()-1);
					        setText(t);
					        }
					}
					break;

			}
			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ARG_OR_CHARSET"

	// $ANTLR start "LEXER_CHAR_SET"
	public final void mLEXER_CHAR_SET() throws RecognitionException {
		try {
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:291:5: ( '[' ( '\\\\]' | '\\\\' ~ ']' |~ ( '\\\\' | ']' ) )* ']' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:291:9: '[' ( '\\\\]' | '\\\\' ~ ']' |~ ( '\\\\' | ']' ) )* ']'
			{
			match('['); if (state.failed) return;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:291:13: ( '\\\\]' | '\\\\' ~ ']' |~ ( '\\\\' | ']' ) )*
			loop8:
			while (true) {
				int alt8=4;
				int LA8_0 = input.LA(1);
				if ( (LA8_0=='\\') ) {
					int LA8_2 = input.LA(2);
					if ( (LA8_2==']') ) {
						alt8=1;
					}
					else if ( ((LA8_2 >= '\u0000' && LA8_2 <= '\\')||(LA8_2 >= '^' && LA8_2 <= '\uFFFF')) ) {
						alt8=2;
					}

				}
				else if ( ((LA8_0 >= '\u0000' && LA8_0 <= '[')||(LA8_0 >= '^' && LA8_0 <= '\uFFFF')) ) {
					alt8=3;
				}

				switch (alt8) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:291:14: '\\\\]'
					{
					match("\\]"); if (state.failed) return;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:291:20: '\\\\' ~ ']'
					{
					match('\\'); if (state.failed) return;
					if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '\\')||(input.LA(1) >= '^' && input.LA(1) <= '\uFFFF') ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:291:30: ~ ( '\\\\' | ']' )
					{
					if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '[')||(input.LA(1) >= '^' && input.LA(1) <= '\uFFFF') ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					break loop8;
				}
			}

			match(']'); if (state.failed) return;
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LEXER_CHAR_SET"

	// $ANTLR start "ARG_ACTION"
	public final void mARG_ACTION() throws RecognitionException {
		try {
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:304:2: ( '[' ( ARG_ACTION | ( '\"' )=> ACTION_STRING_LITERAL | ( '\\'' )=> ACTION_CHAR_LITERAL |~ ( '[' | ']' ) )* ']' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:304:4: '[' ( ARG_ACTION | ( '\"' )=> ACTION_STRING_LITERAL | ( '\\'' )=> ACTION_CHAR_LITERAL |~ ( '[' | ']' ) )* ']'
			{
			match('['); if (state.failed) return;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:305:10: ( ARG_ACTION | ( '\"' )=> ACTION_STRING_LITERAL | ( '\\'' )=> ACTION_CHAR_LITERAL |~ ( '[' | ']' ) )*
			loop9:
			while (true) {
				int alt9=5;
				int LA9_0 = input.LA(1);
				if ( (LA9_0=='[') ) {
					alt9=1;
				}
				else if ( (LA9_0=='\"') ) {
					int LA9_3 = input.LA(2);
					if ( (synpred2_ANTLRLexer()) ) {
						alt9=2;
					}
					else if ( (true) ) {
						alt9=4;
					}

				}
				else if ( (LA9_0=='\'') ) {
					int LA9_4 = input.LA(2);
					if ( (synpred3_ANTLRLexer()) ) {
						alt9=3;
					}
					else if ( (true) ) {
						alt9=4;
					}

				}
				else if ( ((LA9_0 >= '\u0000' && LA9_0 <= '!')||(LA9_0 >= '#' && LA9_0 <= '&')||(LA9_0 >= '(' && LA9_0 <= 'Z')||LA9_0=='\\'||(LA9_0 >= '^' && LA9_0 <= '\uFFFF')) ) {
					alt9=4;
				}

				switch (alt9) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:306:14: ARG_ACTION
					{
					mARG_ACTION(); if (state.failed) return;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:308:14: ( '\"' )=> ACTION_STRING_LITERAL
					{
					mACTION_STRING_LITERAL(); if (state.failed) return;

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:310:14: ( '\\'' )=> ACTION_CHAR_LITERAL
					{
					mACTION_CHAR_LITERAL(); if (state.failed) return;

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:312:14: ~ ( '[' | ']' )
					{
					if ( (input.LA(1) >= '\u0000' && input.LA(1) <= 'Z')||input.LA(1)=='\\'||(input.LA(1) >= '^' && input.LA(1) <= '\uFFFF') ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					break loop9;
				}
			}

			match(']'); if (state.failed) return;
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ARG_ACTION"

	// $ANTLR start "ACTION"
	public final void mACTION() throws RecognitionException {
		try {
			int _type = ACTION;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:330:2: ( NESTED_ACTION ( '?' ( ( ( WSNLCHARS )* '=>' )=> ( WSNLCHARS )* '=>' )? )? )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:330:4: NESTED_ACTION ( '?' ( ( ( WSNLCHARS )* '=>' )=> ( WSNLCHARS )* '=>' )? )?
			{
			mNESTED_ACTION(); if (state.failed) return;

			// org\\antlr\\v4\\parse\\ANTLRLexer.g:331:3: ( '?' ( ( ( WSNLCHARS )* '=>' )=> ( WSNLCHARS )* '=>' )? )?
			int alt12=2;
			switch ( input.LA(1) ) {
				case '?':
					{
					alt12=1;
					}
					break;
			}
			switch (alt12) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:331:5: '?' ( ( ( WSNLCHARS )* '=>' )=> ( WSNLCHARS )* '=>' )?
					{
					match('?'); if (state.failed) return;
					if ( state.backtracking==0 ) {_type = SEMPRED;}
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:332:4: ( ( ( WSNLCHARS )* '=>' )=> ( WSNLCHARS )* '=>' )?
					int alt11=2;
					int LA11_0 = input.LA(1);
					if ( ((LA11_0 >= '\t' && LA11_0 <= '\n')||(LA11_0 >= '\f' && LA11_0 <= '\r')||LA11_0==' ') && (synpred4_ANTLRLexer())) {
						alt11=1;
					}
					else if ( (LA11_0=='=') && (synpred4_ANTLRLexer())) {
						alt11=1;
					}
					switch (alt11) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRLexer.g:332:6: ( ( WSNLCHARS )* '=>' )=> ( WSNLCHARS )* '=>'
							{
							// org\\antlr\\v4\\parse\\ANTLRLexer.g:332:27: ( WSNLCHARS )*
							loop10:
							while (true) {
								int alt10=2;
								switch ( input.LA(1) ) {
								case '\t':
								case '\n':
								case '\f':
								case '\r':
								case ' ':
									{
									alt10=1;
									}
									break;
								}
								switch (alt10) {
								case 1 :
									// org\\antlr\\v4\\parse\\ANTLRLexer.g:
									{
									if ( (input.LA(1) >= '\t' && input.LA(1) <= '\n')||(input.LA(1) >= '\f' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
										input.consume();
										state.failed=false;
									}
									else {
										if (state.backtracking>0) {state.failed=true; return;}
										MismatchedSetException mse = new MismatchedSetException(null,input);
										recover(mse);
										throw mse;
									}
									}
									break;

								default :
									break loop10;
								}
							}

							match("=>"); if (state.failed) return;

							if ( state.backtracking==0 ) {
											Token t = new CommonToken(input, state.type, state.channel, state.tokenStartCharIndex, getCharIndex()-1);
											t.setLine(state.tokenStartLine);
											t.setText(state.text);
											t.setCharPositionInLine(state.tokenStartCharPositionInLine);
											grammarError(ErrorType.V3_GATED_SEMPRED, t);
											}
							}
							break;

					}

					}
					break;

			}

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ACTION"

	// $ANTLR start "NESTED_ACTION"
	public final void mNESTED_ACTION() throws RecognitionException {
		try {


				// Record the start line and offsets as if we need to report an
				// unterminated block, then we want to show the start of the comment
				// we think is broken, not the end, where people will have to try and work
				// it out themselves.
				//
				int startLine = getLine();
				int offset    = getCharPositionInLine();

			// org\\antlr\\v4\\parse\\ANTLRLexer.g:368:5: ( '{' ( NESTED_ACTION | ACTION_CHAR_LITERAL | COMMENT | ACTION_STRING_LITERAL | ACTION_ESC |~ ( '\\\\' | '\"' | '\\'' | '/' | '{' | '}' ) )* ( '}' |) )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:370:4: '{' ( NESTED_ACTION | ACTION_CHAR_LITERAL | COMMENT | ACTION_STRING_LITERAL | ACTION_ESC |~ ( '\\\\' | '\"' | '\\'' | '/' | '{' | '}' ) )* ( '}' |)
			{
			match('{'); if (state.failed) return;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:371:7: ( NESTED_ACTION | ACTION_CHAR_LITERAL | COMMENT | ACTION_STRING_LITERAL | ACTION_ESC |~ ( '\\\\' | '\"' | '\\'' | '/' | '{' | '}' ) )*
			loop13:
			while (true) {
				int alt13=7;
				int LA13_0 = input.LA(1);
				if ( (LA13_0=='{') ) {
					alt13=1;
				}
				else if ( (LA13_0=='\'') ) {
					alt13=2;
				}
				else if ( (LA13_0=='/') ) {
					alt13=3;
				}
				else if ( (LA13_0=='\"') ) {
					alt13=4;
				}
				else if ( (LA13_0=='\\') ) {
					alt13=5;
				}
				else if ( ((LA13_0 >= '\u0000' && LA13_0 <= '!')||(LA13_0 >= '#' && LA13_0 <= '&')||(LA13_0 >= '(' && LA13_0 <= '.')||(LA13_0 >= '0' && LA13_0 <= '[')||(LA13_0 >= ']' && LA13_0 <= 'z')||LA13_0=='|'||(LA13_0 >= '~' && LA13_0 <= '\uFFFF')) ) {
					alt13=6;
				}

				switch (alt13) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:386:8: NESTED_ACTION
					{
					mNESTED_ACTION(); if (state.failed) return;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:390:11: ACTION_CHAR_LITERAL
					{
					mACTION_CHAR_LITERAL(); if (state.failed) return;

					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:395:11: COMMENT
					{
					mCOMMENT(); if (state.failed) return;

					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:399:11: ACTION_STRING_LITERAL
					{
					mACTION_STRING_LITERAL(); if (state.failed) return;

					}
					break;
				case 5 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:403:8: ACTION_ESC
					{
					mACTION_ESC(); if (state.failed) return;

					}
					break;
				case 6 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:408:8: ~ ( '\\\\' | '\"' | '\\'' | '/' | '{' | '}' )
					{
					if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '!')||(input.LA(1) >= '#' && input.LA(1) <= '&')||(input.LA(1) >= '(' && input.LA(1) <= '.')||(input.LA(1) >= '0' && input.LA(1) <= '[')||(input.LA(1) >= ']' && input.LA(1) <= 'z')||input.LA(1)=='|'||(input.LA(1) >= '~' && input.LA(1) <= '\uFFFF') ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					break loop13;
				}
			}

			// org\\antlr\\v4\\parse\\ANTLRLexer.g:412:2: ( '}' |)
			int alt14=2;
			switch ( input.LA(1) ) {
			case '}':
				{
				alt14=1;
				}
				break;
			default:
				alt14=2;
			}
			switch (alt14) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:415:6: '}'
					{
					match('}'); if (state.failed) return;
					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:420:6: 
					{
					if ( state.backtracking==0 ) {
						        // TODO: Report imbalanced {}
						        System.out.println("Block starting  at line " + startLine + " offset " + (offset+1) + " contains imbalanced {} or is missing a }");
						    }
					}
					break;

			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NESTED_ACTION"

	// $ANTLR start "OPTIONS"
	public final void mOPTIONS() throws RecognitionException {
		try {
			int _type = OPTIONS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:437:14: ( 'options' ( WSNLCHARS )* '{' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:437:16: 'options' ( WSNLCHARS )* '{'
			{
			match("options"); if (state.failed) return;

			// org\\antlr\\v4\\parse\\ANTLRLexer.g:437:26: ( WSNLCHARS )*
			loop15:
			while (true) {
				int alt15=2;
				switch ( input.LA(1) ) {
				case '\t':
				case '\n':
				case '\f':
				case '\r':
				case ' ':
					{
					alt15=1;
					}
					break;
				}
				switch (alt15) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:
					{
					if ( (input.LA(1) >= '\t' && input.LA(1) <= '\n')||(input.LA(1) >= '\f' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					break loop15;
				}
			}

			match('{'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "OPTIONS"

	// $ANTLR start "TOKENS_SPEC"
	public final void mTOKENS_SPEC() throws RecognitionException {
		try {
			int _type = TOKENS_SPEC;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:438:14: ( 'tokens' ( WSNLCHARS )* '{' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:438:16: 'tokens' ( WSNLCHARS )* '{'
			{
			match("tokens"); if (state.failed) return;

			// org\\antlr\\v4\\parse\\ANTLRLexer.g:438:26: ( WSNLCHARS )*
			loop16:
			while (true) {
				int alt16=2;
				switch ( input.LA(1) ) {
				case '\t':
				case '\n':
				case '\f':
				case '\r':
				case ' ':
					{
					alt16=1;
					}
					break;
				}
				switch (alt16) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:
					{
					if ( (input.LA(1) >= '\t' && input.LA(1) <= '\n')||(input.LA(1) >= '\f' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					break loop16;
				}
			}

			match('{'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "TOKENS_SPEC"

	// $ANTLR start "IMPORT"
	public final void mIMPORT() throws RecognitionException {
		try {
			int _type = IMPORT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:440:14: ( 'import' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:440:16: 'import'
			{
			match("import"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "IMPORT"

	// $ANTLR start "FRAGMENT"
	public final void mFRAGMENT() throws RecognitionException {
		try {
			int _type = FRAGMENT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:441:14: ( 'fragment' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:441:16: 'fragment'
			{
			match("fragment"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FRAGMENT"

	// $ANTLR start "LEXER"
	public final void mLEXER() throws RecognitionException {
		try {
			int _type = LEXER;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:442:14: ( 'lexer' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:442:16: 'lexer'
			{
			match("lexer"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LEXER"

	// $ANTLR start "PARSER"
	public final void mPARSER() throws RecognitionException {
		try {
			int _type = PARSER;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:443:14: ( 'parser' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:443:16: 'parser'
			{
			match("parser"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PARSER"

	// $ANTLR start "GRAMMAR"
	public final void mGRAMMAR() throws RecognitionException {
		try {
			int _type = GRAMMAR;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:444:14: ( 'grammar' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:444:16: 'grammar'
			{
			match("grammar"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "GRAMMAR"

	// $ANTLR start "TREE_GRAMMAR"
	public final void mTREE_GRAMMAR() throws RecognitionException {
		try {
			int _type = TREE_GRAMMAR;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:445:14: ( 'tree' ( WSNLCHARS )* 'grammar' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:445:16: 'tree' ( WSNLCHARS )* 'grammar'
			{
			match("tree"); if (state.failed) return;

			// org\\antlr\\v4\\parse\\ANTLRLexer.g:445:23: ( WSNLCHARS )*
			loop17:
			while (true) {
				int alt17=2;
				switch ( input.LA(1) ) {
				case '\t':
				case '\n':
				case '\f':
				case '\r':
				case ' ':
					{
					alt17=1;
					}
					break;
				}
				switch (alt17) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:
					{
					if ( (input.LA(1) >= '\t' && input.LA(1) <= '\n')||(input.LA(1) >= '\f' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					break loop17;
				}
			}

			match("grammar"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "TREE_GRAMMAR"

	// $ANTLR start "PROTECTED"
	public final void mPROTECTED() throws RecognitionException {
		try {
			int _type = PROTECTED;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:446:14: ( 'protected' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:446:16: 'protected'
			{
			match("protected"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PROTECTED"

	// $ANTLR start "PUBLIC"
	public final void mPUBLIC() throws RecognitionException {
		try {
			int _type = PUBLIC;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:447:14: ( 'public' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:447:16: 'public'
			{
			match("public"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PUBLIC"

	// $ANTLR start "PRIVATE"
	public final void mPRIVATE() throws RecognitionException {
		try {
			int _type = PRIVATE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:448:14: ( 'private' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:448:16: 'private'
			{
			match("private"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PRIVATE"

	// $ANTLR start "RETURNS"
	public final void mRETURNS() throws RecognitionException {
		try {
			int _type = RETURNS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:449:14: ( 'returns' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:449:16: 'returns'
			{
			match("returns"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RETURNS"

	// $ANTLR start "LOCALS"
	public final void mLOCALS() throws RecognitionException {
		try {
			int _type = LOCALS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:450:14: ( 'locals' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:450:16: 'locals'
			{
			match("locals"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LOCALS"

	// $ANTLR start "THROWS"
	public final void mTHROWS() throws RecognitionException {
		try {
			int _type = THROWS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:451:14: ( 'throws' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:451:16: 'throws'
			{
			match("throws"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "THROWS"

	// $ANTLR start "CATCH"
	public final void mCATCH() throws RecognitionException {
		try {
			int _type = CATCH;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:452:14: ( 'catch' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:452:16: 'catch'
			{
			match("catch"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CATCH"

	// $ANTLR start "FINALLY"
	public final void mFINALLY() throws RecognitionException {
		try {
			int _type = FINALLY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:453:14: ( 'finally' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:453:16: 'finally'
			{
			match("finally"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FINALLY"

	// $ANTLR start "MODE"
	public final void mMODE() throws RecognitionException {
		try {
			int _type = MODE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:454:14: ( 'mode' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:454:16: 'mode'
			{
			match("mode"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "MODE"

	// $ANTLR start "COLON"
	public final void mCOLON() throws RecognitionException {
		try {
			int _type = COLON;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:461:14: ( ':' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:461:16: ':'
			{
			match(':'); if (state.failed) return;
			if ( state.backtracking==0 ) {
			               // scan backwards, looking for a RULE_REF or TOKEN_REF.
			               // which would indicate the start of a rule definition.
			               // If we see a LPAREN, then it's the start of the subrule.
			               // this.tokens is the token string we are pushing into, so
			               // just loop backwards looking for a rule definition. Then
			               // we set isLexerRule.
			               Token t = getRuleOrSubruleStartToken();
			               if ( t!=null ) {
			                    if ( t.getType()==RULE_REF ) isLexerRule = false;
			                    else if ( t.getType()==TOKEN_REF ) isLexerRule = true;
			                    // else must be subrule; don't alter context
			               }
			               }
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COLON"

	// $ANTLR start "COLONCOLON"
	public final void mCOLONCOLON() throws RecognitionException {
		try {
			int _type = COLONCOLON;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:477:14: ( '::' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:477:16: '::'
			{
			match("::"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COLONCOLON"

	// $ANTLR start "COMMA"
	public final void mCOMMA() throws RecognitionException {
		try {
			int _type = COMMA;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:478:14: ( ',' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:478:16: ','
			{
			match(','); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COMMA"

	// $ANTLR start "SEMI"
	public final void mSEMI() throws RecognitionException {
		try {
			int _type = SEMI;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:479:14: ( ';' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:479:16: ';'
			{
			match(';'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SEMI"

	// $ANTLR start "LPAREN"
	public final void mLPAREN() throws RecognitionException {
		try {
			int _type = LPAREN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:480:14: ( '(' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:480:16: '('
			{
			match('('); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LPAREN"

	// $ANTLR start "RPAREN"
	public final void mRPAREN() throws RecognitionException {
		try {
			int _type = RPAREN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:481:14: ( ')' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:481:16: ')'
			{
			match(')'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RPAREN"

	// $ANTLR start "RARROW"
	public final void mRARROW() throws RecognitionException {
		try {
			int _type = RARROW;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:482:14: ( '->' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:482:16: '->'
			{
			match("->"); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RARROW"

	// $ANTLR start "LT"
	public final void mLT() throws RecognitionException {
		try {
			int _type = LT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:483:14: ( '<' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:483:16: '<'
			{
			match('<'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LT"

	// $ANTLR start "GT"
	public final void mGT() throws RecognitionException {
		try {
			int _type = GT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:484:14: ( '>' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:484:16: '>'
			{
			match('>'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "GT"

	// $ANTLR start "ASSIGN"
	public final void mASSIGN() throws RecognitionException {
		try {
			int _type = ASSIGN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:485:14: ( '=' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:485:16: '='
			{
			match('='); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ASSIGN"

	// $ANTLR start "QUESTION"
	public final void mQUESTION() throws RecognitionException {
		try {
			int _type = QUESTION;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:486:14: ( '?' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:486:16: '?'
			{
			match('?'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "QUESTION"

	// $ANTLR start "SYNPRED"
	public final void mSYNPRED() throws RecognitionException {
		try {
			int _type = SYNPRED;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:487:14: ( '=>' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:487:16: '=>'
			{
			match("=>"); if (state.failed) return;

			if ( state.backtracking==0 ) {
						    Token t = new CommonToken(input, state.type, state.channel,
						                              state.tokenStartCharIndex, getCharIndex()-1);
							t.setLine(state.tokenStartLine);
							t.setText(state.text);
							t.setCharPositionInLine(state.tokenStartCharPositionInLine);
							grammarError(ErrorType.V3_SYNPRED, t);
			                _channel=HIDDEN;
							}
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SYNPRED"

	// $ANTLR start "STAR"
	public final void mSTAR() throws RecognitionException {
		try {
			int _type = STAR;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:498:14: ( '*' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:498:16: '*'
			{
			match('*'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "STAR"

	// $ANTLR start "PLUS"
	public final void mPLUS() throws RecognitionException {
		try {
			int _type = PLUS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:499:14: ( '+' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:499:16: '+'
			{
			match('+'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PLUS"

	// $ANTLR start "PLUS_ASSIGN"
	public final void mPLUS_ASSIGN() throws RecognitionException {
		try {
			int _type = PLUS_ASSIGN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:500:14: ( '+=' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:500:16: '+='
			{
			match("+="); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PLUS_ASSIGN"

	// $ANTLR start "OR"
	public final void mOR() throws RecognitionException {
		try {
			int _type = OR;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:501:14: ( '|' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:501:16: '|'
			{
			match('|'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "OR"

	// $ANTLR start "DOLLAR"
	public final void mDOLLAR() throws RecognitionException {
		try {
			int _type = DOLLAR;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:502:14: ( '$' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:502:16: '$'
			{
			match('$'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DOLLAR"

	// $ANTLR start "DOT"
	public final void mDOT() throws RecognitionException {
		try {
			int _type = DOT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:503:11: ( '.' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:503:13: '.'
			{
			match('.'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DOT"

	// $ANTLR start "RANGE"
	public final void mRANGE() throws RecognitionException {
		try {
			int _type = RANGE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:504:14: ( '..' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:504:16: '..'
			{
			match(".."); if (state.failed) return;

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RANGE"

	// $ANTLR start "AT"
	public final void mAT() throws RecognitionException {
		try {
			int _type = AT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:505:14: ( '@' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:505:16: '@'
			{
			match('@'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "AT"

	// $ANTLR start "POUND"
	public final void mPOUND() throws RecognitionException {
		try {
			int _type = POUND;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:506:14: ( '#' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:506:16: '#'
			{
			match('#'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "POUND"

	// $ANTLR start "NOT"
	public final void mNOT() throws RecognitionException {
		try {
			int _type = NOT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:507:14: ( '~' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:507:16: '~'
			{
			match('~'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NOT"

	// $ANTLR start "RBRACE"
	public final void mRBRACE() throws RecognitionException {
		try {
			int _type = RBRACE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:508:14: ( '}' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:508:16: '}'
			{
			match('}'); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RBRACE"

	// $ANTLR start "ID"
	public final void mID() throws RecognitionException {
		try {
			int _type = ID;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			CommonToken a=null;

			// org\\antlr\\v4\\parse\\ANTLRLexer.g:511:6: (a= NameStartChar ( NameChar )* )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:511:8: a= NameStartChar ( NameChar )*
			{
			int aStart2905 = getCharIndex();
			int aStartLine2905 = getLine();
			int aStartCharPos2905 = getCharPositionInLine();
			mNameStartChar(); if (state.failed) return;
			a = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, aStart2905, getCharIndex()-1);
			a.setLine(aStartLine2905);
			a.setCharPositionInLine(aStartCharPos2905);

			// org\\antlr\\v4\\parse\\ANTLRLexer.g:511:24: ( NameChar )*
			loop18:
			while (true) {
				int alt18=2;
				int LA18_0 = input.LA(1);
				if ( ((LA18_0 >= '0' && LA18_0 <= '9')||(LA18_0 >= 'A' && LA18_0 <= 'Z')||LA18_0=='_'||(LA18_0 >= 'a' && LA18_0 <= 'z')||LA18_0=='\u00B7'||(LA18_0 >= '\u00C0' && LA18_0 <= '\u00D6')||(LA18_0 >= '\u00D8' && LA18_0 <= '\u00F6')||(LA18_0 >= '\u00F8' && LA18_0 <= '\u037D')||(LA18_0 >= '\u037F' && LA18_0 <= '\u1FFF')||(LA18_0 >= '\u200C' && LA18_0 <= '\u200D')||(LA18_0 >= '\u203F' && LA18_0 <= '\u2040')||(LA18_0 >= '\u2070' && LA18_0 <= '\u218F')||(LA18_0 >= '\u2C00' && LA18_0 <= '\u2FEF')||(LA18_0 >= '\u3001' && LA18_0 <= '\uD7FF')||(LA18_0 >= '\uF900' && LA18_0 <= '\uFDCF')||(LA18_0 >= '\uFDF0' && LA18_0 <= '\uFFFD')) ) {
					alt18=1;
				}

				switch (alt18) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:
					{
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z')||input.LA(1)=='\u00B7'||(input.LA(1) >= '\u00C0' && input.LA(1) <= '\u00D6')||(input.LA(1) >= '\u00D8' && input.LA(1) <= '\u00F6')||(input.LA(1) >= '\u00F8' && input.LA(1) <= '\u037D')||(input.LA(1) >= '\u037F' && input.LA(1) <= '\u1FFF')||(input.LA(1) >= '\u200C' && input.LA(1) <= '\u200D')||(input.LA(1) >= '\u203F' && input.LA(1) <= '\u2040')||(input.LA(1) >= '\u2070' && input.LA(1) <= '\u218F')||(input.LA(1) >= '\u2C00' && input.LA(1) <= '\u2FEF')||(input.LA(1) >= '\u3001' && input.LA(1) <= '\uD7FF')||(input.LA(1) >= '\uF900' && input.LA(1) <= '\uFDCF')||(input.LA(1) >= '\uFDF0' && input.LA(1) <= '\uFFFD') ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					break loop18;
				}
			}

			if ( state.backtracking==0 ) {
							if ( Grammar.isTokenName((a!=null?a.getText():null)) ) _type = TOKEN_REF;
							else _type = RULE_REF;
							}
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ID"

	// $ANTLR start "NameChar"
	public final void mNameChar() throws RecognitionException {
		try {
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:519:13: ( NameStartChar | '0' .. '9' | '_' | '\\u00B7' | '\\u0300' .. '\\u036F' | '\\u203F' .. '\\u2040' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:
			{
			if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z')||input.LA(1)=='\u00B7'||(input.LA(1) >= '\u00C0' && input.LA(1) <= '\u00D6')||(input.LA(1) >= '\u00D8' && input.LA(1) <= '\u00F6')||(input.LA(1) >= '\u00F8' && input.LA(1) <= '\u037D')||(input.LA(1) >= '\u037F' && input.LA(1) <= '\u1FFF')||(input.LA(1) >= '\u200C' && input.LA(1) <= '\u200D')||(input.LA(1) >= '\u203F' && input.LA(1) <= '\u2040')||(input.LA(1) >= '\u2070' && input.LA(1) <= '\u218F')||(input.LA(1) >= '\u2C00' && input.LA(1) <= '\u2FEF')||(input.LA(1) >= '\u3001' && input.LA(1) <= '\uD7FF')||(input.LA(1) >= '\uF900' && input.LA(1) <= '\uFDCF')||(input.LA(1) >= '\uFDF0' && input.LA(1) <= '\uFFFD') ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NameChar"

	// $ANTLR start "NameStartChar"
	public final void mNameStartChar() throws RecognitionException {
		try {
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:529:13: ( 'A' .. 'Z' | 'a' .. 'z' | '\\u00C0' .. '\\u00D6' | '\\u00D8' .. '\\u00F6' | '\\u00F8' .. '\\u02FF' | '\\u0370' .. '\\u037D' | '\\u037F' .. '\\u1FFF' | '\\u200C' .. '\\u200D' | '\\u2070' .. '\\u218F' | '\\u2C00' .. '\\u2FEF' | '\\u3001' .. '\\uD7FF' | '\\uF900' .. '\\uFDCF' | '\\uFDF0' .. '\\uFFFD' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:
			{
			if ( (input.LA(1) >= 'A' && input.LA(1) <= 'Z')||(input.LA(1) >= 'a' && input.LA(1) <= 'z')||(input.LA(1) >= '\u00C0' && input.LA(1) <= '\u00D6')||(input.LA(1) >= '\u00D8' && input.LA(1) <= '\u00F6')||(input.LA(1) >= '\u00F8' && input.LA(1) <= '\u02FF')||(input.LA(1) >= '\u0370' && input.LA(1) <= '\u037D')||(input.LA(1) >= '\u037F' && input.LA(1) <= '\u1FFF')||(input.LA(1) >= '\u200C' && input.LA(1) <= '\u200D')||(input.LA(1) >= '\u2070' && input.LA(1) <= '\u218F')||(input.LA(1) >= '\u2C00' && input.LA(1) <= '\u2FEF')||(input.LA(1) >= '\u3001' && input.LA(1) <= '\uD7FF')||(input.LA(1) >= '\uF900' && input.LA(1) <= '\uFDCF')||(input.LA(1) >= '\uFDF0' && input.LA(1) <= '\uFFFD') ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NameStartChar"

	// $ANTLR start "ACTION_CHAR_LITERAL"
	public final void mACTION_CHAR_LITERAL() throws RecognitionException {
		try {
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:562:2: ( '\\'' ( ( '\\\\' )=> ACTION_ESC |~ '\\'' )* '\\'' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:562:4: '\\'' ( ( '\\\\' )=> ACTION_ESC |~ '\\'' )* '\\''
			{
			match('\''); if (state.failed) return;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:562:9: ( ( '\\\\' )=> ACTION_ESC |~ '\\'' )*
			loop19:
			while (true) {
				int alt19=3;
				int LA19_0 = input.LA(1);
				if ( (LA19_0=='\\') ) {
					int LA19_2 = input.LA(2);
					if ( (LA19_2=='\'') ) {
						int LA19_4 = input.LA(3);
						if ( (LA19_4=='\'') && (synpred5_ANTLRLexer())) {
							alt19=1;
						}
						else if ( (LA19_4=='\\') && (synpred5_ANTLRLexer())) {
							alt19=1;
						}
						else if ( ((LA19_4 >= '\u0000' && LA19_4 <= '&')||(LA19_4 >= '(' && LA19_4 <= '[')||(LA19_4 >= ']' && LA19_4 <= '\uFFFF')) && (synpred5_ANTLRLexer())) {
							alt19=1;
						}
						else {
							alt19=2;
						}

					}
					else if ( (LA19_2=='\\') ) {
						int LA19_5 = input.LA(3);
						if ( (synpred5_ANTLRLexer()) ) {
							alt19=1;
						}
						else if ( (true) ) {
							alt19=2;
						}

					}
					else if ( ((LA19_2 >= '\u0000' && LA19_2 <= '&')||(LA19_2 >= '(' && LA19_2 <= '[')||(LA19_2 >= ']' && LA19_2 <= '\uFFFF')) ) {
						int LA19_6 = input.LA(3);
						if ( (synpred5_ANTLRLexer()) ) {
							alt19=1;
						}
						else if ( (true) ) {
							alt19=2;
						}

					}

				}
				else if ( ((LA19_0 >= '\u0000' && LA19_0 <= '&')||(LA19_0 >= '(' && LA19_0 <= '[')||(LA19_0 >= ']' && LA19_0 <= '\uFFFF')) ) {
					alt19=2;
				}

				switch (alt19) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:562:10: ( '\\\\' )=> ACTION_ESC
					{
					mACTION_ESC(); if (state.failed) return;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:562:31: ~ '\\''
					{
					if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '&')||(input.LA(1) >= '(' && input.LA(1) <= '\uFFFF') ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					break loop19;
				}
			}

			match('\''); if (state.failed) return;
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ACTION_CHAR_LITERAL"

	// $ANTLR start "ACTION_STRING_LITERAL"
	public final void mACTION_STRING_LITERAL() throws RecognitionException {
		try {
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:572:2: ( '\"' ( ( '\\\\' )=> ACTION_ESC |~ '\"' )* '\"' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:572:4: '\"' ( ( '\\\\' )=> ACTION_ESC |~ '\"' )* '\"'
			{
			match('\"'); if (state.failed) return;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:572:8: ( ( '\\\\' )=> ACTION_ESC |~ '\"' )*
			loop20:
			while (true) {
				int alt20=3;
				int LA20_0 = input.LA(1);
				if ( (LA20_0=='\\') ) {
					int LA20_2 = input.LA(2);
					if ( (LA20_2=='\"') ) {
						int LA20_4 = input.LA(3);
						if ( (LA20_4=='\"') && (synpred6_ANTLRLexer())) {
							alt20=1;
						}
						else if ( (LA20_4=='\\') && (synpred6_ANTLRLexer())) {
							alt20=1;
						}
						else if ( ((LA20_4 >= '\u0000' && LA20_4 <= '!')||(LA20_4 >= '#' && LA20_4 <= '[')||(LA20_4 >= ']' && LA20_4 <= '\uFFFF')) && (synpred6_ANTLRLexer())) {
							alt20=1;
						}
						else {
							alt20=2;
						}

					}
					else if ( (LA20_2=='\\') ) {
						int LA20_5 = input.LA(3);
						if ( (synpred6_ANTLRLexer()) ) {
							alt20=1;
						}
						else if ( (true) ) {
							alt20=2;
						}

					}
					else if ( ((LA20_2 >= '\u0000' && LA20_2 <= '!')||(LA20_2 >= '#' && LA20_2 <= '[')||(LA20_2 >= ']' && LA20_2 <= '\uFFFF')) ) {
						int LA20_6 = input.LA(3);
						if ( (synpred6_ANTLRLexer()) ) {
							alt20=1;
						}
						else if ( (true) ) {
							alt20=2;
						}

					}

				}
				else if ( ((LA20_0 >= '\u0000' && LA20_0 <= '!')||(LA20_0 >= '#' && LA20_0 <= '[')||(LA20_0 >= ']' && LA20_0 <= '\uFFFF')) ) {
					alt20=2;
				}

				switch (alt20) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:572:9: ( '\\\\' )=> ACTION_ESC
					{
					mACTION_ESC(); if (state.failed) return;

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:572:30: ~ '\"'
					{
					if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '!')||(input.LA(1) >= '#' && input.LA(1) <= '\uFFFF') ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					break loop20;
				}
			}

			match('\"'); if (state.failed) return;
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ACTION_STRING_LITERAL"

	// $ANTLR start "ACTION_ESC"
	public final void mACTION_ESC() throws RecognitionException {
		try {
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:582:2: ( '\\\\' . )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:582:4: '\\\\' .
			{
			match('\\'); if (state.failed) return;
			matchAny(); if (state.failed) return;
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ACTION_ESC"

	// $ANTLR start "INT"
	public final void mINT() throws RecognitionException {
		try {
			int _type = INT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:590:5: ( ( '0' .. '9' )+ )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:590:7: ( '0' .. '9' )+
			{
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:590:7: ( '0' .. '9' )+
			int cnt21=0;
			loop21:
			while (true) {
				int alt21=2;
				switch ( input.LA(1) ) {
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					{
					alt21=1;
					}
					break;
				}
				switch (alt21) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:
					{
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt21 >= 1 ) break loop21;
					if (state.backtracking>0) {state.failed=true; return;}
					EarlyExitException eee = new EarlyExitException(21, input);
					throw eee;
				}
				cnt21++;
			}

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "INT"

	// $ANTLR start "SRC"
	public final void mSRC() throws RecognitionException {
		try {
			CommonToken file=null;
			CommonToken line=null;

			// org\\antlr\\v4\\parse\\ANTLRLexer.g:602:5: ( 'src' ( WSCHARS )+ file= ACTION_STRING_LITERAL ( WSCHARS )+ line= INT )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:602:7: 'src' ( WSCHARS )+ file= ACTION_STRING_LITERAL ( WSCHARS )+ line= INT
			{
			match("src"); if (state.failed) return;

			// org\\antlr\\v4\\parse\\ANTLRLexer.g:602:13: ( WSCHARS )+
			int cnt22=0;
			loop22:
			while (true) {
				int alt22=2;
				switch ( input.LA(1) ) {
				case '\t':
				case '\f':
				case ' ':
					{
					alt22=1;
					}
					break;
				}
				switch (alt22) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:
					{
					if ( input.LA(1)=='\t'||input.LA(1)=='\f'||input.LA(1)==' ' ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt22 >= 1 ) break loop22;
					if (state.backtracking>0) {state.failed=true; return;}
					EarlyExitException eee = new EarlyExitException(22, input);
					throw eee;
				}
				cnt22++;
			}

			int fileStart3457 = getCharIndex();
			int fileStartLine3457 = getLine();
			int fileStartCharPos3457 = getCharPositionInLine();
			mACTION_STRING_LITERAL(); if (state.failed) return;
			file = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, fileStart3457, getCharIndex()-1);
			file.setLine(fileStartLine3457);
			file.setCharPositionInLine(fileStartCharPos3457);

			// org\\antlr\\v4\\parse\\ANTLRLexer.g:602:49: ( WSCHARS )+
			int cnt23=0;
			loop23:
			while (true) {
				int alt23=2;
				switch ( input.LA(1) ) {
				case '\t':
				case '\f':
				case ' ':
					{
					alt23=1;
					}
					break;
				}
				switch (alt23) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:
					{
					if ( input.LA(1)=='\t'||input.LA(1)=='\f'||input.LA(1)==' ' ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt23 >= 1 ) break loop23;
					if (state.backtracking>0) {state.failed=true; return;}
					EarlyExitException eee = new EarlyExitException(23, input);
					throw eee;
				}
				cnt23++;
			}

			int lineStart3464 = getCharIndex();
			int lineStartLine3464 = getLine();
			int lineStartCharPos3464 = getCharPositionInLine();
			mINT(); if (state.failed) return;
			line = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, lineStart3464, getCharIndex()-1);
			line.setLine(lineStartLine3464);
			line.setCharPositionInLine(lineStartCharPos3464);

			if ( state.backtracking==0 ) {
			         // TODO: Add target specific code to change the source file name and current line number
			         //
			      }
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SRC"

	// $ANTLR start "STRING_LITERAL"
	public final void mSTRING_LITERAL() throws RecognitionException {
		try {
			int _type = STRING_LITERAL;
			int _channel = DEFAULT_TOKEN_CHANNEL;

			   int len = 0;

			// org\\antlr\\v4\\parse\\ANTLRLexer.g:620:5: ( '\\'' ( ( ESC_SEQ |~ ( '\\\\' | '\\'' ) ) )* '\\'' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:620:8: '\\'' ( ( ESC_SEQ |~ ( '\\\\' | '\\'' ) ) )* '\\''
			{
			match('\''); if (state.failed) return;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:620:13: ( ( ESC_SEQ |~ ( '\\\\' | '\\'' ) ) )*
			loop25:
			while (true) {
				int alt25=2;
				int LA25_0 = input.LA(1);
				if ( ((LA25_0 >= '\u0000' && LA25_0 <= '&')||(LA25_0 >= '(' && LA25_0 <= '\uFFFF')) ) {
					alt25=1;
				}

				switch (alt25) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:620:15: ( ESC_SEQ |~ ( '\\\\' | '\\'' ) )
					{
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:620:15: ( ESC_SEQ |~ ( '\\\\' | '\\'' ) )
					int alt24=2;
					int LA24_0 = input.LA(1);
					if ( (LA24_0=='\\') ) {
						alt24=1;
					}
					else if ( ((LA24_0 >= '\u0000' && LA24_0 <= '&')||(LA24_0 >= '(' && LA24_0 <= '[')||(LA24_0 >= ']' && LA24_0 <= '\uFFFF')) ) {
						alt24=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return;}
						NoViableAltException nvae =
							new NoViableAltException("", 24, 0, input);
						throw nvae;
					}

					switch (alt24) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRLexer.g:620:17: ESC_SEQ
							{
							mESC_SEQ(); if (state.failed) return;

							}
							break;
						case 2 :
							// org\\antlr\\v4\\parse\\ANTLRLexer.g:620:27: ~ ( '\\\\' | '\\'' )
							{
							if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '&')||(input.LA(1) >= '(' && input.LA(1) <= '[')||(input.LA(1) >= ']' && input.LA(1) <= '\uFFFF') ) {
								input.consume();
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							}
							break;

					}

					if ( state.backtracking==0 ) {len++;}
					}
					break;

				default :
					break loop25;
				}
			}

			match('\''); if (state.failed) return;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "STRING_LITERAL"

	// $ANTLR start "HEX_DIGIT"
	public final void mHEX_DIGIT() throws RecognitionException {
		try {
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:626:11: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:
			{
			if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "HEX_DIGIT"

	// $ANTLR start "ESC_SEQ"
	public final void mESC_SEQ() throws RecognitionException {
		try {
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:633:5: ( '\\\\' ( 'b' | 't' | 'n' | 'f' | 'r' | '\\\"' | '\\'' | '\\\\' | UNICODE_ESC |) )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:633:7: '\\\\' ( 'b' | 't' | 'n' | 'f' | 'r' | '\\\"' | '\\'' | '\\\\' | UNICODE_ESC |)
			{
			match('\\'); if (state.failed) return;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:634:9: ( 'b' | 't' | 'n' | 'f' | 'r' | '\\\"' | '\\'' | '\\\\' | UNICODE_ESC |)
			int alt26=10;
			switch ( input.LA(1) ) {
			case 'b':
				{
				alt26=1;
				}
				break;
			case 't':
				{
				alt26=2;
				}
				break;
			case 'n':
				{
				alt26=3;
				}
				break;
			case 'f':
				{
				alt26=4;
				}
				break;
			case 'r':
				{
				alt26=5;
				}
				break;
			case '\"':
				{
				alt26=6;
				}
				break;
			case '\'':
				{
				alt26=7;
				}
				break;
			case '\\':
				{
				alt26=8;
				}
				break;
			case 'u':
				{
				alt26=9;
				}
				break;
			default:
				alt26=10;
			}
			switch (alt26) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:638:9: 'b'
					{
					match('b'); if (state.failed) return;
					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:638:13: 't'
					{
					match('t'); if (state.failed) return;
					}
					break;
				case 3 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:638:17: 'n'
					{
					match('n'); if (state.failed) return;
					}
					break;
				case 4 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:638:21: 'f'
					{
					match('f'); if (state.failed) return;
					}
					break;
				case 5 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:638:25: 'r'
					{
					match('r'); if (state.failed) return;
					}
					break;
				case 6 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:638:29: '\\\"'
					{
					match('\"'); if (state.failed) return;
					}
					break;
				case 7 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:638:34: '\\''
					{
					match('\''); if (state.failed) return;
					}
					break;
				case 8 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:638:39: '\\\\'
					{
					match('\\'); if (state.failed) return;
					}
					break;
				case 9 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:642:12: UNICODE_ESC
					{
					mUNICODE_ESC(); if (state.failed) return;

					}
					break;
				case 10 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:646:12: 
					{
					if ( state.backtracking==0 ) {
					    	      	// TODO: Issue error message
					    	      	//
					    	      }
					}
					break;

			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ESC_SEQ"

	// $ANTLR start "UNICODE_ESC"
	public final void mUNICODE_ESC() throws RecognitionException {
		try {


				// Flag to tell us whether we have a valid number of
				// hex digits in the escape sequence
				//
				int	hCount = 0;

			// org\\antlr\\v4\\parse\\ANTLRLexer.g:663:5: ( 'u' ( ( HEX_DIGIT ( HEX_DIGIT ( HEX_DIGIT ( HEX_DIGIT |) |) |) ) |) )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:663:9: 'u' ( ( HEX_DIGIT ( HEX_DIGIT ( HEX_DIGIT ( HEX_DIGIT |) |) |) ) |)
			{
			match('u'); if (state.failed) return;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:672:6: ( ( HEX_DIGIT ( HEX_DIGIT ( HEX_DIGIT ( HEX_DIGIT |) |) |) ) |)
			int alt30=2;
			switch ( input.LA(1) ) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
				{
				alt30=1;
				}
				break;
			default:
				alt30=2;
			}
			switch (alt30) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:673:9: ( HEX_DIGIT ( HEX_DIGIT ( HEX_DIGIT ( HEX_DIGIT |) |) |) )
					{
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:673:9: ( HEX_DIGIT ( HEX_DIGIT ( HEX_DIGIT ( HEX_DIGIT |) |) |) )
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:674:12: HEX_DIGIT ( HEX_DIGIT ( HEX_DIGIT ( HEX_DIGIT |) |) |)
					{
					mHEX_DIGIT(); if (state.failed) return;

					if ( state.backtracking==0 ) { hCount++; }
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:675:14: ( HEX_DIGIT ( HEX_DIGIT ( HEX_DIGIT |) |) |)
					int alt29=2;
					switch ( input.LA(1) ) {
					case '0':
					case '1':
					case '2':
					case '3':
					case '4':
					case '5':
					case '6':
					case '7':
					case '8':
					case '9':
					case 'A':
					case 'B':
					case 'C':
					case 'D':
					case 'E':
					case 'F':
					case 'a':
					case 'b':
					case 'c':
					case 'd':
					case 'e':
					case 'f':
						{
						alt29=1;
						}
						break;
					default:
						alt29=2;
					}
					switch (alt29) {
						case 1 :
							// org\\antlr\\v4\\parse\\ANTLRLexer.g:676:19: HEX_DIGIT ( HEX_DIGIT ( HEX_DIGIT |) |)
							{
							mHEX_DIGIT(); if (state.failed) return;

							if ( state.backtracking==0 ) { hCount++; }
							// org\\antlr\\v4\\parse\\ANTLRLexer.g:677:16: ( HEX_DIGIT ( HEX_DIGIT |) |)
							int alt28=2;
							switch ( input.LA(1) ) {
							case '0':
							case '1':
							case '2':
							case '3':
							case '4':
							case '5':
							case '6':
							case '7':
							case '8':
							case '9':
							case 'A':
							case 'B':
							case 'C':
							case 'D':
							case 'E':
							case 'F':
							case 'a':
							case 'b':
							case 'c':
							case 'd':
							case 'e':
							case 'f':
								{
								alt28=1;
								}
								break;
							default:
								alt28=2;
							}
							switch (alt28) {
								case 1 :
									// org\\antlr\\v4\\parse\\ANTLRLexer.g:678:21: HEX_DIGIT ( HEX_DIGIT |)
									{
									mHEX_DIGIT(); if (state.failed) return;

									if ( state.backtracking==0 ) { hCount++; }
									// org\\antlr\\v4\\parse\\ANTLRLexer.g:679:21: ( HEX_DIGIT |)
									int alt27=2;
									switch ( input.LA(1) ) {
									case '0':
									case '1':
									case '2':
									case '3':
									case '4':
									case '5':
									case '6':
									case '7':
									case '8':
									case '9':
									case 'A':
									case 'B':
									case 'C':
									case 'D':
									case 'E':
									case 'F':
									case 'a':
									case 'b':
									case 'c':
									case 'd':
									case 'e':
									case 'f':
										{
										alt27=1;
										}
										break;
									default:
										alt27=2;
									}
									switch (alt27) {
										case 1 :
											// org\\antlr\\v4\\parse\\ANTLRLexer.g:682:25: HEX_DIGIT
											{
											mHEX_DIGIT(); if (state.failed) return;

											if ( state.backtracking==0 ) { hCount++; }
											}
											break;
										case 2 :
											// org\\antlr\\v4\\parse\\ANTLRLexer.g:685:21: 
											{
											}
											break;

									}

									}
									break;
								case 2 :
									// org\\antlr\\v4\\parse\\ANTLRLexer.g:688:17: 
									{
									}
									break;

							}

							}
							break;
						case 2 :
							// org\\antlr\\v4\\parse\\ANTLRLexer.g:691:11: 
							{
							}
							break;

					}

					}

					}
					break;
				case 2 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:694:6: 
					{
					}
					break;

			}

			if ( state.backtracking==0 ) {
			    		if	(hCount != 4) {

			    			// TODO: Issue error message
			    		}
			    	}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "UNICODE_ESC"

	// $ANTLR start "WS"
	public final void mWS() throws RecognitionException {
		try {
			int _type = WS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:714:5: ( ( ' ' | '\\t' | '\\r' | '\\n' | '\\f' )+ )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:714:7: ( ' ' | '\\t' | '\\r' | '\\n' | '\\f' )+
			{
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:714:7: ( ' ' | '\\t' | '\\r' | '\\n' | '\\f' )+
			int cnt31=0;
			loop31:
			while (true) {
				int alt31=2;
				switch ( input.LA(1) ) {
				case '\t':
				case '\n':
				case '\f':
				case '\r':
				case ' ':
					{
					alt31=1;
					}
					break;
				}
				switch (alt31) {
				case 1 :
					// org\\antlr\\v4\\parse\\ANTLRLexer.g:
					{
					if ( (input.LA(1) >= '\t' && input.LA(1) <= '\n')||(input.LA(1) >= '\f' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
						input.consume();
						state.failed=false;
					}
					else {
						if (state.backtracking>0) {state.failed=true; return;}
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt31 >= 1 ) break loop31;
					if (state.backtracking>0) {state.failed=true; return;}
					EarlyExitException eee = new EarlyExitException(31, input);
					throw eee;
				}
				cnt31++;
			}

			if ( state.backtracking==0 ) {_channel=HIDDEN;}
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "WS"

	// $ANTLR start "NLCHARS"
	public final void mNLCHARS() throws RecognitionException {
		try {
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:729:5: ( '\\n' | '\\r' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:
			{
			if ( input.LA(1)=='\n'||input.LA(1)=='\r' ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NLCHARS"

	// $ANTLR start "WSCHARS"
	public final void mWSCHARS() throws RecognitionException {
		try {
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:737:5: ( ' ' | '\\t' | '\\f' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:
			{
			if ( input.LA(1)=='\t'||input.LA(1)=='\f'||input.LA(1)==' ' ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "WSCHARS"

	// $ANTLR start "WSNLCHARS"
	public final void mWSNLCHARS() throws RecognitionException {
		try {
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:746:5: ( ' ' | '\\t' | '\\f' | '\\n' | '\\r' )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:
			{
			if ( (input.LA(1) >= '\t' && input.LA(1) <= '\n')||(input.LA(1) >= '\f' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
				input.consume();
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "WSNLCHARS"

	// $ANTLR start "ERRCHAR"
	public final void mERRCHAR() throws RecognitionException {
		try {
			int _type = ERRCHAR;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:761:5: ( . )
			// org\\antlr\\v4\\parse\\ANTLRLexer.g:761:7: .
			{
			matchAny(); if (state.failed) return;
			if ( state.backtracking==0 ) {
			         // TODO: Issue error message
			         //
			         skip();
			      }
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ERRCHAR"

	@Override
	public void mTokens() throws RecognitionException {
		// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:8: ( COMMENT | ARG_OR_CHARSET | ACTION | OPTIONS | TOKENS_SPEC | IMPORT | FRAGMENT | LEXER | PARSER | GRAMMAR | TREE_GRAMMAR | PROTECTED | PUBLIC | PRIVATE | RETURNS | LOCALS | THROWS | CATCH | FINALLY | MODE | COLON | COLONCOLON | COMMA | SEMI | LPAREN | RPAREN | RARROW | LT | GT | ASSIGN | QUESTION | SYNPRED | STAR | PLUS | PLUS_ASSIGN | OR | DOLLAR | DOT | RANGE | AT | POUND | NOT | RBRACE | ID | INT | STRING_LITERAL | WS | ERRCHAR )
		int alt32=48;
		alt32 = dfa32.predict(input);
		switch (alt32) {
			case 1 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:10: COMMENT
				{
				mCOMMENT(); if (state.failed) return;

				}
				break;
			case 2 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:18: ARG_OR_CHARSET
				{
				mARG_OR_CHARSET(); if (state.failed) return;

				}
				break;
			case 3 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:33: ACTION
				{
				mACTION(); if (state.failed) return;

				}
				break;
			case 4 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:40: OPTIONS
				{
				mOPTIONS(); if (state.failed) return;

				}
				break;
			case 5 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:48: TOKENS_SPEC
				{
				mTOKENS_SPEC(); if (state.failed) return;

				}
				break;
			case 6 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:60: IMPORT
				{
				mIMPORT(); if (state.failed) return;

				}
				break;
			case 7 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:67: FRAGMENT
				{
				mFRAGMENT(); if (state.failed) return;

				}
				break;
			case 8 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:76: LEXER
				{
				mLEXER(); if (state.failed) return;

				}
				break;
			case 9 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:82: PARSER
				{
				mPARSER(); if (state.failed) return;

				}
				break;
			case 10 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:89: GRAMMAR
				{
				mGRAMMAR(); if (state.failed) return;

				}
				break;
			case 11 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:97: TREE_GRAMMAR
				{
				mTREE_GRAMMAR(); if (state.failed) return;

				}
				break;
			case 12 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:110: PROTECTED
				{
				mPROTECTED(); if (state.failed) return;

				}
				break;
			case 13 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:120: PUBLIC
				{
				mPUBLIC(); if (state.failed) return;

				}
				break;
			case 14 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:127: PRIVATE
				{
				mPRIVATE(); if (state.failed) return;

				}
				break;
			case 15 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:135: RETURNS
				{
				mRETURNS(); if (state.failed) return;

				}
				break;
			case 16 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:143: LOCALS
				{
				mLOCALS(); if (state.failed) return;

				}
				break;
			case 17 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:150: THROWS
				{
				mTHROWS(); if (state.failed) return;

				}
				break;
			case 18 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:157: CATCH
				{
				mCATCH(); if (state.failed) return;

				}
				break;
			case 19 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:163: FINALLY
				{
				mFINALLY(); if (state.failed) return;

				}
				break;
			case 20 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:171: MODE
				{
				mMODE(); if (state.failed) return;

				}
				break;
			case 21 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:176: COLON
				{
				mCOLON(); if (state.failed) return;

				}
				break;
			case 22 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:182: COLONCOLON
				{
				mCOLONCOLON(); if (state.failed) return;

				}
				break;
			case 23 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:193: COMMA
				{
				mCOMMA(); if (state.failed) return;

				}
				break;
			case 24 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:199: SEMI
				{
				mSEMI(); if (state.failed) return;

				}
				break;
			case 25 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:204: LPAREN
				{
				mLPAREN(); if (state.failed) return;

				}
				break;
			case 26 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:211: RPAREN
				{
				mRPAREN(); if (state.failed) return;

				}
				break;
			case 27 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:218: RARROW
				{
				mRARROW(); if (state.failed) return;

				}
				break;
			case 28 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:225: LT
				{
				mLT(); if (state.failed) return;

				}
				break;
			case 29 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:228: GT
				{
				mGT(); if (state.failed) return;

				}
				break;
			case 30 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:231: ASSIGN
				{
				mASSIGN(); if (state.failed) return;

				}
				break;
			case 31 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:238: QUESTION
				{
				mQUESTION(); if (state.failed) return;

				}
				break;
			case 32 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:247: SYNPRED
				{
				mSYNPRED(); if (state.failed) return;

				}
				break;
			case 33 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:255: STAR
				{
				mSTAR(); if (state.failed) return;

				}
				break;
			case 34 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:260: PLUS
				{
				mPLUS(); if (state.failed) return;

				}
				break;
			case 35 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:265: PLUS_ASSIGN
				{
				mPLUS_ASSIGN(); if (state.failed) return;

				}
				break;
			case 36 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:277: OR
				{
				mOR(); if (state.failed) return;

				}
				break;
			case 37 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:280: DOLLAR
				{
				mDOLLAR(); if (state.failed) return;

				}
				break;
			case 38 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:287: DOT
				{
				mDOT(); if (state.failed) return;

				}
				break;
			case 39 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:291: RANGE
				{
				mRANGE(); if (state.failed) return;

				}
				break;
			case 40 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:297: AT
				{
				mAT(); if (state.failed) return;

				}
				break;
			case 41 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:300: POUND
				{
				mPOUND(); if (state.failed) return;

				}
				break;
			case 42 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:306: NOT
				{
				mNOT(); if (state.failed) return;

				}
				break;
			case 43 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:310: RBRACE
				{
				mRBRACE(); if (state.failed) return;

				}
				break;
			case 44 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:317: ID
				{
				mID(); if (state.failed) return;

				}
				break;
			case 45 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:320: INT
				{
				mINT(); if (state.failed) return;

				}
				break;
			case 46 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:324: STRING_LITERAL
				{
				mSTRING_LITERAL(); if (state.failed) return;

				}
				break;
			case 47 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:339: WS
				{
				mWS(); if (state.failed) return;

				}
				break;
			case 48 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:1:342: ERRCHAR
				{
				mERRCHAR(); if (state.failed) return;

				}
				break;

		}
	}

	// $ANTLR start synpred1_ANTLRLexer
	public final void synpred1_ANTLRLexer_fragment() throws RecognitionException {
		// org\\antlr\\v4\\parse\\ANTLRLexer.g:214:17: ( ' $ANTLR' )
		// org\\antlr\\v4\\parse\\ANTLRLexer.g:214:18: ' $ANTLR'
		{
		match(" $ANTLR"); if (state.failed) return;

		}

	}
	// $ANTLR end synpred1_ANTLRLexer

	// $ANTLR start synpred2_ANTLRLexer
	public final void synpred2_ANTLRLexer_fragment() throws RecognitionException {
		// org\\antlr\\v4\\parse\\ANTLRLexer.g:308:14: ( '\"' )
		// org\\antlr\\v4\\parse\\ANTLRLexer.g:308:15: '\"'
		{
		match('\"'); if (state.failed) return;
		}

	}
	// $ANTLR end synpred2_ANTLRLexer

	// $ANTLR start synpred3_ANTLRLexer
	public final void synpred3_ANTLRLexer_fragment() throws RecognitionException {
		// org\\antlr\\v4\\parse\\ANTLRLexer.g:310:14: ( '\\'' )
		// org\\antlr\\v4\\parse\\ANTLRLexer.g:310:15: '\\''
		{
		match('\''); if (state.failed) return;
		}

	}
	// $ANTLR end synpred3_ANTLRLexer

	// $ANTLR start synpred4_ANTLRLexer
	public final void synpred4_ANTLRLexer_fragment() throws RecognitionException {
		// org\\antlr\\v4\\parse\\ANTLRLexer.g:332:6: ( ( WSNLCHARS )* '=>' )
		// org\\antlr\\v4\\parse\\ANTLRLexer.g:332:7: ( WSNLCHARS )* '=>'
		{
		// org\\antlr\\v4\\parse\\ANTLRLexer.g:332:7: ( WSNLCHARS )*
		loop33:
		while (true) {
			int alt33=2;
			switch ( input.LA(1) ) {
			case '\t':
			case '\n':
			case '\f':
			case '\r':
			case ' ':
				{
				alt33=1;
				}
				break;
			}
			switch (alt33) {
			case 1 :
				// org\\antlr\\v4\\parse\\ANTLRLexer.g:
				{
				if ( (input.LA(1) >= '\t' && input.LA(1) <= '\n')||(input.LA(1) >= '\f' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
					input.consume();
					state.failed=false;
				}
				else {
					if (state.backtracking>0) {state.failed=true; return;}
					MismatchedSetException mse = new MismatchedSetException(null,input);
					recover(mse);
					throw mse;
				}
				}
				break;

			default :
				break loop33;
			}
		}

		match("=>"); if (state.failed) return;

		}

	}
	// $ANTLR end synpred4_ANTLRLexer

	// $ANTLR start synpred5_ANTLRLexer
	public final void synpred5_ANTLRLexer_fragment() throws RecognitionException {
		// org\\antlr\\v4\\parse\\ANTLRLexer.g:562:10: ( '\\\\' )
		// org\\antlr\\v4\\parse\\ANTLRLexer.g:562:11: '\\\\'
		{
		match('\\'); if (state.failed) return;
		}

	}
	// $ANTLR end synpred5_ANTLRLexer

	// $ANTLR start synpred6_ANTLRLexer
	public final void synpred6_ANTLRLexer_fragment() throws RecognitionException {
		// org\\antlr\\v4\\parse\\ANTLRLexer.g:572:9: ( '\\\\' )
		// org\\antlr\\v4\\parse\\ANTLRLexer.g:572:10: '\\\\'
		{
		match('\\'); if (state.failed) return;
		}

	}
	// $ANTLR end synpred6_ANTLRLexer

	public final boolean synpred5_ANTLRLexer() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred5_ANTLRLexer_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred4_ANTLRLexer() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred4_ANTLRLexer_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred3_ANTLRLexer() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred3_ANTLRLexer_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred1_ANTLRLexer() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred1_ANTLRLexer_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred2_ANTLRLexer() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred2_ANTLRLexer_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred6_ANTLRLexer() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred6_ANTLRLexer_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}


	protected DFA2 dfa2 = new DFA2(this);
	protected DFA32 dfa32 = new DFA32(this);
	static final String DFA2_eotS =
		"\2\2\1\uffff\16\2\1\uffff\3\2\1\uffff\2\2\2\uffff";
	static final String DFA2_eofS =
		"\32\uffff";
	static final String DFA2_minS =
		"\1\40\1\44\1\uffff\1\101\1\116\1\124\1\114\1\122\1\163\1\162\1\143\2\11"+
		"\3\0\1\11\1\uffff\3\0\1\uffff\1\11\3\0";
	static final String DFA2_maxS =
		"\1\40\1\44\1\uffff\1\101\1\116\1\124\1\114\1\122\1\163\1\162\1\143\1\40"+
		"\1\42\3\uffff\1\40\1\uffff\3\uffff\1\uffff\1\71\1\uffff\2\0";
	static final String DFA2_acceptS =
		"\2\uffff\1\2\16\uffff\1\1\3\uffff\1\1\4\uffff";
	static final String DFA2_specialS =
		"\15\uffff\1\0\1\1\1\10\2\uffff\1\4\1\6\1\3\2\uffff\1\2\1\5\1\7}>";
	static final String[] DFA2_transitionS = {
			"\1\1",
			"\1\3",
			"",
			"\1\4",
			"\1\5",
			"\1\6",
			"\1\7",
			"\1\10",
			"\1\11",
			"\1\12",
			"\1\13",
			"\1\14\2\uffff\1\14\23\uffff\1\14",
			"\1\14\2\uffff\1\14\23\uffff\1\14\1\uffff\1\15",
			"\12\17\1\21\2\17\1\21\24\17\1\20\71\17\1\16\uffa3\17",
			"\12\24\1\25\2\24\1\25\24\24\1\22\71\24\1\23\uffa3\24",
			"\12\17\1\21\2\17\1\21\24\17\1\20\71\17\1\16\uffa3\17",
			"\1\26\2\uffff\1\26\23\uffff\1\26",
			"",
			"\11\17\1\27\1\21\1\17\1\27\1\21\22\17\1\27\1\17\1\20\71\17\1\16\uffa3"+
			"\17",
			"\12\24\1\25\2\24\1\25\24\24\1\22\71\24\1\23\uffa3\24",
			"\12\17\1\21\2\17\1\21\24\17\1\20\71\17\1\16\uffa3\17",
			"",
			"\1\26\2\uffff\1\26\23\uffff\1\26\17\uffff\12\30",
			"\11\17\1\27\1\21\1\17\1\27\1\21\22\17\1\27\1\17\1\20\15\17\12\31\42"+
			"\17\1\16\uffa3\17",
			"\1\uffff",
			"\1\uffff"
	};

	static final short[] DFA2_eot = DFA.unpackEncodedString(DFA2_eotS);
	static final short[] DFA2_eof = DFA.unpackEncodedString(DFA2_eofS);
	static final char[] DFA2_min = DFA.unpackEncodedStringToUnsignedChars(DFA2_minS);
	static final char[] DFA2_max = DFA.unpackEncodedStringToUnsignedChars(DFA2_maxS);
	static final short[] DFA2_accept = DFA.unpackEncodedString(DFA2_acceptS);
	static final short[] DFA2_special = DFA.unpackEncodedString(DFA2_specialS);
	static final short[][] DFA2_transition;

	static {
		int numStates = DFA2_transitionS.length;
		DFA2_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA2_transition[i] = DFA.unpackEncodedString(DFA2_transitionS[i]);
		}
	}

	protected class DFA2 extends DFA {

		public DFA2(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 2;
			this.eot = DFA2_eot;
			this.eof = DFA2_eof;
			this.min = DFA2_min;
			this.max = DFA2_max;
			this.accept = DFA2_accept;
			this.special = DFA2_special;
			this.transition = DFA2_transition;
		}
		@Override
		public String getDescription() {
			return "213:13: ( ( ' $ANTLR' )=> ' $ANTLR' SRC | (~ ( NLCHARS ) )* )";
		}
		@Override
		public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
			IntStream input = _input;
			int _s = s;
			switch ( s ) {
					case 0 : 
						int LA2_13 = input.LA(1);
						 
						int index2_13 = input.index();
						input.rewind();
						s = -1;
						if ( (LA2_13=='\\') ) {s = 14;}
						else if ( ((LA2_13 >= '\u0000' && LA2_13 <= '\t')||(LA2_13 >= '\u000B' && LA2_13 <= '\f')||(LA2_13 >= '\u000E' && LA2_13 <= '!')||(LA2_13 >= '#' && LA2_13 <= '[')||(LA2_13 >= ']' && LA2_13 <= '\uFFFF')) ) {s = 15;}
						else if ( (LA2_13=='\"') ) {s = 16;}
						else if ( (LA2_13=='\n'||LA2_13=='\r') && (synpred1_ANTLRLexer())) {s = 17;}
						else s = 2;
						 
						input.seek(index2_13);
						if ( s>=0 ) return s;
						break;

					case 1 : 
						int LA2_14 = input.LA(1);
						 
						int index2_14 = input.index();
						input.rewind();
						s = -1;
						if ( (LA2_14=='\"') ) {s = 18;}
						else if ( (LA2_14=='\\') ) {s = 19;}
						else if ( ((LA2_14 >= '\u0000' && LA2_14 <= '\t')||(LA2_14 >= '\u000B' && LA2_14 <= '\f')||(LA2_14 >= '\u000E' && LA2_14 <= '!')||(LA2_14 >= '#' && LA2_14 <= '[')||(LA2_14 >= ']' && LA2_14 <= '\uFFFF')) ) {s = 20;}
						else if ( (LA2_14=='\n'||LA2_14=='\r') && (synpred1_ANTLRLexer())) {s = 21;}
						else s = 2;
						 
						input.seek(index2_14);
						if ( s>=0 ) return s;
						break;

					case 2 : 
						int LA2_23 = input.LA(1);
						 
						int index2_23 = input.index();
						input.rewind();
						s = -1;
						if ( (LA2_23=='\"') ) {s = 16;}
						else if ( (LA2_23=='\\') ) {s = 14;}
						else if ( ((LA2_23 >= '0' && LA2_23 <= '9')) ) {s = 25;}
						else if ( (LA2_23=='\t'||LA2_23=='\f'||LA2_23==' ') ) {s = 23;}
						else if ( ((LA2_23 >= '\u0000' && LA2_23 <= '\b')||LA2_23=='\u000B'||(LA2_23 >= '\u000E' && LA2_23 <= '\u001F')||LA2_23=='!'||(LA2_23 >= '#' && LA2_23 <= '/')||(LA2_23 >= ':' && LA2_23 <= '[')||(LA2_23 >= ']' && LA2_23 <= '\uFFFF')) ) {s = 15;}
						else if ( (LA2_23=='\n'||LA2_23=='\r') && (synpred1_ANTLRLexer())) {s = 17;}
						else s = 2;
						 
						input.seek(index2_23);
						if ( s>=0 ) return s;
						break;

					case 3 : 
						int LA2_20 = input.LA(1);
						 
						int index2_20 = input.index();
						input.rewind();
						s = -1;
						if ( (LA2_20=='\"') ) {s = 16;}
						else if ( (LA2_20=='\\') ) {s = 14;}
						else if ( ((LA2_20 >= '\u0000' && LA2_20 <= '\t')||(LA2_20 >= '\u000B' && LA2_20 <= '\f')||(LA2_20 >= '\u000E' && LA2_20 <= '!')||(LA2_20 >= '#' && LA2_20 <= '[')||(LA2_20 >= ']' && LA2_20 <= '\uFFFF')) ) {s = 15;}
						else if ( (LA2_20=='\n'||LA2_20=='\r') && (synpred1_ANTLRLexer())) {s = 17;}
						else s = 2;
						 
						input.seek(index2_20);
						if ( s>=0 ) return s;
						break;

					case 4 : 
						int LA2_18 = input.LA(1);
						 
						int index2_18 = input.index();
						input.rewind();
						s = -1;
						if ( (LA2_18=='\"') ) {s = 16;}
						else if ( (LA2_18=='\\') ) {s = 14;}
						else if ( (LA2_18=='\t'||LA2_18=='\f'||LA2_18==' ') ) {s = 23;}
						else if ( ((LA2_18 >= '\u0000' && LA2_18 <= '\b')||LA2_18=='\u000B'||(LA2_18 >= '\u000E' && LA2_18 <= '\u001F')||LA2_18=='!'||(LA2_18 >= '#' && LA2_18 <= '[')||(LA2_18 >= ']' && LA2_18 <= '\uFFFF')) ) {s = 15;}
						else if ( (LA2_18=='\n'||LA2_18=='\r') && (synpred1_ANTLRLexer())) {s = 17;}
						else s = 2;
						 
						input.seek(index2_18);
						if ( s>=0 ) return s;
						break;

					case 5 : 
						int LA2_24 = input.LA(1);
						 
						int index2_24 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred1_ANTLRLexer()) ) {s = 21;}
						else if ( (true) ) {s = 2;}
						 
						input.seek(index2_24);
						if ( s>=0 ) return s;
						break;

					case 6 : 
						int LA2_19 = input.LA(1);
						 
						int index2_19 = input.index();
						input.rewind();
						s = -1;
						if ( (LA2_19=='\"') ) {s = 18;}
						else if ( (LA2_19=='\\') ) {s = 19;}
						else if ( ((LA2_19 >= '\u0000' && LA2_19 <= '\t')||(LA2_19 >= '\u000B' && LA2_19 <= '\f')||(LA2_19 >= '\u000E' && LA2_19 <= '!')||(LA2_19 >= '#' && LA2_19 <= '[')||(LA2_19 >= ']' && LA2_19 <= '\uFFFF')) ) {s = 20;}
						else if ( (LA2_19=='\n'||LA2_19=='\r') && (synpred1_ANTLRLexer())) {s = 21;}
						else s = 2;
						 
						input.seek(index2_19);
						if ( s>=0 ) return s;
						break;

					case 7 : 
						int LA2_25 = input.LA(1);
						 
						int index2_25 = input.index();
						input.rewind();
						s = -1;
						if ( (synpred1_ANTLRLexer()) ) {s = 21;}
						else if ( (true) ) {s = 2;}
						 
						input.seek(index2_25);
						if ( s>=0 ) return s;
						break;

					case 8 : 
						int LA2_15 = input.LA(1);
						 
						int index2_15 = input.index();
						input.rewind();
						s = -1;
						if ( (LA2_15=='\"') ) {s = 16;}
						else if ( (LA2_15=='\\') ) {s = 14;}
						else if ( ((LA2_15 >= '\u0000' && LA2_15 <= '\t')||(LA2_15 >= '\u000B' && LA2_15 <= '\f')||(LA2_15 >= '\u000E' && LA2_15 <= '!')||(LA2_15 >= '#' && LA2_15 <= '[')||(LA2_15 >= ']' && LA2_15 <= '\uFFFF')) ) {s = 15;}
						else if ( (LA2_15=='\n'||LA2_15=='\r') && (synpred1_ANTLRLexer())) {s = 17;}
						else s = 2;
						 
						input.seek(index2_15);
						if ( s>=0 ) return s;
						break;
			}
			if (state.backtracking>0) {state.failed=true; return -1;}
			NoViableAltException nvae =
				new NoViableAltException(getDescription(), 2, _s, input);
			error(nvae);
			throw nvae;
		}
	}

	static final String DFA32_eotS =
		"\2\uffff\1\45\1\uffff\12\52\1\73\4\uffff\1\45\2\uffff\1\104\2\uffff\1"+
		"\110\2\uffff\1\114\6\uffff\1\45\5\uffff\1\52\1\uffff\17\52\32\uffff\41"+
		"\52\1\u0087\2\52\1\uffff\5\52\1\u008f\7\52\1\u0097\1\uffff\3\52\1\u009b"+
		"\1\u009c\2\52\1\uffff\1\u009f\1\u00a0\2\52\1\u00a3\2\52\1\uffff\1\52\1"+
		"\uffff\1\52\2\uffff\1\52\1\u00a9\2\uffff\1\52\1\u00ab\1\uffff\1\u00ac"+
		"\1\u00ad\1\uffff\1\52\1\u00af\1\uffff\1\52\3\uffff\1\52\1\uffff\1\u00b2"+
		"\1\52\1\uffff\1\170";
	static final String DFA32_eofS =
		"\u00b4\uffff";
	static final String DFA32_minS =
		"\1\0\1\uffff\1\0\1\uffff\1\160\1\150\1\155\1\151\1\145\1\141\1\162\1\145"+
		"\1\141\1\157\1\72\4\uffff\1\76\2\uffff\1\76\2\uffff\1\75\2\uffff\1\56"+
		"\6\uffff\1\0\5\uffff\1\164\1\uffff\1\153\1\145\1\162\1\160\1\141\1\156"+
		"\1\170\1\143\1\162\1\151\1\142\1\141\2\164\1\144\32\uffff\1\151\2\145"+
		"\2\157\1\147\1\141\1\145\1\141\1\163\1\164\1\166\1\154\1\155\1\165\1\143"+
		"\1\145\1\157\1\156\1\11\1\167\1\162\1\155\1\154\1\162\1\154\2\145\1\141"+
		"\1\151\1\155\1\162\1\150\1\60\1\156\1\163\1\uffff\1\162\1\163\1\164\1"+
		"\145\1\154\1\60\1\163\1\162\1\143\1\164\1\143\1\141\1\156\1\60\1\uffff"+
		"\1\163\1\11\1\141\2\60\1\156\1\171\1\uffff\2\60\1\164\1\145\1\60\1\162"+
		"\1\163\1\uffff\1\11\1\uffff\1\155\2\uffff\1\164\1\60\2\uffff\1\145\1\60"+
		"\1\uffff\2\60\1\uffff\1\155\1\60\1\uffff\1\144\3\uffff\1\141\1\uffff\1"+
		"\60\1\162\1\uffff\1\60";
	static final String DFA32_maxS =
		"\1\uffff\1\uffff\1\uffff\1\uffff\1\160\1\162\1\155\1\162\1\157\1\165\1"+
		"\162\1\145\1\141\1\157\1\72\4\uffff\1\76\2\uffff\1\76\2\uffff\1\75\2\uffff"+
		"\1\56\6\uffff\1\uffff\5\uffff\1\164\1\uffff\1\153\1\145\1\162\1\160\1"+
		"\141\1\156\1\170\1\143\1\162\1\157\1\142\1\141\2\164\1\144\32\uffff\1"+
		"\151\2\145\2\157\1\147\1\141\1\145\1\141\1\163\1\164\1\166\1\154\1\155"+
		"\1\165\1\143\1\145\1\157\1\156\1\147\1\167\1\162\1\155\1\154\1\162\1\154"+
		"\2\145\1\141\1\151\1\155\1\162\1\150\1\ufffd\1\156\1\163\1\uffff\1\162"+
		"\1\163\1\164\1\145\1\154\1\ufffd\1\163\1\162\1\143\1\164\1\143\1\141\1"+
		"\156\1\ufffd\1\uffff\1\163\1\173\1\141\2\ufffd\1\156\1\171\1\uffff\2\ufffd"+
		"\1\164\1\145\1\ufffd\1\162\1\163\1\uffff\1\173\1\uffff\1\155\2\uffff\1"+
		"\164\1\ufffd\2\uffff\1\145\1\ufffd\1\uffff\2\ufffd\1\uffff\1\155\1\ufffd"+
		"\1\uffff\1\144\3\uffff\1\141\1\uffff\1\ufffd\1\162\1\uffff\1\ufffd";
	static final String DFA32_acceptS =
		"\1\uffff\1\1\1\uffff\1\3\13\uffff\1\27\1\30\1\31\1\32\1\uffff\1\34\1\35"+
		"\1\uffff\1\37\1\41\1\uffff\1\44\1\45\1\uffff\1\50\1\51\1\52\1\53\1\54"+
		"\1\55\1\uffff\1\57\1\60\1\1\1\2\1\3\1\uffff\1\54\17\uffff\1\26\1\25\1"+
		"\27\1\30\1\31\1\32\1\33\1\34\1\35\1\40\1\36\1\37\1\41\1\43\1\42\1\44\1"+
		"\45\1\47\1\46\1\50\1\51\1\52\1\53\1\55\1\56\1\57\44\uffff\1\13\16\uffff"+
		"\1\24\7\uffff\1\10\7\uffff\1\22\1\uffff\1\5\1\uffff\1\21\1\6\2\uffff\1"+
		"\20\1\11\2\uffff\1\15\2\uffff\1\4\2\uffff\1\23\1\uffff\1\16\1\12\1\17"+
		"\1\uffff\1\7\2\uffff\1\14\1\uffff";
	static final String DFA32_specialS =
		"\1\0\1\uffff\1\1\40\uffff\1\2\u0090\uffff}>";
	static final String[] DFA32_transitionS = {
			"\11\45\2\44\1\45\2\44\22\45\1\44\2\45\1\36\1\33\2\45\1\43\1\21\1\22\1"+
			"\30\1\31\1\17\1\23\1\34\1\1\12\42\1\16\1\20\1\24\1\26\1\25\1\27\1\35"+
			"\32\41\1\2\5\45\2\41\1\14\2\41\1\7\1\12\1\41\1\6\2\41\1\10\1\15\1\41"+
			"\1\4\1\11\1\41\1\13\1\41\1\5\6\41\1\3\1\32\1\40\1\37\101\45\27\41\1\45"+
			"\37\41\1\45\u0208\41\160\45\16\41\1\45\u1c81\41\14\45\2\41\142\45\u0120"+
			"\41\u0a70\45\u03f0\41\21\45\ua7ff\41\u2100\45\u04d0\41\40\45\u020e\41"+
			"\2\45",
			"",
			"\0\47",
			"",
			"\1\51",
			"\1\55\6\uffff\1\53\2\uffff\1\54",
			"\1\56",
			"\1\60\10\uffff\1\57",
			"\1\61\11\uffff\1\62",
			"\1\63\20\uffff\1\64\2\uffff\1\65",
			"\1\66",
			"\1\67",
			"\1\70",
			"\1\71",
			"\1\72",
			"",
			"",
			"",
			"",
			"\1\100",
			"",
			"",
			"\1\103",
			"",
			"",
			"\1\107",
			"",
			"",
			"\1\113",
			"",
			"",
			"",
			"",
			"",
			"",
			"\0\122",
			"",
			"",
			"",
			"",
			"",
			"\1\124",
			"",
			"\1\125",
			"\1\126",
			"\1\127",
			"\1\130",
			"\1\131",
			"\1\132",
			"\1\133",
			"\1\134",
			"\1\135",
			"\1\137\5\uffff\1\136",
			"\1\140",
			"\1\141",
			"\1\142",
			"\1\143",
			"\1\144",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\145",
			"\1\146",
			"\1\147",
			"\1\150",
			"\1\151",
			"\1\152",
			"\1\153",
			"\1\154",
			"\1\155",
			"\1\156",
			"\1\157",
			"\1\160",
			"\1\161",
			"\1\162",
			"\1\163",
			"\1\164",
			"\1\165",
			"\1\166",
			"\1\167",
			"\2\170\1\uffff\2\170\22\uffff\1\170\106\uffff\1\171",
			"\1\172",
			"\1\173",
			"\1\174",
			"\1\175",
			"\1\176",
			"\1\177",
			"\1\u0080",
			"\1\u0081",
			"\1\u0082",
			"\1\u0083",
			"\1\u0084",
			"\1\u0085",
			"\1\u0086",
			"\12\52\7\uffff\32\52\4\uffff\1\52\1\uffff\32\52\74\uffff\1\52\10\uffff"+
			"\27\52\1\uffff\37\52\1\uffff\u0286\52\1\uffff\u1c81\52\14\uffff\2\52"+
			"\61\uffff\2\52\57\uffff\u0120\52\u0a70\uffff\u03f0\52\21\uffff\ua7ff"+
			"\52\u2100\uffff\u04d0\52\40\uffff\u020e\52",
			"\1\u0088",
			"\1\u0089",
			"",
			"\1\u008a",
			"\1\u008b",
			"\1\u008c",
			"\1\u008d",
			"\1\u008e",
			"\12\52\7\uffff\32\52\4\uffff\1\52\1\uffff\32\52\74\uffff\1\52\10\uffff"+
			"\27\52\1\uffff\37\52\1\uffff\u0286\52\1\uffff\u1c81\52\14\uffff\2\52"+
			"\61\uffff\2\52\57\uffff\u0120\52\u0a70\uffff\u03f0\52\21\uffff\ua7ff"+
			"\52\u2100\uffff\u04d0\52\40\uffff\u020e\52",
			"\1\u0090",
			"\1\u0091",
			"\1\u0092",
			"\1\u0093",
			"\1\u0094",
			"\1\u0095",
			"\1\u0096",
			"\12\52\7\uffff\32\52\4\uffff\1\52\1\uffff\32\52\74\uffff\1\52\10\uffff"+
			"\27\52\1\uffff\37\52\1\uffff\u0286\52\1\uffff\u1c81\52\14\uffff\2\52"+
			"\61\uffff\2\52\57\uffff\u0120\52\u0a70\uffff\u03f0\52\21\uffff\ua7ff"+
			"\52\u2100\uffff\u04d0\52\40\uffff\u020e\52",
			"",
			"\1\u0098",
			"\2\u0099\1\uffff\2\u0099\22\uffff\1\u0099\132\uffff\1\u0099",
			"\1\u009a",
			"\12\52\7\uffff\32\52\4\uffff\1\52\1\uffff\32\52\74\uffff\1\52\10\uffff"+
			"\27\52\1\uffff\37\52\1\uffff\u0286\52\1\uffff\u1c81\52\14\uffff\2\52"+
			"\61\uffff\2\52\57\uffff\u0120\52\u0a70\uffff\u03f0\52\21\uffff\ua7ff"+
			"\52\u2100\uffff\u04d0\52\40\uffff\u020e\52",
			"\12\52\7\uffff\32\52\4\uffff\1\52\1\uffff\32\52\74\uffff\1\52\10\uffff"+
			"\27\52\1\uffff\37\52\1\uffff\u0286\52\1\uffff\u1c81\52\14\uffff\2\52"+
			"\61\uffff\2\52\57\uffff\u0120\52\u0a70\uffff\u03f0\52\21\uffff\ua7ff"+
			"\52\u2100\uffff\u04d0\52\40\uffff\u020e\52",
			"\1\u009d",
			"\1\u009e",
			"",
			"\12\52\7\uffff\32\52\4\uffff\1\52\1\uffff\32\52\74\uffff\1\52\10\uffff"+
			"\27\52\1\uffff\37\52\1\uffff\u0286\52\1\uffff\u1c81\52\14\uffff\2\52"+
			"\61\uffff\2\52\57\uffff\u0120\52\u0a70\uffff\u03f0\52\21\uffff\ua7ff"+
			"\52\u2100\uffff\u04d0\52\40\uffff\u020e\52",
			"\12\52\7\uffff\32\52\4\uffff\1\52\1\uffff\32\52\74\uffff\1\52\10\uffff"+
			"\27\52\1\uffff\37\52\1\uffff\u0286\52\1\uffff\u1c81\52\14\uffff\2\52"+
			"\61\uffff\2\52\57\uffff\u0120\52\u0a70\uffff\u03f0\52\21\uffff\ua7ff"+
			"\52\u2100\uffff\u04d0\52\40\uffff\u020e\52",
			"\1\u00a1",
			"\1\u00a2",
			"\12\52\7\uffff\32\52\4\uffff\1\52\1\uffff\32\52\74\uffff\1\52\10\uffff"+
			"\27\52\1\uffff\37\52\1\uffff\u0286\52\1\uffff\u1c81\52\14\uffff\2\52"+
			"\61\uffff\2\52\57\uffff\u0120\52\u0a70\uffff\u03f0\52\21\uffff\ua7ff"+
			"\52\u2100\uffff\u04d0\52\40\uffff\u020e\52",
			"\1\u00a4",
			"\1\u00a5",
			"",
			"\2\u00a6\1\uffff\2\u00a6\22\uffff\1\u00a6\132\uffff\1\u00a6",
			"",
			"\1\u00a7",
			"",
			"",
			"\1\u00a8",
			"\12\52\7\uffff\32\52\4\uffff\1\52\1\uffff\32\52\74\uffff\1\52\10\uffff"+
			"\27\52\1\uffff\37\52\1\uffff\u0286\52\1\uffff\u1c81\52\14\uffff\2\52"+
			"\61\uffff\2\52\57\uffff\u0120\52\u0a70\uffff\u03f0\52\21\uffff\ua7ff"+
			"\52\u2100\uffff\u04d0\52\40\uffff\u020e\52",
			"",
			"",
			"\1\u00aa",
			"\12\52\7\uffff\32\52\4\uffff\1\52\1\uffff\32\52\74\uffff\1\52\10\uffff"+
			"\27\52\1\uffff\37\52\1\uffff\u0286\52\1\uffff\u1c81\52\14\uffff\2\52"+
			"\61\uffff\2\52\57\uffff\u0120\52\u0a70\uffff\u03f0\52\21\uffff\ua7ff"+
			"\52\u2100\uffff\u04d0\52\40\uffff\u020e\52",
			"",
			"\12\52\7\uffff\32\52\4\uffff\1\52\1\uffff\32\52\74\uffff\1\52\10\uffff"+
			"\27\52\1\uffff\37\52\1\uffff\u0286\52\1\uffff\u1c81\52\14\uffff\2\52"+
			"\61\uffff\2\52\57\uffff\u0120\52\u0a70\uffff\u03f0\52\21\uffff\ua7ff"+
			"\52\u2100\uffff\u04d0\52\40\uffff\u020e\52",
			"\12\52\7\uffff\32\52\4\uffff\1\52\1\uffff\32\52\74\uffff\1\52\10\uffff"+
			"\27\52\1\uffff\37\52\1\uffff\u0286\52\1\uffff\u1c81\52\14\uffff\2\52"+
			"\61\uffff\2\52\57\uffff\u0120\52\u0a70\uffff\u03f0\52\21\uffff\ua7ff"+
			"\52\u2100\uffff\u04d0\52\40\uffff\u020e\52",
			"",
			"\1\u00ae",
			"\12\52\7\uffff\32\52\4\uffff\1\52\1\uffff\32\52\74\uffff\1\52\10\uffff"+
			"\27\52\1\uffff\37\52\1\uffff\u0286\52\1\uffff\u1c81\52\14\uffff\2\52"+
			"\61\uffff\2\52\57\uffff\u0120\52\u0a70\uffff\u03f0\52\21\uffff\ua7ff"+
			"\52\u2100\uffff\u04d0\52\40\uffff\u020e\52",
			"",
			"\1\u00b0",
			"",
			"",
			"",
			"\1\u00b1",
			"",
			"\12\52\7\uffff\32\52\4\uffff\1\52\1\uffff\32\52\74\uffff\1\52\10\uffff"+
			"\27\52\1\uffff\37\52\1\uffff\u0286\52\1\uffff\u1c81\52\14\uffff\2\52"+
			"\61\uffff\2\52\57\uffff\u0120\52\u0a70\uffff\u03f0\52\21\uffff\ua7ff"+
			"\52\u2100\uffff\u04d0\52\40\uffff\u020e\52",
			"\1\u00b3",
			"",
			"\12\52\7\uffff\32\52\4\uffff\1\52\1\uffff\32\52\74\uffff\1\52\10\uffff"+
			"\27\52\1\uffff\37\52\1\uffff\u0286\52\1\uffff\u1c81\52\14\uffff\2\52"+
			"\61\uffff\2\52\57\uffff\u0120\52\u0a70\uffff\u03f0\52\21\uffff\ua7ff"+
			"\52\u2100\uffff\u04d0\52\40\uffff\u020e\52"
	};

	static final short[] DFA32_eot = DFA.unpackEncodedString(DFA32_eotS);
	static final short[] DFA32_eof = DFA.unpackEncodedString(DFA32_eofS);
	static final char[] DFA32_min = DFA.unpackEncodedStringToUnsignedChars(DFA32_minS);
	static final char[] DFA32_max = DFA.unpackEncodedStringToUnsignedChars(DFA32_maxS);
	static final short[] DFA32_accept = DFA.unpackEncodedString(DFA32_acceptS);
	static final short[] DFA32_special = DFA.unpackEncodedString(DFA32_specialS);
	static final short[][] DFA32_transition;

	static {
		int numStates = DFA32_transitionS.length;
		DFA32_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA32_transition[i] = DFA.unpackEncodedString(DFA32_transitionS[i]);
		}
	}

	protected class DFA32 extends DFA {

		public DFA32(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 32;
			this.eot = DFA32_eot;
			this.eof = DFA32_eof;
			this.min = DFA32_min;
			this.max = DFA32_max;
			this.accept = DFA32_accept;
			this.special = DFA32_special;
			this.transition = DFA32_transition;
		}
		@Override
		public String getDescription() {
			return "1:1: Tokens : ( COMMENT | ARG_OR_CHARSET | ACTION | OPTIONS | TOKENS_SPEC | IMPORT | FRAGMENT | LEXER | PARSER | GRAMMAR | TREE_GRAMMAR | PROTECTED | PUBLIC | PRIVATE | RETURNS | LOCALS | THROWS | CATCH | FINALLY | MODE | COLON | COLONCOLON | COMMA | SEMI | LPAREN | RPAREN | RARROW | LT | GT | ASSIGN | QUESTION | SYNPRED | STAR | PLUS | PLUS_ASSIGN | OR | DOLLAR | DOT | RANGE | AT | POUND | NOT | RBRACE | ID | INT | STRING_LITERAL | WS | ERRCHAR );";
		}
		@Override
		public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
			IntStream input = _input;
			int _s = s;
			switch ( s ) {
					case 0 : 
						int LA32_0 = input.LA(1);
						s = -1;
						if ( (LA32_0=='/') ) {s = 1;}
						else if ( (LA32_0=='[') ) {s = 2;}
						else if ( (LA32_0=='{') ) {s = 3;}
						else if ( (LA32_0=='o') ) {s = 4;}
						else if ( (LA32_0=='t') ) {s = 5;}
						else if ( (LA32_0=='i') ) {s = 6;}
						else if ( (LA32_0=='f') ) {s = 7;}
						else if ( (LA32_0=='l') ) {s = 8;}
						else if ( (LA32_0=='p') ) {s = 9;}
						else if ( (LA32_0=='g') ) {s = 10;}
						else if ( (LA32_0=='r') ) {s = 11;}
						else if ( (LA32_0=='c') ) {s = 12;}
						else if ( (LA32_0=='m') ) {s = 13;}
						else if ( (LA32_0==':') ) {s = 14;}
						else if ( (LA32_0==',') ) {s = 15;}
						else if ( (LA32_0==';') ) {s = 16;}
						else if ( (LA32_0=='(') ) {s = 17;}
						else if ( (LA32_0==')') ) {s = 18;}
						else if ( (LA32_0=='-') ) {s = 19;}
						else if ( (LA32_0=='<') ) {s = 20;}
						else if ( (LA32_0=='>') ) {s = 21;}
						else if ( (LA32_0=='=') ) {s = 22;}
						else if ( (LA32_0=='?') ) {s = 23;}
						else if ( (LA32_0=='*') ) {s = 24;}
						else if ( (LA32_0=='+') ) {s = 25;}
						else if ( (LA32_0=='|') ) {s = 26;}
						else if ( (LA32_0=='$') ) {s = 27;}
						else if ( (LA32_0=='.') ) {s = 28;}
						else if ( (LA32_0=='@') ) {s = 29;}
						else if ( (LA32_0=='#') ) {s = 30;}
						else if ( (LA32_0=='~') ) {s = 31;}
						else if ( (LA32_0=='}') ) {s = 32;}
						else if ( ((LA32_0 >= 'A' && LA32_0 <= 'Z')||(LA32_0 >= 'a' && LA32_0 <= 'b')||(LA32_0 >= 'd' && LA32_0 <= 'e')||LA32_0=='h'||(LA32_0 >= 'j' && LA32_0 <= 'k')||LA32_0=='n'||LA32_0=='q'||LA32_0=='s'||(LA32_0 >= 'u' && LA32_0 <= 'z')||(LA32_0 >= '\u00C0' && LA32_0 <= '\u00D6')||(LA32_0 >= '\u00D8' && LA32_0 <= '\u00F6')||(LA32_0 >= '\u00F8' && LA32_0 <= '\u02FF')||(LA32_0 >= '\u0370' && LA32_0 <= '\u037D')||(LA32_0 >= '\u037F' && LA32_0 <= '\u1FFF')||(LA32_0 >= '\u200C' && LA32_0 <= '\u200D')||(LA32_0 >= '\u2070' && LA32_0 <= '\u218F')||(LA32_0 >= '\u2C00' && LA32_0 <= '\u2FEF')||(LA32_0 >= '\u3001' && LA32_0 <= '\uD7FF')||(LA32_0 >= '\uF900' && LA32_0 <= '\uFDCF')||(LA32_0 >= '\uFDF0' && LA32_0 <= '\uFFFD')) ) {s = 33;}
						else if ( ((LA32_0 >= '0' && LA32_0 <= '9')) ) {s = 34;}
						else if ( (LA32_0=='\'') ) {s = 35;}
						else if ( ((LA32_0 >= '\t' && LA32_0 <= '\n')||(LA32_0 >= '\f' && LA32_0 <= '\r')||LA32_0==' ') ) {s = 36;}
						else if ( ((LA32_0 >= '\u0000' && LA32_0 <= '\b')||LA32_0=='\u000B'||(LA32_0 >= '\u000E' && LA32_0 <= '\u001F')||(LA32_0 >= '!' && LA32_0 <= '\"')||(LA32_0 >= '%' && LA32_0 <= '&')||(LA32_0 >= '\\' && LA32_0 <= '`')||(LA32_0 >= '\u007F' && LA32_0 <= '\u00BF')||LA32_0=='\u00D7'||LA32_0=='\u00F7'||(LA32_0 >= '\u0300' && LA32_0 <= '\u036F')||LA32_0=='\u037E'||(LA32_0 >= '\u2000' && LA32_0 <= '\u200B')||(LA32_0 >= '\u200E' && LA32_0 <= '\u206F')||(LA32_0 >= '\u2190' && LA32_0 <= '\u2BFF')||(LA32_0 >= '\u2FF0' && LA32_0 <= '\u3000')||(LA32_0 >= '\uD800' && LA32_0 <= '\uF8FF')||(LA32_0 >= '\uFDD0' && LA32_0 <= '\uFDEF')||(LA32_0 >= '\uFFFE' && LA32_0 <= '\uFFFF')) ) {s = 37;}
						if ( s>=0 ) return s;
						break;

					case 1 : 
						int LA32_2 = input.LA(1);
						 
						int index32_2 = input.index();
						input.rewind();
						s = -1;
						if ( ((LA32_2 >= '\u0000' && LA32_2 <= '\uFFFF')) && (((!isLexerRule)||(isLexerRule)))) {s = 39;}
						else s = 37;
						 
						input.seek(index32_2);
						if ( s>=0 ) return s;
						break;

					case 2 : 
						int LA32_35 = input.LA(1);
						s = -1;
						if ( ((LA32_35 >= '\u0000' && LA32_35 <= '\uFFFF')) ) {s = 82;}
						else s = 37;
						if ( s>=0 ) return s;
						break;
			}
			if (state.backtracking>0) {state.failed=true; return -1;}
			NoViableAltException nvae =
				new NoViableAltException(getDescription(), 32, _s, input);
			error(nvae);
			throw nvae;
		}
	}

}
