/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import org.antlr.v4.analysis.LeftRecursionDetector;
import org.antlr.v4.misc.Utils;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.DecisionState;
import org.antlr.v4.runtime.atn.LL1Analyzer;
import org.antlr.v4.runtime.misc.IntSet;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.tool.Grammar;

public class AnalysisPipeline {
    public Grammar g;

    public AnalysisPipeline(Grammar g) {
        this.g = g;
    }

    public void process() {
        LeftRecursionDetector lr = new LeftRecursionDetector(this.g, this.g.atn);
        lr.check();
        if (!lr.listOfRecursiveCycles.isEmpty()) {
            return;
        }
        if (!this.g.isLexer()) {
            this.processParser();
        }
    }

    void processParser() {
        this.g.decisionLOOK = new ArrayList<IntervalSet[]>(this.g.atn.getNumberOfDecisions() + 1);
        for (DecisionState s : this.g.atn.decisionToState) {
            Object[] look;
            this.g.tool.log("LL1", "\nDECISION " + s.decision + " in rule " + this.g.getRule((int)s.ruleIndex).name);
            if (s.nonGreedy) {
                look = new IntervalSet[s.getNumberOfTransitions() + 1];
            } else {
                LL1Analyzer anal = new LL1Analyzer(this.g.atn);
                look = anal.getDecisionLookahead((ATNState)s);
                this.g.tool.log("LL1", "look=" + Arrays.toString(look));
            }
            Utils.setSize(this.g.decisionLOOK, s.decision + 1);
            this.g.decisionLOOK.set(s.decision, (IntervalSet[])look);
            this.g.tool.log("LL1", "LL(1)? " + AnalysisPipeline.disjoint((IntervalSet[])look));
        }
    }

    public static boolean disjoint(IntervalSet[] altLook) {
        boolean collision = false;
        IntervalSet combined = new IntervalSet(new int[0]);
        if (altLook == null) {
            return false;
        }
        for (int a = 1; a < altLook.length; ++a) {
            IntervalSet look = altLook[a];
            if (look == null) {
                return false;
            }
            if (!look.and((IntSet)combined).isNil()) {
                collision = true;
                break;
            }
            combined.addAll((IntSet)look);
        }
        return !collision;
    }
}

