/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.automata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.ActionTransition;
import org.antlr.v4.runtime.atn.AtomTransition;
import org.antlr.v4.runtime.atn.BlockEndState;
import org.antlr.v4.runtime.atn.BlockStartState;
import org.antlr.v4.runtime.atn.EpsilonTransition;
import org.antlr.v4.runtime.atn.NotSetTransition;
import org.antlr.v4.runtime.atn.PlusBlockStartState;
import org.antlr.v4.runtime.atn.PlusLoopbackState;
import org.antlr.v4.runtime.atn.RuleStartState;
import org.antlr.v4.runtime.atn.RuleStopState;
import org.antlr.v4.runtime.atn.RuleTransition;
import org.antlr.v4.runtime.atn.SetTransition;
import org.antlr.v4.runtime.atn.StarBlockStartState;
import org.antlr.v4.runtime.atn.StarLoopEntryState;
import org.antlr.v4.runtime.atn.StarLoopbackState;
import org.antlr.v4.runtime.atn.Transition;
import org.antlr.v4.tool.Grammar;

public class ATNPrinter {
    List<ATNState> work;
    Set<ATNState> marked;
    Grammar g;
    ATNState start;

    public ATNPrinter(Grammar g, ATNState start) {
        this.g = g;
        this.start = start;
    }

    public String asString() {
        if (this.start == null) {
            return null;
        }
        this.marked = new HashSet<ATNState>();
        this.work = new ArrayList<ATNState>();
        this.work.add(this.start);
        StringBuilder buf = new StringBuilder();
        while (!this.work.isEmpty()) {
            ATNState s = this.work.remove(0);
            if (this.marked.contains(s)) continue;
            int n = s.getNumberOfTransitions();
            this.marked.add(s);
            for (int i = 0; i < n; ++i) {
                ActionTransition a;
                Transition t = s.transition(i);
                if (!(s instanceof RuleStopState)) {
                    if (t instanceof RuleTransition) {
                        this.work.add(((RuleTransition)t).followState);
                    } else {
                        this.work.add(t.target);
                    }
                }
                buf.append(this.getStateString(s));
                if (t instanceof EpsilonTransition) {
                    buf.append("->").append(this.getStateString(t.target)).append('\n');
                    continue;
                }
                if (t instanceof RuleTransition) {
                    buf.append("-").append(this.g.getRule((int)((RuleTransition)t).ruleIndex).name).append("->").append(this.getStateString(t.target)).append('\n');
                    continue;
                }
                if (t instanceof ActionTransition) {
                    a = (ActionTransition)t;
                    buf.append("-").append(a.toString()).append("->").append(this.getStateString(t.target)).append('\n');
                    continue;
                }
                if (t instanceof SetTransition) {
                    SetTransition st = (SetTransition)t;
                    boolean not = st instanceof NotSetTransition;
                    if (this.g.isLexer()) {
                        buf.append("-").append(not ? "~" : "").append(st.toString()).append("->").append(this.getStateString(t.target)).append('\n');
                        continue;
                    }
                    buf.append("-").append(not ? "~" : "").append(st.label().toString(this.g.getTokenNames())).append("->").append(this.getStateString(t.target)).append('\n');
                    continue;
                }
                if (t instanceof AtomTransition) {
                    a = (AtomTransition)t;
                    String label = a.toString();
                    if (this.g != null) {
                        label = this.g.getTokenDisplayName(a.label);
                    }
                    buf.append("-").append(label).append("->").append(this.getStateString(t.target)).append('\n');
                    continue;
                }
                buf.append("-").append(t.toString()).append("->").append(this.getStateString(t.target)).append('\n');
            }
        }
        return buf.toString();
    }

    String getStateString(ATNState s) {
        int n = s.stateNumber;
        String stateStr = "s" + n;
        if (s instanceof StarBlockStartState) {
            stateStr = "StarBlockStart_" + n;
        } else if (s instanceof PlusBlockStartState) {
            stateStr = "PlusBlockStart_" + n;
        } else if (s instanceof BlockStartState) {
            stateStr = "BlockStart_" + n;
        } else if (s instanceof BlockEndState) {
            stateStr = "BlockEnd_" + n;
        } else if (s instanceof RuleStartState) {
            stateStr = "RuleStart_" + this.g.getRule((int)s.ruleIndex).name + "_" + n;
        } else if (s instanceof RuleStopState) {
            stateStr = "RuleStop_" + this.g.getRule((int)s.ruleIndex).name + "_" + n;
        } else if (s instanceof PlusLoopbackState) {
            stateStr = "PlusLoopBack_" + n;
        } else if (s instanceof StarLoopbackState) {
            stateStr = "StarLoopBack_" + n;
        } else if (s instanceof StarLoopEntryState) {
            stateStr = "StarLoopEntry_" + n;
        }
        return stateStr;
    }
}

