/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.codegen;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.antlr.v4.codegen.CodeGenerator;
import org.antlr.v4.codegen.model.RuleFunction;
import org.antlr.v4.misc.Utils;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.Rule;
import org.antlr.v4.tool.ast.GrammarAST;
import org.stringtemplate.v4.ST;

public class Target {
    protected String[] targetCharValueEscape = new String[255];
    public CodeGenerator gen;
    public Set<String> badWords = new HashSet<String>();
    public static String[] javaKeywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};

    public Target(CodeGenerator gen) {
        this.targetCharValueEscape[10] = "\\n";
        this.targetCharValueEscape[13] = "\\r";
        this.targetCharValueEscape[9] = "\\t";
        this.targetCharValueEscape[8] = "\\b";
        this.targetCharValueEscape[12] = "\\f";
        this.targetCharValueEscape[92] = "\\\\";
        this.targetCharValueEscape[39] = "\\'";
        this.targetCharValueEscape[34] = "\\\"";
        this.gen = gen;
        this.addBadWords();
    }

    public void addBadWords() {
        this.badWords.addAll(Arrays.asList(javaKeywords));
        this.badWords.add("rule");
        this.badWords.add("parserRule");
    }

    protected void genFile(Grammar g, ST outputFileST, String fileName) {
        this.gen.write(outputFileST, fileName);
    }

    protected void genListenerFile(Grammar g, ST outputFileST) {
        String fileName = this.gen.getListenerFileName();
        this.gen.write(outputFileST, fileName);
    }

    protected void genRecognizerHeaderFile(Grammar g, ST headerFileST, String extName) {
    }

    public String getTokenTypeAsTargetLabel(Grammar g, int ttype) {
        String name = g.getTokenDisplayName(ttype);
        if (name == null || name.charAt(0) == '\'') {
            return String.valueOf(ttype);
        }
        return name;
    }

    public String[] getTokenTypesAsTargetLabels(Grammar g, int[] ttypes) {
        String[] labels = new String[ttypes.length];
        for (int i = 0; i < ttypes.length; ++i) {
            labels[i] = this.getTokenTypeAsTargetLabel(g, ttypes[i]);
        }
        return labels;
    }

    public String getTargetCharLiteralCharValue(int c) {
        StringBuilder buf = new StringBuilder();
        buf.append('\'');
        if (c < 0) {
            return "'\u0000'";
        }
        if (c < this.targetCharValueEscape.length && this.targetCharValueEscape[c] != null) {
            buf.append(this.targetCharValueEscape[c]);
        } else if (Character.UnicodeBlock.of((char)c) == Character.UnicodeBlock.BASIC_LATIN && !Character.isISOControl((char)c)) {
            buf.append((char)c);
        } else {
            String hex = Integer.toHexString(c | 0x10000).toUpperCase().substring(1, 5);
            buf.append("\\u");
            buf.append(hex);
        }
        buf.append('\'');
        return buf.toString();
    }

    public String getTarget64BitStringFromValue(long word) {
        int numHexDigits = 16;
        StringBuilder buf = new StringBuilder(numHexDigits + 2);
        buf.append("0x");
        String digits = Long.toHexString(word);
        digits = digits.toUpperCase();
        int padding = numHexDigits - digits.length();
        for (int i = 1; i <= padding; ++i) {
            buf.append('0');
        }
        buf.append(digits);
        return buf.toString();
    }

    public String getTargetStringLiteralFromString(String s, boolean quoted) {
        if (s == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (quoted) {
            buf.append('\"');
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\'' && c < this.targetCharValueEscape.length && this.targetCharValueEscape[c] != null) {
                buf.append(this.targetCharValueEscape[c]);
                continue;
            }
            buf.append(c);
        }
        if (quoted) {
            buf.append('\"');
        }
        return buf.toString();
    }

    public String getTargetStringLiteralFromString(String s) {
        return this.getTargetStringLiteralFromString(s, true);
    }

    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator generator, String literal, boolean addQuotes) {
        StringBuilder sb = new StringBuilder();
        String is = literal;
        if (addQuotes) {
            sb.append('\"');
        }
        for (int i = 1; i < is.length() - 1; ++i) {
            if (is.charAt(i) == '\\') {
                switch (is.charAt(i + 1)) {
                    case '\"': 
                    case '\\': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': 
                    case 'u': {
                        sb.append('\\');
                        break;
                    }
                }
                ++i;
            } else if (is.charAt(i) == '\"') {
                sb.append('\\');
            }
            sb.append(is.charAt(i));
        }
        if (addQuotes) {
            sb.append('\"');
        }
        return sb.toString();
    }

    public String encodeIntAsCharEscape(int v) {
        if (v < 0 || v > 65535) {
            throw new IllegalArgumentException(String.format("Cannot encode the specified value: %d", v));
        }
        if (v >= 0 && v < this.targetCharValueEscape.length && this.targetCharValueEscape[v] != null) {
            return this.targetCharValueEscape[v];
        }
        if (!(v < 32 || v >= 127 || Character.isDigit(v) && v != 56 && v != 57)) {
            return String.valueOf((char)v);
        }
        if (v >= 0 && v <= 127) {
            String oct = Integer.toOctalString(v);
            return "\\" + oct;
        }
        String hex = Integer.toHexString(v | 0x10000).substring(1, 5);
        return "\\u" + hex;
    }

    public String getLoopLabel(GrammarAST ast) {
        return "loop" + ast.token.getTokenIndex();
    }

    public String getLoopCounter(GrammarAST ast) {
        return "cnt" + ast.token.getTokenIndex();
    }

    public String getListLabel(String label) {
        ST st = this.gen.templates.getInstanceOf("ListLabelName");
        st.add("label", (Object)label);
        return st.render();
    }

    public String getRuleFunctionContextStructName(Rule r) {
        if (r.g.isLexer()) {
            return this.gen.templates.getInstanceOf("LexerRuleContext").render();
        }
        return Utils.capitalize(r.name) + this.gen.templates.getInstanceOf("RuleContextNameSuffix").render();
    }

    public String getAltLabelContextStructName(String label) {
        return Utils.capitalize(label) + this.gen.templates.getInstanceOf("RuleContextNameSuffix").render();
    }

    public String getRuleFunctionContextStructName(RuleFunction function) {
        Rule r = function.rule;
        if (r.g.isLexer()) {
            return this.gen.templates.getInstanceOf("LexerRuleContext").render();
        }
        return Utils.capitalize(r.name) + this.gen.templates.getInstanceOf("RuleContextNameSuffix").render();
    }

    public String getImplicitTokenLabel(String tokenName) {
        ST st = this.gen.templates.getInstanceOf("ImplicitTokenLabel");
        int ttype = this.gen.g.getTokenType(tokenName);
        if (tokenName.startsWith("'")) {
            return "s" + ttype;
        }
        String text = this.getTokenTypeAsTargetLabel(this.gen.g, ttype);
        st.add("tokenName", (Object)text);
        return st.render();
    }

    public String getImplicitSetLabel(String id) {
        ST st = this.gen.templates.getInstanceOf("ImplicitSetLabel");
        st.add("id", (Object)id);
        return st.render();
    }

    public String getImplicitRuleLabel(String ruleName) {
        ST st = this.gen.templates.getInstanceOf("ImplicitRuleLabel");
        st.add("ruleName", (Object)ruleName);
        return st.render();
    }

    public String getElementListName(String name) {
        ST st = this.gen.templates.getInstanceOf("ElementListName");
        st.add("elemName", (Object)this.getElementName(name));
        return st.render();
    }

    public String getElementName(String name) {
        if (".".equals(name)) {
            return "_wild";
        }
        if (this.gen.g.getRule(name) != null) {
            return name;
        }
        int ttype = this.gen.g.getTokenType(name);
        if (ttype == 0) {
            return name;
        }
        return this.getTokenTypeAsTargetLabel(this.gen.g, ttype);
    }

    public boolean grammarSymbolCausesIssueInGeneratedCode(GrammarAST idNode) {
        switch (idNode.getParent().getType()) {
            case 10: {
                switch (idNode.getParent().getParent().getType()) {
                    case 41: 
                    case 79: {
                        return false;
                    }
                }
                break;
            }
            case 11: 
            case 79: {
                return false;
            }
            case 83: {
                if (idNode.getChildIndex() != 0) break;
                return false;
            }
        }
        return this.badWords.contains(idNode.getText());
    }
}

