/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.parse;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.Tool;
import org.antlr.v4.tool.ErrorType;

public class TokenVocabParser {
    Tool tool;
    String vocabName;

    public TokenVocabParser(Tool tool, String vocabName) {
        this.tool = tool;
        this.vocabName = vocabName;
    }

    public Map<String, Integer> load() {
        LinkedHashMap<String, Integer> tokens = new LinkedHashMap<String, Integer>();
        int maxTokenType = -1;
        File fullFile = this.getImportedVocabFile();
        try {
            Pattern tokenDefPattern = Pattern.compile("([^\n]+?)[ \\t]*?=[ \\t]*?([0-9]+)");
            FileReader fr = new FileReader(fullFile);
            BufferedReader br = new BufferedReader(fr);
            String tokenDef = br.readLine();
            int lineNum = 1;
            while (tokenDef != null) {
                Matcher matcher = tokenDefPattern.matcher(tokenDef);
                if (matcher.find()) {
                    String tokenID = matcher.group(1);
                    String tokenTypeS = matcher.group(2);
                    int tokenType = Integer.valueOf(tokenTypeS);
                    this.tool.log("grammar", "import " + tokenID + "=" + tokenType);
                    tokens.put(tokenID, tokenType);
                    maxTokenType = Math.max(maxTokenType, tokenType);
                    ++lineNum;
                } else if (tokenDef.length() > 0) {
                    this.tool.errMgr.toolError(ErrorType.TOKENS_FILE_SYNTAX_ERROR, this.vocabName + ".tokens", " bad token def: " + tokenDef, lineNum);
                }
                tokenDef = br.readLine();
            }
            br.close();
        }
        catch (FileNotFoundException fnfe) {
            this.tool.errMgr.toolError(ErrorType.CANNOT_FIND_TOKENS_FILE, fullFile);
        }
        catch (IOException ioe) {
            this.tool.errMgr.toolError(ErrorType.ERROR_READING_TOKENS_FILE, fullFile, ioe);
        }
        catch (Exception e) {
            this.tool.errMgr.toolError(ErrorType.ERROR_READING_TOKENS_FILE, fullFile, e);
        }
        return tokens;
    }

    public File getImportedVocabFile() {
        File f = new File(this.tool.libDirectory, File.separator + this.vocabName + ".tokens");
        if (f.exists()) {
            return f;
        }
        f = new File(this.tool.outputDirectory, this.vocabName + ".tokens");
        return f;
    }
}

